package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class MarineLitterBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<MarineLitterBatchUIModel, MarineLitterBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN = "marineLitterTotalWeightField.bean";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL = "marineLitterTotalWeightField.model";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "marineLitterTotalWeightField.numberPattern";
    public static final String BINDING_REMOVE_MARINE_LITTER_BATCH_MENU_ENABLED = "removeMarineLitterBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXT28bRRSfmDhpkobQRi1FTatSimioWLf0UKBQarsOdbDTKDZQyCGMdyf2tOOdZXa2dWUF8RH4CHADiQsSN06IA2cOvSC+AkIcuCLem7V3vc16nbZqpKx2Z977vTfvz++Nf/iL5H1FXr5Dez1LBa7mXWatF2/fvtW6w2x9g/m24p6WioR/UzmS2yYLTrTua/LKdg3VCwP1Qll2Pekyd0T7ao3M+/qBYH6HMa3JqaSG7fuFRrR9tecFaogaOZWG+s0/f+e+dr76NkdIzwPvluAoZyZpxSeZrpEcdzQ5Cpbu0YKgbhvcUNxtg7+LuFYW1Pc3aJd9Qb4kszUy41EFYJqcPfiRDYbR73lwcuZwXadghNW41kyVqLY7TeltUpcJTZq7yuK7inWZsnSgNbcCbvn3wSfLlq4GE5b0mKKaS9eyUZf5VtfgCYNn7QP/qOp5xoEZTWY71HUEU5psPwtDN0P02F6+Kx081qfPwlodsWNbc/eo4A6F2GtyIVEF0cbAZAOfHw8XY4SZlpJ3MTir491t4udNsFsysrHyvKYtwTalF0Caj2P19AYq62axztwglj4J4PIe23cqlNLkWEId16qadVH1RIQwvStVV5MTiZMOfERPUGwukl7pjlhqSk3FJ4y3O7pGW5ifowmDZhEVT0/UX+NMQAuVxgcs0FxYWPUQfhM8bJZAM+eW2pD6BtW0YjaT9g6baDalFC2qHvXP9EpS/tC5cPUifq/i47Vo75StGNX7Y10Cb6D4yHICPFxF1dcjhCXjTcNWUgg0o8mLCZ14Jxn1vNGDbEvVtu4Aa97V0guVetb67ShPBQ+Y62Qik8CJVsyJMWlNbZO8CmAZUr+9n0a3YCsk0BOPECgCmt3/ji8//PnPn9aGrLkAto+lio6QPrCZp7BFNUfTSyFlYm4Ldepd3SZzPhMwMcxEWElxrDHYBufA3hFUD0vjJvU7AJGf/eOXX49//vtzJLdG5oWkzhpF+SqZ0x0FUZDC6XnvXzceHb5/CJ4vwP+sJosOs3mXio2g28LmnboMXEADLQe9WOgPSM9qM12W7i5vn1+1uF8cioSKYRWeX93T5Ig9KFGszrIUyCjpKOYd9oc1HTaFb1AWXYO7SbHgoMyO9m9UytV6sXZ5Z7PYbFa2NkDoUOCzNTgtzJRprQLI9Bwc9f4W81m8tIRLxtVhyV4cc6YGCI4eJ5QHd3pQESspFRGlpTX327/LjR+vD6tiCrL00ljxuDLyn5EZ7grsLJymg0GZOj0XPJ8FjowHYtqIJJCxlSyeGHDoO+Z5bV9BTEHX7XSAnzU51z8bclHqzLVQ6CwEBnE2zInxbZNMGtLeBA+mIasCGXQN6+Z0P4s59zDHrAepfjvL1V2UtcYAabKggSeb3GsapPeeGMnScHWJwlfKDl820vjgZk6iSbHNxVeKc33zgg1QT0c0XTjdYhQa5lKGdKLQItXH8d3kcpLvWJkiHLdWVmA114JZLXwv2ngh8tNcGbluHKAgF0N2BjC8NGnyar/Gfd0YXRRWo7rxQa2y06jUKuVm9ZahJx9qOJxh+V0qgJTIcgQF9c3aSgYuXAAW+4YHrVKtWP5wb1SqRO27Q6mZvhsIkRracFROOko+6pfMEFI7vEiauW+WIGDhYhXvm+SwCe8boQB88ktvuXUXrmQutzW58njYVjfSTHbim4+Jk2i/K9ntl6KeQWiZN6BJQYcZO8tcTI9j+MwUC/e3zA3W4FTC3bDhDp4fFSOk5wcMMZOfHYMWtgNW71b67bk4CArOk70nSuuIS0+V1lGcJ0jrqPr4tGb9iDgAG80I+kCCL+T5d+GHED3T4q4DN9Nr+0xN4XN+IiIuf4eP79MRzj81wgVA+B9zr0WwsxAAAA==";
    private static final Log log = LogFactory.getLog(MarineLitterBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton createMarineLitterBatchButton;
    protected MarineLitterBatchUI editMarineLitterBatchTopPanel = this;
    protected Table form;
    protected MarineLitterBatchUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterTotalWeight",  editorName = "marineLitterTotalWeightField")
    protected TuttiComputedOrNotDataEditor marineLitterTotalWeightField;
    protected JLabel marineLitterTotalWeightLabel;
    protected MarineLitterBatchUIModel model;
    protected JMenuItem removeMarineLitterBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<MarineLitterBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MarineLitterBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            MarineLitterBatchUIHandler handler = new MarineLitterBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public MarineLitterBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI() {
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MarineLitterBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MarineLitterBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createMarineLitterBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateMarineLitterBatchButton() {
        return createMarineLitterBatchButton;
    }

    public Table getForm() {
        return form;
    }

    public MarineLitterBatchUIHandler getHandler() {
        return handler;
    }

    public TuttiComputedOrNotDataEditor getMarineLitterTotalWeightField() {
        return marineLitterTotalWeightField;
    }

    public JLabel getMarineLitterTotalWeightLabel() {
        return marineLitterTotalWeightLabel;
    }

    public MarineLitterBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveMarineLitterBatchMenu() {
        return removeMarineLitterBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<MarineLitterBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditMarineLitterBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(marineLitterTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(marineLitterTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeMarineLitterBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editMarineLitterBatch.help"));
    }

    protected void createCreateMarineLitterBatchButton() {
        $objectMap.put("createMarineLitterBatchButton", createMarineLitterBatchButton = new JButton());
        
        createMarineLitterBatchButton.setName("createMarineLitterBatchButton");
        createMarineLitterBatchButton.setText(_("tutti.editMarineLitterBatch.action.createBatch"));
        createMarineLitterBatchButton.setToolTipText(_("tutti.editMarineLitterBatch.action.createBatch.tip"));
        createMarineLitterBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createMarineLitterBatchButton"));
        createMarineLitterBatchButton.putClientProperty("help", "tutti.editMarineLitterBatch.action.createBatch.help");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MarineLitterBatchUIHandler.class));
    }

    protected void createMarineLitterTotalWeightField() {
        $objectMap.put("marineLitterTotalWeightField", marineLitterTotalWeightField = new TuttiComputedOrNotDataEditor(this));
        
        marineLitterTotalWeightField.setName("marineLitterTotalWeightField");
        marineLitterTotalWeightField.setDecimalNumber(3);
        marineLitterTotalWeightField.setUseFloat(true);
        marineLitterTotalWeightField.setShowReset(true);
    }

    protected void createMarineLitterTotalWeightLabel() {
        $objectMap.put("marineLitterTotalWeightLabel", marineLitterTotalWeightLabel = new JLabel());
        
        marineLitterTotalWeightLabel.setName("marineLitterTotalWeightLabel");
        marineLitterTotalWeightLabel.setText(_("tutti.editMarineLitterBatch.field.marineLitterTotalWeight"));
        marineLitterTotalWeightLabel.setToolTipText(_("tutti.editMarineLitterBatch.field.marineLitterTotalWeight.tip"));
        marineLitterTotalWeightLabel.putClientProperty("help", "tutti.editMarineLitterBatch.field.marineLitterTotalWeight.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(MarineLitterBatchUIModel.class));
    }

    protected void createRemoveMarineLitterBatchMenu() {
        $objectMap.put("removeMarineLitterBatchMenu", removeMarineLitterBatchMenu = new JMenuItem());
        
        removeMarineLitterBatchMenu.setName("removeMarineLitterBatchMenu");
        removeMarineLitterBatchMenu.setText(_("tutti.editMarineLitterBatch.action.removeBatch"));
        removeMarineLitterBatchMenu.setToolTipText(_("tutti.editMarineLitterBatch.action.removeBatch.tip"));
        removeMarineLitterBatchMenu.putClientProperty("help", "tutti.editMarineLitterBatch.action.removeBatch.help");
        removeMarineLitterBatchMenu.putClientProperty("tuttiAction", RemoveMarineLitterBatchAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editMarineLitterBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(MarineLitterBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditMarineLitterBatchTopPanel();
        addChildrenToValidator();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createMarineLitterBatchButton);
        addChildrenToTableScrollPane();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        removeMarineLitterBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeMarineLitterBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.removeBatch.mnemonic"),'Z'));
        marineLitterTotalWeightLabel.setLabelFor(marineLitterTotalWeightField);
        marineLitterTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterTotalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        marineLitterTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createMarineLitterBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createMarineLitterBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editMarineLitterBatch.action.createBatch.mnemonic"),'Z'));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editMarineLitterBatchTopPanel, "tutti.editMarineLitterBatch.help");
        registerHelpId(_broker, removeMarineLitterBatchMenu, "tutti.editMarineLitterBatch.action.removeBatch.help");
        registerHelpId(_broker, marineLitterTotalWeightLabel, "tutti.editMarineLitterBatch.field.marineLitterTotalWeight.help");
        registerHelpId(_broker, createMarineLitterBatchButton, "tutti.editMarineLitterBatch.action.createBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editMarineLitterBatchTopPanel", editMarineLitterBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createTablePopup();
        createRemoveMarineLitterBatchMenu();
        createForm();
        createMarineLitterTotalWeightLabel();
        createMarineLitterTotalWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateMarineLitterBatchButton();
        createTableScrollPane();
        createTable();
        // inline creation of editMarineLitterBatchTopPanel
        setName("editMarineLitterBatchTopPanel");
        setLayout(new BorderLayout());
        editMarineLitterBatchTopPanel.putClientProperty("help", "tutti.editMarineLitterBatch.help");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_MARINE_LITTER_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeMarineLitterBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setModel(model.getMarineLitterTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setBean(model.getMarineLitterTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                marineLitterTotalWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
    }

}