/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SelectOtherSpeciesAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(SelectOtherSpeciesAction.class);
    protected Species selectedSpecies;

    public SelectOtherSpeciesAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
            ArrayList species = Lists.newArrayList(model.getAllSynonyms());
            this.selectedSpecies = ((EditProtocolUIHandler)this.getHandler()).openSelectOtherSpeciesDialog(I18n._((String)"tutti.selectSpecies.title", (Object[])new Object[0]), species);
            if (log.isInfoEnabled()) {
                log.info((Object)("SelectedSpecies: " + this.selectedSpecies));
            }
            result = this.selectedSpecies != null;
        }
        return result;
    }

    @Override
    protected void releaseAction() {
        this.selectedSpecies = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        String decoratedSynonym = this.decorate(this.selectedSpecies);
        String taxonId = String.valueOf(this.selectedSpecies.getReferenceTaxonId());
        this.selectedSpecies = ((EditProtocolUIModel)this.getModel()).getAllReferentSpeciesByTaxonId().get(taxonId);
        String decoratedReferent = this.decorate(this.selectedSpecies);
        this.sendMessage(I18n._((String)"tutti.flash.info.species.replaced", (Object[])new Object[]{decoratedSynonym, decoratedReferent}));
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().setSelectedItem((Object)this.selectedSpecies);
    }
}

