/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class ValidateCruiseOperationsService
extends AbstractTuttiService {
    protected PersistenceService persistenceService;
    protected ValidationService validationService;
    protected TuttiWeightComputingService tuttiWeightComputingService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.validationService = this.getService(ValidationService.class);
        this.tuttiWeightComputingService = this.getService(TuttiWeightComputingService.class);
    }

    public Map<FishingOperation, NuitonValidatorResult> validateCruiseOperations() {
        HashMap result = Maps.newHashMap();
        TuttiDataContext dataContext = this.context.getDataContext();
        List<FishingOperation> operations = this.persistenceService.getAllFishingOperation(dataContext.getCruiseId());
        for (FishingOperation operation : operations) {
            NuitonValidatorResult validator = this.validationService.validateFishingOperation(operation, "validate");
            List<String> errors = this.tuttiWeightComputingService.checkOperation(operation);
            HashMap errorMap = Maps.newHashMap();
            errorMap.put("cacthes", errors);
            validator.addMessagesForScope(NuitonValidatorScope.ERROR, (Map)errorMap);
            result.put(operation, validator);
        }
        return result;
    }
}

