package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportPupitriAction.java 845 2013-04-22 06:53:55Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/ExportPupitriAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.pupitri.TuttiPupitriImportExportService;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * To export protocol species.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ExportPupitriAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ExportPupitriAction.class);

    private File file;

    public ExportPupitriAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to export
            file = TuttiUIUtil.saveFile(
                    "tuttiProtocol-" + getModel().getName() + "-pupitri.csv",
                    getContext().getMainUI(),
                    _("tutti.editProtocol.title.choose.speciesExportFile"),
                    _("tutti.editProtocol.action.chooseProtocolSpeciesFile")
            );
            if (file == null) {

                // user cancel
                doAction = false;
            } else {

                // ask user to confirm overwrite.
                doAction = getHandler().askOverwriteFile(file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull(file);
        if (log.isInfoEnabled()) {
            log.info("Will export protocol species to file: " + file);
        }

        EditProtocolUIModel model = getModel();

        // build species protocol to export

        List<Species> speciesList = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getSpeciesRow()) {
            if (row.isValid()) {
                Species species = row.getSpecies();
                species.setSurveyCode(row.getSpeciesSurveyCode());
                speciesList.add(species);
            }
        }

        // import
        TuttiPupitriImportExportService service =
                getContext().getTuttiPupitriImportExportService();

        service.exportSpecies(speciesList, file);

        sendMessage(_("tutti.flash.info.species.exported.from.protocol",
                      file));
    }
}