package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCruiseFishingOperationAction.java 827 2013-04-18 19:11:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/cruise/EditCruiseFishingOperationAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import static org.nuiton.i18n.I18n._;

/**
 * To edit the given fishing operation.
 *
 * @author kmorin <morin@codelutin.com>
 * @since 1.4
 */
public class EditCruiseFishingOperationAction extends AbstractTuttiAction<ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EditCruiseFishingOperationAction.class);

    /**
     * The incoming fishing operation to edit.
     * <p/>
     * Can be null (means do not edit any fishing operation), or with no id
     * (means create a ne fishing operation), or with an id (means edit an
     * existing fishing operation).
     */
    protected FishingOperation fishingOperation;

    public EditCruiseFishingOperationAction(ValidateCruiseUIHandler handler) {
        super(handler, true);
        setActionDescription(_("tutti.editFishingOperation.action.editFishingOperation.tip"));
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    @Override
    protected void doAction() throws Exception {
        getUI().getOperationPanel().getModel().setSelectedFishingOperation(fishingOperation);
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        fishingOperation = null;
    }
}
