package fr.ifremer.tutti.ui.swing.content.operation.catches.species.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class CreateSpeciesBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateSpeciesBatchUIModel, CreateSpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_WEIGHT_FIELD_MODEL = "batchWeightField.model";
    public static final String BINDING_BATCH_WEIGHT_FIELD_NUMBER_PATTERN = "batchWeightField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SORTED_UNSORTED_CATEGORY_COMBO_BOX_SELECTED_ITEM = "sortedUnsortedCategoryComboBox.selectedItem";
    public static final String BINDING_SPECIES_COMBO_BOX_DATA = "speciesComboBox.data";
    public static final String BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM = "speciesComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVX3W/cRBDfXL4/StoEokBbSJOqNKDsFVWVqAKlSZojiS4hSq60Ioiwd97ktvhsY6+Ti05B/An8CfDOCxJvPCEeeOYBgRD8CQjxwCtiZu07f5x9dpEaKU68O/Ob2d/Mzoy//pMMOja59oQ1m9R2DSkanG6tPH78XvUJr8kH3KnZwpKmTbyfvgIpHJBxrbPuSLJwUEb1oq9eXDMblmlwI6S9XCZjjjzTuVPnXEpyNapRc5zifmd7uWm5dhu141QS6pd//1X4Qvv8qwIhTQu8uwhHmcvSCk4yUCYFoUkyBZZOWFFnxjG4YQvjGPy9gGtrOnOcHdbgn5LPyHCZDFnMBjBJ5vMfWWEo/aYlyUs1mzPJ9y1eE9xZZbJWr5jWLjO4LsmjI5uKI5s3uE2lK6WgrqDOKThEa6YhAZ+aFreZFKZBa6jLHep4UNQDpmtd+A83LUs5MCTJcJ0Zms5tST56RrY2PAOBycGGqeHhPnxGBrcRPjA3esJ0oTGIgCSvR3Khs+Fb3cfn++3FAGGoapufIEWL6R5X8HUD7K4q2UB5Cs5yJI5d7xx+XGcjfvgIrKqrtBrt6E74py2zKmpNYQY2ffEttYiCsx35SV8esq9qrppNSe4kGOKawDNXOTPoKjxKQpdAM1hv60VRLzJNazMMp4TQkOmIJ95qVOmyA3xz7aHh/V2DKB2b9lnH6atR8ZeTxcMOzcW8qmK0H3FxXJdpqGGZkuA6XO0b6YTsuI0qt9fVSxRn5PqWCtyteAzUaixmNWbUuB5wsoCPpc7+mMNOePeuTS5HPIMKSIMKGJSovgMyaLuwDEl00F0092DLK5ezsXKJgGr335npn7/7/dtSuEa+kCgaKvFQuywbb6MUaHrSK5CuFHpxm1nLB2TU4Tr0B1X/ryQ4tu9vg3Ng7xKqU1SnG8ypA8Tg8G/f/zDz8U/9pFAiY7rJtBJD+U0yKus2sGDqWtN6577yaOJ0BB2H335JBjCRoZC1VFk5B4bFG28auzY/EnABJr176jt/RqEeANbpHnew7QxI2+VNYOtKAlsdl6ujP/4zvf/N/TZjfXCCF1PFA9YGPyBDwtCFwVVf8VtGYh8ZtxzuambQGpKaBYF2MZN8Y/16c1c9306iaZS50tw1LRdAii2/6tNjLtdUfbq5SIWz0hYJX4Wbi+cJpGGxgSUl3a4Kt1Jg90EwjOjJA27TRXfXFaX437t4womwaMa5+qCbHNah6kpyrTXvhbq7n1KUmE+w1rP7Whm2B6Au6Fh4SthZLrVitfccieJN4OtGql9HWJPaLU2ScWmaekVYFaX2Wj41KmG66LBQ7MFCVC2dk0jXyWKhH+VV5nNtU/KGJM97FxFzwDevMmgAmiqDQS/YXTlhQsckDouNtG8q3GjfjyQf453u6YI11+rdboLY3cliMxEnHsq7/wslGtl72ZFNRkkPdK8enUVooSvuC6G4J+LG4zuTbD7J04zx4OmiP9WKjwVBvLMuXUgzHmSaXzUa2duZkQ2rpoezayLKomUwmMVng+CtBijexY331wuGKtC7TEITMpDPB+trm9sr5duHuyuVyvreDsbZdXgJ2njQL0KRHw95mnUSFaAcJ8kMIIwT+CERDLOQwYdKekXtgG7L6+H+PiRLGMCTojVsyHDACZwytg3eMA1RgyDmt0sbHa28GdSNkTuDulV7ZFB80s/iHT8guYE1XMMW6OWQcNQ3lJc8XlSuZ7mHQzFMbt7bJn7+kQFvLcbzUh6kVIZv5tKOcLuUza1SSmc1NPHnz+P0ocE36n1mxDgbaq/GWCvmQ0vlLfNW+fq5Z5GoWo9ZJPw1lcUeTINDOjszQZg89xbOG3NVYWjwpXavC7sPn2M5EEew/FXOLDWp/5qM80omDi7/0QPh1VwIv/RAoIDwHwLB9UC9EwAA";
    private static final Log log = LogFactory.getLog(CreateSpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    @ValidatorField( validatorId = "validator",  propertyName = "batchWeight",  editorName = "batchWeightField")
    protected NumberEditor batchWeightField;
    protected JLabel batchWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateSpeciesBatchUI createSpeciesBatchTopPanel = this;
    protected CreateSpeciesBatchUIHandler handler;
    protected CreateSpeciesBatchUIModel model;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "sortedUnsortedCategory",  editorName = "sortedUnsortedCategoryComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> sortedUnsortedCategoryComboBox;
    protected JLabel sortedUnsortedCategoryLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "speciesComboBox")
    protected BeanFilterableComboBox<Species> speciesComboBox;
    protected JLabel speciesLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateSpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateSpeciesBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateSpeciesBatchUIHandler handler = new CreateSpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI() {
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public NumberEditor getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateSpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public CreateSpeciesBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getSortedUnsortedCategoryComboBox() {
        return sortedUnsortedCategoryComboBox;
    }

    public JLabel getSortedUnsortedCategoryLabel() {
        return sortedUnsortedCategoryLabel;
    }

    public BeanFilterableComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public SwingValidator<CreateSpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(speciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sortedUnsortedCategoryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sortedUnsortedCategoryComboBox), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchWeightField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateSpeciesBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setText(_("tutti.createSpeciesBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(_("tutti.createSpeciesBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("help", "tutti.createSpeciesBatch.action.addSpecies.help");
        addSpeciesButton.putClientProperty("tuttiAction", SelectSpeciesForSpeciesBatchAction.class);
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new NumberEditor(this));
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setProperty("batchWeight");
        batchWeightField.setUseFloat(true);
        batchWeightField.setShowReset(true);
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(_("tutti.createSpeciesBatch.field.batchWeight"));
        batchWeightLabel.setToolTipText(_("tutti.createSpeciesBatch.field.batchWeight.tip"));
        batchWeightLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.batchWeight.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createSpeciesBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createSpeciesBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createSpeciesBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createSpeciesBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateSpeciesBatchUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateSpeciesBatchUIModel.class));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.createSpeciesBatch.action.save"));
        saveButton.setToolTipText(_("tutti.createSpeciesBatch.action.save.tip"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
        saveButton.putClientProperty("help", "tutti.createSpeciesBatch.action.save.help");
    }

    protected void createSortedUnsortedCategoryComboBox() {
        $objectMap.put("sortedUnsortedCategoryComboBox", sortedUnsortedCategoryComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        sortedUnsortedCategoryComboBox.setName("sortedUnsortedCategoryComboBox");
        sortedUnsortedCategoryComboBox.setI18nPrefix("tutti.property.");
        sortedUnsortedCategoryComboBox.setProperty("sortedUnsortedCategory");
        sortedUnsortedCategoryComboBox.setShowReset(true);
    }

    protected void createSortedUnsortedCategoryLabel() {
        $objectMap.put("sortedUnsortedCategoryLabel", sortedUnsortedCategoryLabel = new JLabel());
        
        sortedUnsortedCategoryLabel.setName("sortedUnsortedCategoryLabel");
        sortedUnsortedCategoryLabel.setText(_("tutti.createSpeciesBatch.field.sortedUnsortedCategory"));
        sortedUnsortedCategoryLabel.setToolTipText(_("tutti.createSpeciesBatch.field.sortedUnsortedCategory.tip"));
        sortedUnsortedCategoryLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.sortedUnsortedCategory.help");
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setI18nPrefix("tutti.property.");
        speciesComboBox.setProperty("species");
        speciesComboBox.setShowReset(true);
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(_("tutti.createSpeciesBatch.field.species"));
        speciesLabel.setToolTipText(_("tutti.createSpeciesBatch.field.species.tip"));
        speciesLabel.putClientProperty("help", "tutti.createSpeciesBatch.field.species.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateSpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateSpeciesBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 17 property setters
        speciesComboBox.setBeanType(Species.class);
        sortedUnsortedCategoryComboBox.setBeanType(CaracteristicQualitativeValue.class);
        speciesLabel.setLabelFor(speciesComboBox);
        speciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createSpeciesBatch.action.addSpecies.mnemonic"),'Z'));
        sortedUnsortedCategoryLabel.setLabelFor(sortedUnsortedCategoryComboBox);
        sortedUnsortedCategoryComboBox.setBean(model);
        batchWeightLabel.setLabelFor(batchWeightField);
        batchWeightField.setBean(model);
        batchWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createSpeciesBatch.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createSpeciesBatch.action.save.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createSpeciesBatchTopPanel, "tutti.createSpeciesBatch.help");
        registerHelpId(_broker, speciesLabel, "tutti.createSpeciesBatch.field.species.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createSpeciesBatch.action.addSpecies.help");
        registerHelpId(_broker, sortedUnsortedCategoryLabel, "tutti.createSpeciesBatch.field.sortedUnsortedCategory.help");
        registerHelpId(_broker, batchWeightLabel, "tutti.createSpeciesBatch.field.batchWeight.help");
        registerHelpId(_broker, cancelButton, "tutti.createSpeciesBatch.action.cancel.help");
        registerHelpId(_broker, saveButton, "tutti.createSpeciesBatch.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createSpeciesBatchTopPanel", createSpeciesBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createSpeciesLabel();
        createSpeciesComboBox();
        createAddSpeciesButton();
        createSortedUnsortedCategoryLabel();
        createSortedUnsortedCategoryComboBox();
        createBatchWeightLabel();
        createBatchWeightField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of createSpeciesBatchTopPanel
        setName("createSpeciesBatchTopPanel");
        setLayout(new BorderLayout());
        createSpeciesBatchTopPanel.putClientProperty("help", "tutti.createSpeciesBatch.help");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SORTED_UNSORTED_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sortedUnsortedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sortedUnsortedCategoryComboBox.setSelectedItem(model.getSortedUnsortedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sortedUnsortedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchWeightField.setModel(model.getBatchWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BATCH_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                batchWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}