package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class FishingOperationsUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<FishingOperationsUIModel, FishingOperationsUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CATCHES_TAB_ENABLED = "catchesTab.enabled";
    public static final String BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM = "fishingOperationComboBox.selectedItem";
    public static final String BINDING_WARNING_CONTAINER_VISIBLE = "warningContainer.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWT28bRRSfOHH+Q9pGDQkUcFKoEimaNBGFVKG0sWs3rpK0SlypIocy6x3H065nltlx7GAV8RGATwB3LkjcOCEOnDlwQXwFhDhwRbyZXe9m7XXs0kjZbGbe+733fu/ffvcnSnsSLT4lzSaWda5YjeL7248fP7Ce0rK6S72yZK4SEvk/QymUOkJTdnjuKXT1aFerrwXqazlRcwWn/Iz21i6a9NSpQ70qpUqhN+MaZc9bOwyvt5puXbZRQ6eSUL/5+6/Ul/YX36YQarrg3QyEkumnFUUysotSzFboElg6IWsO4cfghmT8GPx9RZ/lHOJ5+6RGP0Wfo7FdNOoSCWAKLQ0essEw+k1XoYUK86pg4YFLJVFMcK8k3IeEU0eh2xWJWUXSGpVY1ZViuM6w1wBpXBZcATwWbTVc6MR5VHRdY2dUobEq4bZDpUKFl8Tc8YEi6HRN2NrZuy8JvKdhIthRS4pn2uGV3rgl/e8OaGWNbKQ8rkIO52PpD/SI5ZgMToQa851pgAxaIiuaCt1IQKA2g5RiixKOs/AoMEeBIsC29TTu5RB+gdNGZ8xZ8B6IQbO6sJoB8H3/NK59oUEkh9sciBPGNSuXYkom1rjOdKCzSyxNQ1zeHGrBt6IKUcTSMAq9FhMFrixq65s4Ya93EgaCOT/PCmVfpBbywGUnN4+K2sw7obWLZaLKVeqdNbL9IkYCfWMs57932pjioiQJU+1Yr8YDnk0IGGhILq8ir4ioHCcj7/XJOtxI9EZMEyYejiZeNJKGjlBa1uEYSvSoe0gewJU/Huc7xqMGNLf/zs3+9uMfPxTaM3EKbF9OFD0z0mFWuVKzp5g2PeMPxLpiztoecbeO0IRHHdgHZt5fSXDsMLgG58DeRa2OtTreIV4VINJjv//089wnvw6jVAFNOoLYBaLli2hCVSWwIBy76d6+YzyabozD8wL8Dis0opsO6rVl5s5zYJetb/KHklYYNOuMXwmB86dYgadV0Tignl4zI0rWaRPYupLAVuiyNfHLP7OH399pMzYEESz0FI9YS3+MRhl3oEHNHglWROLemHI9WrdFtAqSlgOC9TCXPF2C2rppnre6aBqCsfykCoNRoUxryaeka89gLbD0vFnXGHkTp367h85bSm4fy2nIByQSVIq6CdEwsWGhTj8xPmybC4UWW/vd49C/xGVNAGR1Wmd1j9Oa4Kys0FavIHxjOGG+4lqoPaWEcErMLdEmVMH7/wNLwQ4POd3qzek5EOfQ3XM79KMb+mHa70RqFxWtKfSu3xf4mKrD4KITenkF+B1vtwgMFq+HYBTxB70jrjDq2F3n50Tbc9X2CzYFXX/CPAZ9AJy1Fv1AmWfmeZ7r/rBNbJMWKT87lqLOofaWWsBuxgwg0lDwAegIubzx3o3VzMb65mpmc3Ml0cuunTtAKkaUqa/rvajSkJjxE+IwG1vaaxx8PMV6ZiwwrT+ChLT1ut8Ig2gvZv8G52uuOs2a92UIaf36asb8SQ4q9lHQLyAYImPUZ1Whe4OUVWbxVobXHSdz7VqmR3KSvDqzHgcogdmqkOwznRVn22HHvGY+BmZa/kcNzuX3S/mD52EybvZKBoMVjbnortx2NyS5evYbYQD+Rh1yKsA+evVDmyiSsRi3wdZHXdBD+jk5AOK43n6lU9cskq+TcRb64ujjr85BeBsQ/gOPDKeSCg4AAA==";
    private static final Log log = LogFactory.getLog(FishingOperationsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected TabInfo catchesTab;
    protected EditCatchesUI catchesTabContent;
    protected BeanFilterableComboBox<FishingOperation> fishingOperationComboBox;
    protected TabInfo fishingOperationTab;
    protected EditFishingOperationUI fishingOperationTabContent;
    protected FishingOperationsUI fishingOperationsTopPanel = this;
    protected FishingOperationsUIHandler handler;
    protected FishingOperationsUIModel model;
    protected JButton newFishingOperationButton;
    protected JLabel noTraitPane;
    protected JTabbedPane tabPane;
    protected Table topPanel;
    protected JPanel warningContainer;
    protected JLabel warningLabel;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        handler.afterInitUI();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FishingOperationsUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            FishingOperationsUIHandler handler = new FishingOperationsUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public FishingOperationsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI() {
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public TabInfo getCatchesTab() {
        return catchesTab;
    }

    public EditCatchesUI getCatchesTabContent() {
        return catchesTabContent;
    }

    public BeanFilterableComboBox<FishingOperation> getFishingOperationComboBox() {
        return fishingOperationComboBox;
    }

    public TabInfo getFishingOperationTab() {
        return fishingOperationTab;
    }

    public EditFishingOperationUI getFishingOperationTabContent() {
        return fishingOperationTabContent;
    }

    public FishingOperationsUIHandler getHandler() {
        return handler;
    }

    public FishingOperationsUIModel getModel() {
        return model;
    }

    public JButton getNewFishingOperationButton() {
        return newFishingOperationButton;
    }

    public JLabel getNoTraitPane() {
        return noTraitPane;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Table getTopPanel() {
        return topPanel;
    }

    public JPanel getWarningContainer() {
        return warningContainer;
    }

    public JLabel getWarningLabel() {
        return warningLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFishingOperationsTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topPanel, BorderLayout.NORTH);
        add(tabPane);
        add(noTraitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(fishingOperationTabContent);
        tabPane.add(catchesTabContent);
        fishingOperationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        tabPane.setTitleAt(0, _("tutti.label.tab.fishingOperation"));
        catchesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.catches"));
    }

    protected void addChildrenToTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        topPanel.add(fishingOperationComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add(newFishingOperationButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add(warningContainer, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        warningContainer.add(warningLabel, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.fishingOperations.help"));
    }

    protected void createCatchesTab() {
        $objectMap.put("catchesTab", catchesTab = new TabInfo());
        
        catchesTab.setTitle(_("tutti.label.tab.catches"));
    }

    protected void createCatchesTabContent() {
        $objectMap.put("catchesTabContent", catchesTabContent = new EditCatchesUI(this));
        
        catchesTabContent.setName("catchesTabContent");
    }

    protected void createFishingOperationComboBox() {
        $objectMap.put("fishingOperationComboBox", fishingOperationComboBox = new BeanFilterableComboBox<FishingOperation>(this));
        
        fishingOperationComboBox.setName("fishingOperationComboBox");
        fishingOperationComboBox.setI18nPrefix("tutti.property.");
        fishingOperationComboBox.setProperty("selectedFishingOperation");
        fishingOperationComboBox.setShowReset(true);
        fishingOperationComboBox.putClientProperty("help", "tutti.fishingOperations.field.fishingOperation.help");
    }

    protected void createFishingOperationTab() {
        $objectMap.put("fishingOperationTab", fishingOperationTab = new TabInfo());
        
        fishingOperationTab.setTitle(_("tutti.label.tab.fishingOperation"));
    }

    protected void createFishingOperationTabContent() {
        $objectMap.put("fishingOperationTabContent", fishingOperationTabContent = new EditFishingOperationUI(this));
        
        fishingOperationTabContent.setName("fishingOperationTabContent");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(FishingOperationsUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FishingOperationsUIModel.class));
    }

    protected void createNewFishingOperationButton() {
        $objectMap.put("newFishingOperationButton", newFishingOperationButton = new JButton());
        
        newFishingOperationButton.setName("newFishingOperationButton");
        newFishingOperationButton.setToolTipText(_("tutti.fishingOperations.action.newFishingOperation.tip"));
        newFishingOperationButton.putClientProperty("help", "tutti.fishingOperations.action.newFishingOperation.help");
        newFishingOperationButton.putClientProperty("tuttiAction", NewFishingOperationAction.class);
    }

    protected void createNoTraitPane() {
        $objectMap.put("noTraitPane", noTraitPane = new JLabel());
        
        noTraitPane.setName("noTraitPane");
        noTraitPane.setText(_("tutti.fishingOperations.info.no.fishingOperation.selected"));
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new Table());
        
        topPanel.setName("topPanel");
    }

    protected void createWarningContainer() {
        $objectMap.put("warningContainer", warningContainer = new JPanel());
        
        warningContainer.setName("warningContainer");
        warningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createWarningLabel() {
        $objectMap.put("warningLabel", warningLabel = new JLabel());
        
        warningLabel.setName("warningLabel");
        warningLabel.setText(_("tutti.fishingOperations.warn.invalid.batch.model"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFishingOperationsTopPanel();
        addChildrenToTopPanel();
        addChildrenToWarningContainer();
        addChildrenToTabPane();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        fishingOperationComboBox.setBeanType(FishingOperation.class);
        fishingOperationComboBox.setBean(model);
        newFishingOperationButton.setIcon(SwingUtil.createActionIcon("add"));
        newFishingOperationButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.fishingOperations.action.newFishingOperation.mnemonic"),'Z'));
        warningContainer.setBackground(new java.awt.Color(245, 218, 88));
        warningLabel.setIcon(SwingUtil.createActionIcon("warning"));
        warningLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        noTraitPane.setHorizontalAlignment(JLabel.CENTER);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, fishingOperationsTopPanel, "tutti.fishingOperations.help");
        registerHelpId(_broker, fishingOperationComboBox, "tutti.fishingOperations.field.fishingOperation.help");
        registerHelpId(_broker, newFishingOperationButton, "tutti.fishingOperations.action.newFishingOperation.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("fishingOperationsTopPanel", fishingOperationsTopPanel);
        createHandler();
        createModel();
        createBroker();
        createTopPanel();
        createFishingOperationComboBox();
        createNewFishingOperationButton();
        createWarningContainer();
        createWarningLabel();
        createTabPane();
        createFishingOperationTabContent();
        createCatchesTabContent();
        createNoTraitPane();
        createFishingOperationTab();
        createCatchesTab();
        // inline creation of fishingOperationsTopPanel
        setName("fishingOperationsTopPanel");
        setLayout(new BorderLayout());
        fishingOperationsTopPanel.putClientProperty("help", "tutti.fishingOperations.help");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationComboBox.setSelectedItem(model.getSelectedFishingOperation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_CONTAINER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningContainer.setVisible(!model.isCatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_TAB_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("catchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesTab.setEnabled(model.getSelectedFishingOperation() != null && model.isCatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("catchEnabled", this);
                }
            }
        });
    }

}