/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorScope;

public class NuitonValidatorFactory {
    private static final Log log = LogFactory.getLog(NuitonValidatorFactory.class);
    protected static String defaultProviderName;
    protected static Map<String, NuitonValidatorProvider> providers;

    public static <O> NuitonValidator<O> newValidator(Class<O> type, NuitonValidatorScope ... scopes) {
        NuitonValidator<O> result = NuitonValidatorFactory.newValidator(type, null, scopes);
        return result;
    }

    public static <O> NuitonValidator<O> newValidator(Class<O> type, String context, NuitonValidatorScope ... scopes) {
        String providerName = NuitonValidatorFactory.getDefaultProviderName();
        NuitonValidator<O> result = NuitonValidatorFactory.newValidator(providerName, type, context, scopes);
        return result;
    }

    public static <O> NuitonValidator<O> newValidator(String providerName, Class<O> type, String context, NuitonValidatorScope ... scopes) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("type parameter can not be null.");
        }
        NuitonValidatorProvider provider = NuitonValidatorFactory.getProvider(providerName);
        NuitonValidatorModel<O> model = provider.getModel(type, context, scopes);
        NuitonValidator<O> result = provider.newValidator(model);
        return result;
    }

    public static Map<String, NuitonValidatorProvider> getProviders() {
        if (providers == null) {
            providers = new TreeMap<String, NuitonValidatorProvider>();
            ServiceLoader<NuitonValidatorProvider> serviceLoader = ServiceLoader.load(NuitonValidatorProvider.class);
            for (NuitonValidatorProvider provider : serviceLoader) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("obtain validator provider " + provider.getName()));
                }
                providers.put(provider.getName(), provider);
            }
        }
        return providers;
    }

    public static NuitonValidatorProvider getProvider(String providerName) throws IllegalArgumentException, NullPointerException {
        if (providerName == null) {
            throw new NullPointerException("providerName parameter can not be null.");
        }
        NuitonValidatorProvider provider = NuitonValidatorFactory.getProviders().get(providerName);
        if (provider == null) {
            throw new IllegalArgumentException("Could not find provider named '" + defaultProviderName + "', existing providers are : " + NuitonValidatorFactory.getProviders().keySet());
        }
        return provider;
    }

    public static NuitonValidatorProvider getDefaultProvider() {
        String providerName = NuitonValidatorFactory.getDefaultProviderName();
        NuitonValidatorProvider provider = NuitonValidatorFactory.getProvider(providerName);
        return provider;
    }

    public static String getDefaultProviderName() throws IllegalStateException {
        if (defaultProviderName == null) {
            Map<String, NuitonValidatorProvider> providers = NuitonValidatorFactory.getProviders();
            if (providers.isEmpty()) {
                throw new IllegalStateException("Could not find any provider of validator.");
            }
            defaultProviderName = providers.keySet().iterator().next();
            if (log.isInfoEnabled()) {
                log.info((Object)("Set the default provider name to " + defaultProviderName));
            }
        }
        return defaultProviderName;
    }

    public static void setDefaultProviderName(String defaultProviderName) throws IllegalArgumentException, NullPointerException {
        if (defaultProviderName == null) {
            throw new NullPointerException("defaultProviderName can not be null.");
        }
        NuitonValidatorFactory.getProvider(defaultProviderName);
        NuitonValidatorFactory.defaultProviderName = defaultProviderName;
    }

    protected NuitonValidatorFactory() {
    }
}

