package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class AccidentalBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<AccidentalBatchUIModel, AccidentalBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCIDENTAL_BATCH_ATTACHMENTS_BUTTON_ENABLED = "accidentalBatchAttachmentsButton.enabled";
    public static final String BINDING_REMOVE_ACCIDENTAL_BATCH_MENU_ENABLED = "removeAccidentalBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XzW8bRRSfuLHdfBFoaEiVtkpDgYTCOhwqoQZKHZMQByeNYhcicgizu2N7kvXOdnY2cWUF8SfwF/Bx54LEjRPiwJkDl4p/ASEOXBFvZtf74azjhDZSRtk37/d7b96b997k+z9R1uXo1gFutzXu2YK2iLZR3N19qB8QQ3xIXINTRzCO/J+hDMrsoTEzlLsCvbpXkfBCAC+UWMthNrFj6OUKGnXFE4u4TUKEQDeSCMN1C9Vwe7nteLzLGjqVxvrt339lvjK//C6DUNsB7ybhKHODUNFJhisoQ02BroClI1ywsN0ANzi1G+DvhJSVLOy6W7hFHqMvUL6Ccg7mQCbQ/PmPrDgUvu0INEtMKoqGQU3QxtYKFkazxpxtbBNLoO0612idkxbhmvCEoJpHNfcYPNIMZguAaMwhHAvKbM2QWOJqOGTTeogflR1Hmc4JlG9i27QIF+jT521k3WeObGVbzJTHefS8LW1K3sjOyBG2qIkh2gLdSeQ93AjMVeX6SVcYMeR0zg5lUBb7u1qTn+tgd0XpRuBruCePWK8xBn8D38vy+rQDho1ALHEjIXyuB14UAhvNFgjcFTAJAUL3+nvlCWppOIRoPiTikEZmQlujAusW2WaOB3dwOuGbEm4S24sdDCyyI9ITfqkj0NUEWMrKgrQk8GaIH64z3hJoJpGSIJjSj2QcxpVvMkS6jNyVpHeyMKTi7VD/8m1fuiS/F+XyRrg3a3CCRa/n3XBOJah9qQS+GeInlS9VgzPLkkYEeiWBiXaSZ8gqHNhnvKEdQHs8FMzxQW1tYzc8dcGBFjWbiAs0Py1qflF3GtpDWe6BGAK5d7pf7sCW3ylnejqlJFS7/05P/f7THz+uddvjGNi+mqoa6+7Qthwuq1JQaXrS743ythU2sbO8h0ZcYsFoUK3/eopj1WAbnAN7L0m4f1nXsdsEimz+6c+/TH/+2yWUWUOjFsPmGpb6ZTQimhyiwCyz7XzwQHk0fnwZ1hfhdxiulU4wZDHfUe3lBOofe4IFl7rQCRqc1iCixOw6bSwsatQtdlW2vJZO+Cq0X8YXFiUaTB3vEFcOpGHBPQj+pBQp7e6VWepDWwXFOKOvD7xtyMj1lIyEYdFHfv1nqvrDg25WhiBK1/qqR5nJfoZy1LaoTdTYCiZS6pgac1zimSyaPGmzCEHQxuNHCOr/nlrvn0rAENzy/Sa0QYFe78yrbiS/tJSBpsmNeQiFZFpXZ5R/baCz558zwINLkLM6XJig1rJ1bEHyUI45+LEXE0zojJuEb2MKM8bsytO86d/BB/kC0cgTWzoCBm74N1JeEf/dVDYXFuduvT9ne5aVGoaBvf8c9rMW1uWUfcufDGl5EFRYRNOVBUNOWTfNmdhwGGQWqnDCr38gk9NYoNc6FeqKalxoadXy1keV1f3qamW1VCs/3IJyu+zCmE5mbiqkWmOcNDjzbIjmRKfELJjcK5Vi6eOTuNYKNg67WrlO3+D6zXjQUbKy6klbnBlAbPhvEzVVlAjC5QvL8gmDxlVw3/YV4JO+8669acP4tKkh0N2LMGutEDcm4BbWqFNT/i1diEXA8zOs1LtBpZ4XfEbhnjFZB4U6Hy+Wm0GxUHdHvTIUz6q/q/ryubPCI3x6VsAMUVnZV1x+CcA/LJ2dtPdNMQiH7JEn/yOVMXeeIZVxlgunMg7un8r+z7tzdJ2chZ8w8AO98B68pfGcTm0TXjn3TxkakuvoQEYp/lou36QzLDwzwx1g+A9s67Xs6A4AAA==";
    private static final Log log = LogFactory.getLog(AccidentalBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ButtonAttachment accidentalBatchAttachmentsButton;
    protected JToolBar accidentalBatchTabToolBar;
    protected TuttiHelpBroker broker;
    protected JButton createAccidentalBatchButton;
    protected AccidentalBatchUI editAccidentalBatchTopPanel = this;
    protected Table form;
    protected AccidentalBatchUIHandler handler;
    protected AccidentalBatchUIModel model;
    protected JMenuItem removeAccidentalBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<AccidentalBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccidentalBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            AccidentalBatchUIHandler handler = new AccidentalBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public AccidentalBatchUI() {
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createAccidentalBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ButtonAttachment getAccidentalBatchAttachmentsButton() {
        return accidentalBatchAttachmentsButton;
    }

    public JToolBar getAccidentalBatchTabToolBar() {
        return accidentalBatchTabToolBar;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateAccidentalBatchButton() {
        return createAccidentalBatchButton;
    }

    public Table getForm() {
        return form;
    }

    public AccidentalBatchUIHandler getHandler() {
        return handler;
    }

    public AccidentalBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveAccidentalBatchMenu() {
        return removeAccidentalBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<AccidentalBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccidentalBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalBatchTabToolBar.add(accidentalBatchAttachmentsButton);
    }

    protected void addChildrenToEditAccidentalBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(accidentalBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(tableToolbar, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeAccidentalBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalBatchAttachmentsButton() {
        $objectMap.put("accidentalBatchAttachmentsButton", accidentalBatchAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        accidentalBatchAttachmentsButton.setName("accidentalBatchAttachmentsButton");
    }

    protected void createAccidentalBatchTabToolBar() {
        $objectMap.put("accidentalBatchTabToolBar", accidentalBatchTabToolBar = new JToolBar());
        
        accidentalBatchTabToolBar.setName("accidentalBatchTabToolBar");
        accidentalBatchTabToolBar.setFloatable(false);
        accidentalBatchTabToolBar.setOpaque(false);
        accidentalBatchTabToolBar.setBorderPainted(false);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.editAccidentalBatch.help"));
    }

    protected void createCreateAccidentalBatchButton() {
        $objectMap.put("createAccidentalBatchButton", createAccidentalBatchButton = new JButton());
        
        createAccidentalBatchButton.setName("createAccidentalBatchButton");
        createAccidentalBatchButton.setText(_("tutti.editAccidentalBatch.action.createBatch"));
        createAccidentalBatchButton.setToolTipText(_("tutti.editAccidentalBatch.action.createBatch.tip"));
        createAccidentalBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createAccidentalBatchButton"));
        createAccidentalBatchButton.putClientProperty("help", "tutti.editAccidentalBatch.action.createBatch.help");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(AccidentalBatchUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(AccidentalBatchUIModel.class));
    }

    protected void createRemoveAccidentalBatchMenu() {
        $objectMap.put("removeAccidentalBatchMenu", removeAccidentalBatchMenu = new JMenuItem());
        
        removeAccidentalBatchMenu.setName("removeAccidentalBatchMenu");
        removeAccidentalBatchMenu.setText(_("tutti.editAccidentalBatch.action.removeBatch"));
        removeAccidentalBatchMenu.setToolTipText(_("tutti.editAccidentalBatch.action.removeBatch.tip"));
        removeAccidentalBatchMenu.putClientProperty("help", "tutti.editAccidentalBatch.action.removeBatch.help");
        removeAccidentalBatchMenu.putClientProperty("tuttiAction", RemoveAccidentalBatchAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editAccidentalBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(AccidentalBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditAccidentalBatchTopPanel();
        addChildrenToValidator();
        addChildrenToAccidentalBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createAccidentalBatchButton);
        addChildrenToTableScrollPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        removeAccidentalBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeAccidentalBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editAccidentalBatch.action.removeBatch.mnemonic"),'Z'));
        createAccidentalBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createAccidentalBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editAccidentalBatch.action.createBatch.mnemonic"),'Z'));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editAccidentalBatchTopPanel, "tuttihelp.editAccidentalBatch.help");
        registerHelpId(_broker, removeAccidentalBatchMenu, "tutti.editAccidentalBatch.action.removeBatch.help");
        registerHelpId(_broker, createAccidentalBatchButton, "tutti.editAccidentalBatch.action.createBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editAccidentalBatchTopPanel", editAccidentalBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createAccidentalBatchTabToolBar();
        createAccidentalBatchAttachmentsButton();
        createTablePopup();
        createRemoveAccidentalBatchMenu();
        createForm();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateAccidentalBatchButton();
        createTableScrollPane();
        createTable();
        // inline creation of editAccidentalBatchTopPanel
        setName("editAccidentalBatchTopPanel");
        setLayout(new BorderLayout());
        editAccidentalBatchTopPanel.putClientProperty("help", "tuttihelp.editAccidentalBatch.help");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_BATCH_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("objectId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalBatchAttachmentsButton.setEnabled(model.getObjectId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("objectId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ACCIDENTAL_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeAccidentalBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
    }

}