package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create;

/*
 * #%L
 * Tutti :: UI
 * $Id: CreateMarineLitterBatchUIModel.java 737 2013-04-04 19:09:48Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/marinelitter/create/CreateMarineLitterBatchUIModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;

/**
 * Model to create a new marine litter batch.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class CreateMarineLitterBatchUIModel extends AbstractTuttiBeanUIModel<CreateMarineLitterBatchUIModel, CreateMarineLitterBatchUIModel> {

    private static final long serialVersionUID = 1L;

    /**
     * Delegate edit object.
     *
     * @since 1.3
     */
    protected final MarineLitterBatch editObject =
            TuttiBeanFactory.newMarineLitterBatch();

    public CreateMarineLitterBatchUIModel() {
        super(CreateMarineLitterBatchUIModel.class, null, null);
    }

    public CaracteristicQualitativeValue getMarineLitterCategory() {
        return editObject.getMarineLitterCategory();
    }

    public void setMarineLitterCategory(CaracteristicQualitativeValue marineLitterCategory) {
        Object oldValue = getMarineLitterCategory();
        editObject.setMarineLitterCategory(marineLitterCategory);
        firePropertyChange(MarineLitterBatch.PROPERTY_MARINE_LITTER_CATEGORY, oldValue, marineLitterCategory);
    }

    public CaracteristicQualitativeValue getMarineLitterSizeCategory() {
        return editObject.getMarineLitterSizeCategory();
    }

    public void setMarineLitterSizeCategory(CaracteristicQualitativeValue marineLitterSizeCategory) {
        Object oldValue = getMarineLitterSizeCategory();
        editObject.setMarineLitterSizeCategory(marineLitterSizeCategory);
        firePropertyChange(MarineLitterBatch.PROPERTY_MARINE_LITTER_SIZE_CATEGORY, oldValue, marineLitterSizeCategory);
    }

    public Integer getNumber() {
        return editObject.getNumber();
    }

    public void setNumber(Integer number) {
        Object oldValue = getNumber();
        editObject.setNumber(number);
        firePropertyChange(MarineLitterBatch.PROPERTY_NUMBER, oldValue, number);
    }

    @Override
    protected CreateMarineLitterBatchUIModel newEntity() {
        return new CreateMarineLitterBatchUIModel();
    }

    public void reset() {
        editObject.setMarineLitterCategory(null);
        editObject.setMarineLitterSizeCategory(null);
        editObject.setNumber(null);
    }
}