package fr.ifremer.tutti.ui.swing.content.program;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditProgramUIModel.java 683 2013-03-26 17:02:29Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/program/EditProgramUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * Bean to edit a program.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditProgramUIModel extends AbstractTuttiBeanUIModel<Program, EditProgramUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_ZONE = "zone";

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_NAME = "name";

    protected String name;

    protected String description;

    protected TuttiLocation zone;

    private List<Program> existingPrograms;

    protected static Binder<EditProgramUIModel, Program> toBeanBinder =
            BinderFactory.newBinder(EditProgramUIModel.class,
                                    Program.class);

    protected static Binder<Program, EditProgramUIModel> fromBeanBinder =
            BinderFactory.newBinder(Program.class, EditProgramUIModel.class);


    public EditProgramUIModel() {
        super(Program.class, fromBeanBinder, toBeanBinder);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        Object oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        Object oldValue = getDescription();
        this.description = description;
        firePropertyChange(PROPERTY_COMMENT, oldValue, description);
    }

    public TuttiLocation getZone() {
        return zone;
    }

    public void setZone(TuttiLocation zone) {
        Object oldValue = getZone();
        this.zone = zone;
        firePropertyChange(PROPERTY_ZONE, oldValue, zone);
    }

    public List<Program> getExistingPrograms() {
        return existingPrograms;
    }

    public void setExistingPrograms(List<Program> existingPrograms) {
        this.existingPrograms = existingPrograms;
    }

}
