package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiErrorHelper.java 631 2013-03-15 10:59:47Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/TuttiErrorHelper.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;

import javax.swing.JOptionPane;

import static org.nuiton.i18n.I18n._;

/**
 * helper around errors in Tutti.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class TuttiErrorHelper implements ErrorReporter {

    protected TuttiUIContext context;

    public TuttiErrorHelper(TuttiUIContext context) {
        this.context = context;
    }

    /**
     * Display a user friendly error frame.
     *
     * @param message message for user
     * @param cause   exception cause
     */
    public void showErrorDialog(String message, Throwable cause) {

        if (cause instanceof TuttiBusinessException) {
            JOptionPane.showMessageDialog(context.getMainUI(), cause.getMessage(),
                                          _("tutti.error.ui.business.error"),
                                          JOptionPane.ERROR_MESSAGE);
        } else {

            JXErrorPane pane = new JXErrorPane();
            ErrorInfo info = new ErrorInfo(_("tutti.error.ui.other.error"),
                                           _("tutti.error.errorpane.htmlmessage", message), null, null,
                                           cause, null, null);
            pane.setErrorInfo(info);
            pane.setErrorReporter(this);
            JXErrorPane.showDialog(context.getActionUI(), pane);
        }

    }

    /**
     * Display a user friendly error frame.
     *
     * @param message message for user
     */
    public void showErrorDialog(String message) {
        showErrorDialog(message, null);
    }

    @Override
    public void reportError(ErrorInfo errorInfo) throws NullPointerException {

        showErrorDialog(errorInfo.getBasicErrorMessage(), errorInfo.getErrorException());
    }

}
