package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditCruiseUIModel, EditCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENTS_BUTTON_ENABLED = "attachmentsButton.enabled";
    public static final String BINDING_BEGIN_DATE_FIELD_DATE = "beginDateField.date";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_COUNTRY_COMBO_BOX_SELECTED_ITEM = "countryComboBox.selectedItem";
    public static final String BINDING_END_DATE_FIELD_DATE = "endDateField.date";
    public static final String BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED = "filterVesselAllButton.selected";
    public static final String BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED = "filterVesselFishingButton.selected";
    public static final String BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED = "filterVesselScientificButton.selected";
    public static final String BINDING_GENERATE_NAME_BUTTON_ENABLED = "generateNameButton.enabled";
    public static final String BINDING_MULTIRIG_NUMBER_FIELD_MODEL = "multirigNumberField.model";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM = "programComboBox.selectedItem";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SURVEY_PART_FIELD_TEXT = "surveyPartField.text";
    public static final String BINDING_YEAR_FIELD_MODEL = "yearField.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ButtonAttachment attachmentsButton;
    @ValidatorField( validatorId = "validator",  propertyName = "beginDate",  editorName = "beginDateField")
    protected JXDatePicker beginDateField;
    protected JLabel beginDateLabel;
    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    @ValidatorField( validatorId = "validator",  propertyName = "country",  editorName = "countryComboBox")
    protected BeanFilterableComboBox<Country> countryComboBox;
    protected JLabel countryLabel;
    protected EditCruiseUI editCruiseTopPanel = this;
    @ValidatorField( validatorId = "validator",  propertyName = "endDate",  editorName = "endDateField")
    protected JXDatePicker endDateField;
    protected JLabel endDateLabel;
    protected JRadioButton filterVesselAllButton;
    protected JRadioButton filterVesselFishingButton;
    protected JLabel filterVesselLabel;
    protected JRadioButton filterVesselScientificButton;
    protected JAXXButtonGroup filterVesselType;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearList")
    protected BeanDoubleList<Gear> gearList;
    protected JButton generateNameButton;
    protected EditCruiseUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfMission",  editorName = "headOfMissionList")
    protected BeanDoubleList<Person> headOfMissionList;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfSortRoom",  editorName = "headOfSortRoomList")
    protected BeanDoubleList<Person> headOfSortRoomList;
    protected EditCruiseUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "multirigNumber",  editorName = "multirigNumberField")
    protected NumberEditor multirigNumberField;
    protected JLabel multirigNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programComboBox")
    protected BeanFilterableComboBox<Program> programComboBox;
    protected JLabel programLabel;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "surveyPart",  editorName = "surveyPartField")
    protected JTextField surveyPartField;
    protected JLabel surveyPartLabel;
    protected JToolBar topToolBar;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JPanel vesselFilterPane;
    @ValidatorField( validatorId = "validator",  propertyName = "vessel",  editorName = "vesselList")
    protected BeanDoubleList<Vessel> vesselList;
    @ValidatorField( validatorId = "validator",  propertyName = "year",  editorName = "yearField")
    protected NumberEditor yearField;
    protected JLabel yearLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JSeparator $JSeparator0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  EditCruiseUIHandler handler = new EditCruiseUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditCruiseUI() {
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__beginDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "beginDate");
    }

    public void doActionPerformed__on__endDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "endDate");
    }

    public void doActionPerformed__on__filterVesselAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.ALL);
    }

    public void doActionPerformed__on__filterVesselFishingButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.FISHING);
    }

    public void doActionPerformed__on__filterVesselScientificButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.SCIENTIFIC);
    }

    public void doActionPerformed__on__generateNameButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateCampaignName();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doKeyReleased__on__surveyPartField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "surveyPart");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ButtonAttachment getAttachmentsButton() {
        return attachmentsButton;
    }

    public JXDatePicker getBeginDateField() {
        return beginDateField;
    }

    public JLabel getBeginDateLabel() {
        return beginDateLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public BeanFilterableComboBox<Country> getCountryComboBox() {
        return countryComboBox;
    }

    public JLabel getCountryLabel() {
        return countryLabel;
    }

    public JXDatePicker getEndDateField() {
        return endDateField;
    }

    public JLabel getEndDateLabel() {
        return endDateLabel;
    }

    public JRadioButton getFilterVesselAllButton() {
        return filterVesselAllButton;
    }

    public JRadioButton getFilterVesselFishingButton() {
        return filterVesselFishingButton;
    }

    public JLabel getFilterVesselLabel() {
        return filterVesselLabel;
    }

    public JRadioButton getFilterVesselScientificButton() {
        return filterVesselScientificButton;
    }

    public JAXXButtonGroup getFilterVesselType() {
        return filterVesselType;
    }

    public BeanDoubleList<Gear> getGearList() {
        return gearList;
    }

    public JButton getGenerateNameButton() {
        return generateNameButton;
    }

    public EditCruiseUIHandler getHandler() {
        return handler;
    }

    public BeanDoubleList<Person> getHeadOfMissionList() {
        return headOfMissionList;
    }

    public BeanDoubleList<Person> getHeadOfSortRoomList() {
        return headOfSortRoomList;
    }

    public EditCruiseUIModel getModel() {
        return model;
    }

    public NumberEditor getMultirigNumberField() {
        return multirigNumberField;
    }

    public JLabel getMultirigNumberLabel() {
        return multirigNumberLabel;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public BeanFilterableComboBox<Program> getProgramComboBox() {
        return programComboBox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getSurveyPartField() {
        return surveyPartField;
    }

    public JLabel getSurveyPartLabel() {
        return surveyPartLabel;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    public SwingValidator<EditCruiseUIModel> getValidator() {
        return validator;
    }

    public JPanel getVesselFilterPane() {
        return vesselFilterPane;
    }

    public BeanDoubleList<Vessel> getVesselList() {
        return vesselList;
    }

    public NumberEditor getYearField() {
        return yearField;
    }

    public JLabel getYearLabel() {
        return yearLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToEditCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topToolBar);
        add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToFilterVesselAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselAllButton); }
    }

    protected void addChildrenToFilterVesselFishingButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselFishingButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselFishingButton); }
    }

    protected void addChildrenToFilterVesselScientificButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselScientificButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselScientificButton); }
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(attachmentsButton);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToVesselFilterPane() {
        if (!allComponentsCreated) {
            return;
        }
        vesselFilterPane.add(filterVesselLabel);
        vesselFilterPane.add(filterVesselAllButton);
        vesselFilterPane.add(filterVesselScientificButton);
        vesselFilterPane.add(filterVesselFishingButton);
    }

    protected void createAttachmentsButton() {
        $objectMap.put("attachmentsButton", attachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        attachmentsButton.setName("attachmentsButton");
    }

    protected void createBeginDateField() {
        $objectMap.put("beginDateField", beginDateField = new JXDatePicker());
        
        beginDateField.setName("beginDateField");
        beginDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginDateField"));
        beginDateField.putClientProperty("validatorLabel", _("tutti.editCruise.field.beginDate"));
    }

    protected void createBeginDateLabel() {
        $objectMap.put("beginDateLabel", beginDateLabel = new JLabel());
        
        beginDateLabel.setName("beginDateLabel");
        beginDateLabel.setText(_("tutti.editCruise.field.beginDate"));
        beginDateLabel.setToolTipText(_("tutti.editCruise.field.beginDate.tip"));
        beginDateLabel.putClientProperty("help", "tutti.editCruise.field.beginDate.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editCruise.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.editCruise.action.closeEditCruise"));
        closeButton.setToolTipText(_("tutti.editCruise.action.closeEditCruise.tip"));
        closeButton.putClientProperty("help", "tutti.editCruise.action.close.help");
        closeButton.putClientProperty("tuttiAction", fr.ifremer.tutti.ui.swing.content.SelectCruiseAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", _("tutti.editCruise.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(_("tutti.editCruise.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editCruise.field.comment.help");
    }

    protected void createCountryComboBox() {
        $objectMap.put("countryComboBox", countryComboBox = new BeanFilterableComboBox<Country>(this));
        
        countryComboBox.setName("countryComboBox");
        countryComboBox.setI18nPrefix("tutti.property.");
        countryComboBox.setProperty("country");
        countryComboBox.setShowReset(true);
        countryComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.country"));
    }

    protected void createCountryLabel() {
        $objectMap.put("countryLabel", countryLabel = new JLabel());
        
        countryLabel.setName("countryLabel");
        countryLabel.setText(_("tutti.editCruise.field.country"));
        countryLabel.setToolTipText(_("tutti.editCruise.field.country.tip"));
        countryLabel.putClientProperty("help", "tutti.editCruise.field.country.help");
    }

    protected void createEndDateField() {
        $objectMap.put("endDateField", endDateField = new JXDatePicker());
        
        endDateField.setName("endDateField");
        endDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__endDateField"));
        endDateField.putClientProperty("validatorLabel", _("tutti.editCruise.field.endDate"));
    }

    protected void createEndDateLabel() {
        $objectMap.put("endDateLabel", endDateLabel = new JLabel());
        
        endDateLabel.setName("endDateLabel");
        endDateLabel.setText(_("tutti.editCruise.field.endDate"));
        endDateLabel.setToolTipText(_("tutti.editCruise.field.endDate.tip"));
        endDateLabel.putClientProperty("help", "tutti.editCruise.field.endDate.help");
    }

    protected void createFilterVesselAllButton() {
        $objectMap.put("filterVesselAllButton", filterVesselAllButton = new JRadioButton());
        
        filterVesselAllButton.setName("filterVesselAllButton");
        filterVesselAllButton.setText(_("tutti.editCruise.filterVesselType.all"));
        { filterVesselAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterVesselAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselAllButton.setToolTipText(_("tutti.editCruise.filterVesselType.all.tip"));
        filterVesselAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselAllButton"));
    }

    protected void createFilterVesselFishingButton() {
        $objectMap.put("filterVesselFishingButton", filterVesselFishingButton = new JRadioButton());
        
        filterVesselFishingButton.setName("filterVesselFishingButton");
        filterVesselFishingButton.setText(_("tutti.editCruise.filterVesselType.fishing"));
        { filterVesselFishingButton.putClientProperty("$value", "fishing");  Object $buttonGroup = filterVesselFishingButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselFishingButton.setToolTipText(_("tutti.editCruise.filterVesselType.fishing.tip"));
        filterVesselFishingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselFishingButton"));
    }

    protected void createFilterVesselLabel() {
        $objectMap.put("filterVesselLabel", filterVesselLabel = new JLabel());
        
        filterVesselLabel.setName("filterVesselLabel");
        filterVesselLabel.setText(_("tutti.editCruise.filterVesselType"));
        filterVesselLabel.setToolTipText(_("tutti.editCruise.filterVessel.tip"));
        filterVesselLabel.putClientProperty("help", "tutti.editCruise.filterVessel.help");
        filterVesselLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterVesselScientificButton() {
        $objectMap.put("filterVesselScientificButton", filterVesselScientificButton = new JRadioButton());
        
        filterVesselScientificButton.setName("filterVesselScientificButton");
        filterVesselScientificButton.setText(_("tutti.editCruise.filterVesselType.scientific"));
        { filterVesselScientificButton.putClientProperty("$value", "scientific");  Object $buttonGroup = filterVesselScientificButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselScientificButton.setToolTipText(_("tutti.editCruise.filterVesselType.scientific.tip"));
        filterVesselScientificButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselScientificButton"));
    }

    protected void createFilterVesselType() {
        $objectMap.put("filterVesselType", filterVesselType = new JAXXButtonGroup());
    }

    protected void createGearList() {
        $objectMap.put("gearList", gearList = new BeanDoubleList<Gear>());
        
        gearList.setName("gearList");
        gearList.setI18nPrefix("tutti.property.");
        gearList.setProperty("gear");
        gearList.setShowReset(true);
        gearList.setToolTipText(_("tutti.editCruise.field.gear.tip"));
        gearList.putClientProperty("help", "tutti.editCruise.field.gear.help");
        gearList.putClientProperty("validatorLabel", _("tutti.editCruise.field.gear"));
    }

    protected void createGenerateNameButton() {
        $objectMap.put("generateNameButton", generateNameButton = new JButton());
        
        generateNameButton.setName("generateNameButton");
        generateNameButton.setText(_("tutti.editCruise.action.generateCampaignName"));
        generateNameButton.setToolTipText(_("tutti.editCruise.action.generateName.tip"));
        generateNameButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateNameButton"));
        generateNameButton.putClientProperty("help", "tutti.editCruise.action.generateName.help");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCruiseUIHandler.class));
    }

    protected void createHeadOfMissionList() {
        $objectMap.put("headOfMissionList", headOfMissionList = new BeanDoubleList<Person>());
        
        headOfMissionList.setName("headOfMissionList");
        headOfMissionList.setI18nPrefix("tutti.property.");
        headOfMissionList.setProperty("headOfMission");
        headOfMissionList.setShowReset(true);
        headOfMissionList.setToolTipText(_("tutti.editCruise.field.headOfMission.tip"));
        headOfMissionList.putClientProperty("help", "tutti.editCruise.field.headOfMission.help");
        headOfMissionList.putClientProperty("validatorLabel", _("tutti.editCruise.field.headOfMission"));
    }

    protected void createHeadOfSortRoomList() {
        $objectMap.put("headOfSortRoomList", headOfSortRoomList = new BeanDoubleList<Person>());
        
        headOfSortRoomList.setName("headOfSortRoomList");
        headOfSortRoomList.setI18nPrefix("tutti.property.");
        headOfSortRoomList.setProperty("headOfSortRoom");
        headOfSortRoomList.setShowReset(true);
        headOfSortRoomList.setToolTipText(_("tutti.editCruise.field.headOfSortRoom.tip"));
        headOfSortRoomList.putClientProperty("help", "tutti.editCruise.field.headOfSortRoom.help");
        headOfSortRoomList.putClientProperty("validatorLabel", _("tutti.editCruise.field.headOfSortRoom"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCruiseUIModel.class));
    }

    protected void createMultirigNumberField() {
        $objectMap.put("multirigNumberField", multirigNumberField = new NumberEditor(this));
        
        multirigNumberField.setName("multirigNumberField");
        multirigNumberField.setProperty("multirigNumber");
        multirigNumberField.setUseFloat(false);
        multirigNumberField.setShowReset(true);
        multirigNumberField.putClientProperty("validatorLabel", _("tutti.editCruise.field.multirigNumber"));
    }

    protected void createMultirigNumberLabel() {
        $objectMap.put("multirigNumberLabel", multirigNumberLabel = new JLabel());
        
        multirigNumberLabel.setName("multirigNumberLabel");
        multirigNumberLabel.setText(_("tutti.editCruise.field.multirigNumber"));
        multirigNumberLabel.setToolTipText(_("tutti.editCruise.field.multirigNumber.tip"));
        multirigNumberLabel.putClientProperty("help", "tutti.editCruise.field.multirigNumber.help");
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("validatorLabel", _("tutti.editCruise.field.name"));
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.editCruise.field.name"));
        nameLabel.setToolTipText(_("tutti.editCruise.field.name.tip"));
        nameLabel.putClientProperty("help", "tutti.editCruise.field.name.help");
    }

    protected void createProgramComboBox() {
        $objectMap.put("programComboBox", programComboBox = new BeanFilterableComboBox<Program>(this));
        
        programComboBox.setName("programComboBox");
        programComboBox.setI18nPrefix("tutti.property.");
        programComboBox.setProperty("program");
        programComboBox.setShowReset(true);
        programComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.editCruise.field.program"));
        programLabel.setToolTipText(_("tutti.editCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.editCruise.field.program.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editCruise.action.saveCruise"));
        saveButton.setToolTipText(_("tutti.editCruise.action.saveCruise.tip"));
        saveButton.putClientProperty("help", "tutti.editCruise.action.save.help");
        saveButton.putClientProperty("tuttiAction", SaveCruiseAction.class);
    }

    protected void createSurveyPartField() {
        $objectMap.put("surveyPartField", surveyPartField = new JTextField());
        
        surveyPartField.setName("surveyPartField");
        surveyPartField.setColumns(15);
        surveyPartField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__surveyPartField"));
        surveyPartField.putClientProperty("validatorLabel", _("tutti.editCruise.field.surveyPart"));
    }

    protected void createSurveyPartLabel() {
        $objectMap.put("surveyPartLabel", surveyPartLabel = new JLabel());
        
        surveyPartLabel.setName("surveyPartLabel");
        surveyPartLabel.setText(_("tutti.editCruise.field.surveyPart"));
        surveyPartLabel.setToolTipText(_("tutti.editCruise.field.surveyPart.tip"));
        surveyPartLabel.putClientProperty("help", "tutti.editCruise.field.surveyPart.help");
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCruiseUIModel.class, null));
    }

    protected void createVesselFilterPane() {
        $objectMap.put("vesselFilterPane", vesselFilterPane = new JPanel());
        
        vesselFilterPane.setName("vesselFilterPane");
    }

    protected void createVesselList() {
        $objectMap.put("vesselList", vesselList = new BeanDoubleList<Vessel>());
        
        vesselList.setName("vesselList");
        vesselList.setI18nPrefix("tutti.property.");
        vesselList.setProperty("vessel");
        vesselList.setShowReset(true);
        vesselList.setToolTipText(_("tutti.editCruise.field.vessel.tip"));
        vesselList.putClientProperty("help", "tutti.editCruise.field.vessel.help");
        vesselList.putClientProperty("validatorLabel", _("tutti.editCruise.field.vessel"));
    }

    protected void createYearField() {
        $objectMap.put("yearField", yearField = new NumberEditor(this));
        
        yearField.setName("yearField");
        yearField.setProperty("year");
        yearField.setUseFloat(false);
        yearField.setShowReset(true);
        yearField.putClientProperty("validatorLabel", _("tutti.editCruise.field.year"));
    }

    protected void createYearLabel() {
        $objectMap.put("yearLabel", yearLabel = new JLabel());
        
        yearLabel.setName("yearLabel");
        yearLabel.setText(_("tutti.editCruise.field.year"));
        yearLabel.setToolTipText(_("tutti.editCruise.field.year.tip"));
        yearLabel.putClientProperty("help", "tutti.editCruise.field.year.help");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditCruiseTopPanel();
        addChildrenToValidator();
        addChildrenToTopToolBar();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(yearLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(yearField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(surveyPartLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(surveyPartField), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(generateNameButton, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(multirigNumberLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(multirigNumberField), new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(countryLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(countryComboBox), new GridBagConstraints(1, 2, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDateLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(beginDateField), new GridBagConstraints(3, 2, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDateLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(endDateField), new GridBagConstraints(5, 2, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselFilterPane, new GridBagConstraints(0, 4, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 5, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 6, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 7, 6, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 8, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToVesselFilterPane();
        addChildrenToFilterVesselAllButton();
        addChildrenToFilterVesselScientificButton();
        addChildrenToFilterVesselFishingButton();
        // inline complete setup of $JPanel0
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(vesselList));
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(gearList));
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfMissionList));
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfSortRoomList));
        addChildrenToCommentPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(closeButton);
        $JPanel2.add(saveButton);
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 44 property setters
        programComboBox.setBeanType(Program.class);
        countryComboBox.setBeanType(Country.class);
        vesselList.setBeanType(Vessel.class);
        gearList.setBeanType(Gear.class);
        headOfMissionList.setBeanType(Person.class);
        headOfSortRoomList.setBeanType(Person.class);
        programLabel.setLabelFor(programComboBox);
        programComboBox.setBean(model);
        yearLabel.setLabelFor(yearField);
        yearField.setBean(model);
        yearField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        yearField.setNumberPattern(INT_4_DIGITS_PATTERN);
        yearField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        surveyPartLabel.setLabelFor(surveyPartField);
        nameLabel.setLabelFor(nameField);
        generateNameButton.setIcon(SwingUtil.createActionIcon("generate"));
        generateNameButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCruise.action.generateCampaignName.mnemonic"),'Z'));
        multirigNumberLabel.setLabelFor(multirigNumberField);
        multirigNumberField.setBean(model);
        multirigNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        multirigNumberField.setNumberPattern(INT_1_DIGITS_PATTERN);
        multirigNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        countryLabel.setLabelFor(countryComboBox);
        countryComboBox.setBean(model);
        beginDateLabel.setLabelFor(beginDateField);
        endDateLabel.setLabelFor(endDateField);
        filterVesselLabel.setIcon(SwingUtil.createActionIcon("filter"));
        vesselList.setBean(model);
        vesselList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.vessel")));
        gearList.setBean(model);
        gearList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.gear")));
        headOfMissionList.setBean(model);
        headOfMissionList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.headOfMission")));
        headOfSortRoomList.setBean(model);
        headOfSortRoomList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.headOfSortRoom")));
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.comment")));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCruise.action.closeEditCruise.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCruise.action.saveCruise.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editCruiseTopPanel, "tutti.editCruise.help");
        registerHelpId(_broker, programLabel, "tutti.editCruise.field.program.help");
        registerHelpId(_broker, yearLabel, "tutti.editCruise.field.year.help");
        registerHelpId(_broker, surveyPartLabel, "tutti.editCruise.field.surveyPart.help");
        registerHelpId(_broker, nameLabel, "tutti.editCruise.field.name.help");
        registerHelpId(_broker, generateNameButton, "tutti.editCruise.action.generateName.help");
        registerHelpId(_broker, multirigNumberLabel, "tutti.editCruise.field.multirigNumber.help");
        registerHelpId(_broker, countryLabel, "tutti.editCruise.field.country.help");
        registerHelpId(_broker, beginDateLabel, "tutti.editCruise.field.beginDate.help");
        registerHelpId(_broker, endDateLabel, "tutti.editCruise.field.endDate.help");
        registerHelpId(_broker, filterVesselLabel, "tutti.editCruise.filterVessel.help");
        registerHelpId(_broker, vesselList, "tutti.editCruise.field.vessel.help");
        registerHelpId(_broker, gearList, "tutti.editCruise.field.gear.help");
        registerHelpId(_broker, headOfMissionList, "tutti.editCruise.field.headOfMission.help");
        registerHelpId(_broker, headOfSortRoomList, "tutti.editCruise.field.headOfSortRoom.help");
        registerHelpId(_broker, commentPane, "tutti.editCruise.field.comment.help");
        registerHelpId(_broker, closeButton, "tutti.editCruise.action.close.help");
        registerHelpId(_broker, saveButton, "tutti.editCruise.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editCruiseTopPanel", editCruiseTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createTopToolBar();
        createAttachmentsButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createProgramComboBox();
        createYearLabel();
        createYearField();
        createSurveyPartLabel();
        createSurveyPartField();
        createNameLabel();
        createNameField();
        createGenerateNameButton();
        createMultirigNumberLabel();
        createMultirigNumberField();
        createCountryLabel();
        createCountryComboBox();
        createBeginDateLabel();
        createBeginDateField();
        createEndDateLabel();
        createEndDateField();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator(SwingConstants.HORIZONTAL));
        
        $JSeparator0.setName("$JSeparator0");
        createVesselFilterPane();
        createFilterVesselLabel();
        createFilterVesselAllButton();
        createFilterVesselScientificButton();
        createFilterVesselFishingButton();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createVesselList();
        createGearList();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createHeadOfMissionList();
        createHeadOfSortRoomList();
        createCommentPane();
        createCommentField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createSaveButton();
        createFilterVesselType();
        // inline creation of editCruiseTopPanel
        setName("editCruiseTopPanel");
        setLayout(new BorderLayout());
        editCruiseTopPanel.putClientProperty("help", "tutti.editCruise.help");
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    attachmentsButton.setEnabled(model.getId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programComboBox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_YEAR_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("year", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    yearField.setModel(model.getYear());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("year", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_PART_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyPart", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(surveyPartField, model.getSurveyPart());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyPart", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_NAME_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerateName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateNameButton.setEnabled(model.isCanGenerateName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerateName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MULTIRIG_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("multirigNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    multirigNumberField.setModel(model.getMultirigNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("multirigNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COUNTRY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("country", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    countryComboBox.setSelectedItem(model.getCountry());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("country", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BEGIN_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("beginDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    beginDateField.setDate(model.getBeginDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("beginDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("endDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    endDateField.setDate(model.getEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("endDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselAllButton.setSelected(model.isVesselTypeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeScientific", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselScientificButton.setSelected(model.isVesselTypeScientific());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeScientific", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeFishing", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselFishingButton.setSelected(model.isVesselTypeFishing());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeFishing", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}