package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: UpdateApplicationAction.java 600 2013-03-12 23:08:47Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/UpdateApplicationAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.updater.ApplicationUpdater;

import java.io.File;

/**
 * To update jre / i18n or tutti using the {@link ApplicationUpdater} mecanism.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class UpdateApplicationAction extends AbstractTuttiAction<TuttiUIContext, MainUI, MainUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(UpdateApplicationAction.class);

    public UpdateApplicationAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected void doAction() throws Exception {

        TuttiUIContext context = getContext();
        TuttiApplicationConfig config = context.getConfig();

        File current = config.getTuttiBasedir();
        if (current == null || !current.exists()) {

            // can not update application
            if (log.isWarnEnabled()) {
                log.warn("No application base directory defined, skip updates.");
            }
        } else {

            String url = config.getUpdateUrl();
            File dest = new File(config.getTuttiBasedir(), "NEW");

            if (log.isInfoEnabled()) {
                log.info(String.format("Try to update jre, i18N, help or tutti (current application location: %s), using update url: %s", current, url));
            }

            ProgressionModel progressionModel = new ProgressionModel();
            context.getActionUI().getModel().setProgressionModel(progressionModel);
            progressionModel.setMessage("Recherche de mises à jour de JRE / Tutti / I18N / Help");

            TuttiApplicationUpdaterCallBack callback =
                    new TuttiApplicationUpdaterCallBack(this, progressionModel);

            callback.setTypes(TuttiApplicationUpdaterCallBack.UpdateType.JRE,
                              TuttiApplicationUpdaterCallBack.UpdateType.I18N,
                              TuttiApplicationUpdaterCallBack.UpdateType.TUTTI,
                              TuttiApplicationUpdaterCallBack.UpdateType.HELP);
            ApplicationUpdater up = new ApplicationUpdater();
            up.setDownloadMonitor(progressionModel);
            up.update(url,
                      current,
                      dest,
                      false,
                      callback);

            if (callback.isApplicationUpdated()) {

                // tell user restart will be done

                TuttiUIUtil.showSuccessMessage(
                        getUI(),
                        "Redémarrage de Tutti nécessaire...",
                        "La mise à jour nécessite le rédémarrage du Tutti.\nL'application va se fermer puis se réouvrir automatiquement."
                );

                callback.restart();

            } else {

                sendMessage("Aucune mise à jour de l'application détectée.");
            }
//            getContext().getActionUI().getModel().clear();
        }
    }
}