/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwingSession {
    private static Log log = LogFactory.getLog(SwingSession.class);
    protected File file;
    protected boolean autoSave;
    protected LinkedHashSet<Component> registeredComponent = new LinkedHashSet();
    protected Map<Class, State> stateManager = new HashMap<Class, State>();
    protected Map<String, State> states;

    public SwingSession(File file, boolean autoSave) {
        this.file = file;
        this.autoSave = autoSave;
        this.stateManager.put(Window.class, new WindowState());
        this.stateManager.put(JTable.class, new JTableState());
        this.stateManager.put(JTabbedPane.class, new JTabbedPaneState());
        this.stateManager.put(JSplitPane.class, new JSplitPaneState());
        this.states = this.loadStates(file);
        if (this.states == null) {
            this.states = new HashMap<String, State>();
        }
    }

    protected void finalize() throws Throwable {
        this.save();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        this.updateState();
        AbortExceptionListener el = new AbortExceptionListener();
        ByteArrayOutputStream bst = new ByteArrayOutputStream();
        XMLEncoder e = null;
        try {
            e = new XMLEncoder(bst);
            e.setPersistenceDelegate(Rectangle.class, new RectanglePD());
            e.setExceptionListener(el);
            e.writeObject(this.states);
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
        if (el.exception != null) {
            log.warn((Object)("save failed \"" + this.file + "\""), (Throwable)el.exception);
        } else {
            FileOutputStream ost = null;
            try {
                ost = new FileOutputStream(this.file);
                ((OutputStream)ost).write(bst.toByteArray());
            }
            catch (IOException eee) {
                log.warn((Object)("save failed \"" + this.file + "\""), (Throwable)eee);
            }
            finally {
                if (ost != null) {
                    try {
                        ((OutputStream)ost).close();
                    }
                    catch (IOException eee) {
                        log.warn((Object)("can't close properly \"" + this.file + "\""), (Throwable)eee);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, State> loadStates(File file) {
        Map result = null;
        if (file.exists()) {
            XMLDecoder d = null;
            try {
                FileInputStream ist = new FileInputStream(file);
                d = new XMLDecoder(ist);
                AbortExceptionListener eee = new AbortExceptionListener();
                d.setExceptionListener(eee);
                Object bean = d.readObject();
                if (eee.exception != null) {
                    log.warn((Object)("load failed \"" + file + "\""), (Throwable)eee.exception);
                } else {
                    result = (Map)bean;
                }
            }
            catch (IOException eee) {
                log.warn((Object)("load failed \"" + file + "\""), (Throwable)eee);
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        return result;
    }

    public void updateState() {
        this.walkThrowComponent("", this.registeredComponent, new SaveStateAction());
    }

    public void add(Component c) {
        if (this.registeredComponent.contains(c)) {
            log.warn((Object)String.format("Component already added %s(%s)", c.getClass(), c.getName()));
        } else {
            this.registeredComponent.add(c);
            this.walkThrowComponent("", Collections.singleton(c), new RestoreStateAction());
        }
    }

    public void remove(Component c) {
        this.registeredComponent.remove(c);
    }

    protected String getComponentName(Component c) {
        String name = c.getName();
        if (name == null) {
            int n = c.getParent().getComponentZOrder(c);
            if (n >= 0) {
                Class<?> clazz = c.getClass();
                name = clazz.getSimpleName();
                if (name.length() == 0) {
                    name = "Anonymous" + clazz.getSuperclass().getSimpleName();
                }
                name = name + n;
            } else {
                log.warn((Object)("Couldn't compute pathname for " + c));
            }
        }
        return name;
    }

    public State getStateManager(Class clazz) {
        State result = null;
        while (result == null && clazz != null) {
            result = this.stateManager.get(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public State getStates(String path) {
        return this.states.get(path);
    }

    public void setStates(String path, State state) {
        this.states.put(path, state);
    }

    protected void walkThrowComponent(String path, Collection<Component> roots, Action action) {
        for (Component root : roots) {
            Component[] children;
            if (root == null) continue;
            String pathname = path + "/" + this.getComponentName(root);
            State state = this.getStateManager(root.getClass());
            if (state != null) {
                action.doAction(this, pathname, root);
            }
            if (root instanceof Container && (children = ((Container)root).getComponents()) != null && children.length > 0) {
                this.walkThrowComponent(pathname, Arrays.asList(children), action);
            }
            if (!(root instanceof JFrame) || (children = ((JFrame)root).getContentPane().getComponents()) == null || children.length <= 0) continue;
            this.walkThrowComponent(pathname, Arrays.asList(children), action);
        }
    }

    public static void main(String[] args) {
        final SwingSession session = new SwingSession(new File("/tmp/SwingSession.config"), false);
        JFrame frame = new JFrame("truc");
        frame.setDefaultCloseOperation(3);
        frame.setBounds(10, 20, 300, 500);
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                return "c" + column;
            }

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public int getRowCount() {
                return 10;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return new Integer(row * col);
            }
        };
        JTable table = new JTable(dataModel);
        table.setName("MaTable");
        JTabbedPane tab = new JTabbedPane();
        tab.setName("MaTab");
        tab.add("tab1", new JTextArea());
        tab.add("tab2", new JTextArea());
        tab.add("tab3", new JTextArea());
        JSplitPane split = new JSplitPane();
        split.setTopComponent(new JScrollPane(table));
        split.setBottomComponent(tab);
        JButton button = new JButton("Save");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                session.save();
            }
        });
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)button, "North");
        frame.getContentPane().add((Component)split, "Center");
        frame.setVisible(true);
        session.add(frame);
        session.save();
    }

    public static class WindowState
    implements State {
        private static final String WINDOW_STATE_NORMAL_BOUNDS = "WindowState.normalBounds";
        protected Rectangle bounds;
        protected Rectangle gcBounds;
        protected int frameState = 0;

        public WindowState() {
        }

        public WindowState(Rectangle bounds, Rectangle gcBounds, int frameState) {
            this.bounds = new Rectangle(bounds);
            this.gcBounds = new Rectangle(gcBounds);
            this.frameState = frameState;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }

        public Rectangle getGcBounds() {
            return this.gcBounds;
        }

        public void setGcBounds(Rectangle gcBounds) {
            this.gcBounds = gcBounds;
        }

        public int getFrameState() {
            return this.frameState;
        }

        public void setFrameState(int frameState) {
            this.frameState = frameState;
        }

        protected Window checkComponent(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(o instanceof Window)) {
                throw new IllegalArgumentException("invalid component");
            }
            return (Window)o;
        }

        protected static boolean isResizable(Window window) {
            boolean resizable = true;
            if (window instanceof Frame) {
                resizable = ((Frame)window).isResizable();
            } else if (window instanceof Dialog) {
                resizable = ((Dialog)window).isResizable();
            }
            return resizable;
        }

        protected static Rectangle getWindowNormalBounds(Window window) {
            Object res;
            Rectangle result = null;
            if (window instanceof JFrame && (res = ((JFrame)window).getRootPane().getClientProperty(WINDOW_STATE_NORMAL_BOUNDS)) instanceof Rectangle) {
                result = (Rectangle)res;
            }
            return result;
        }

        public static Rectangle computeVirtualGraphicsBounds() {
            GraphicsDevice[] gs;
            Rectangle virtualBounds = new Rectangle();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
                GraphicsConfiguration gc = gd.getDefaultConfiguration();
                virtualBounds = virtualBounds.union(gc.getBounds());
            }
            return virtualBounds;
        }

        public static void putWindowNormalBounds(Window window, Rectangle bounds) {
            if (window instanceof JFrame) {
                ((JFrame)window).getRootPane().putClientProperty(WINDOW_STATE_NORMAL_BOUNDS, bounds);
            }
        }

        @Override
        public State getState(Object o) {
            GraphicsConfiguration gc;
            Window c = this.checkComponent(o);
            int frameState = 0;
            if (c instanceof Frame) {
                frameState = ((Frame)c).getExtendedState();
            }
            Rectangle gcBounds = (gc = c.getGraphicsConfiguration()) == null ? null : gc.getBounds();
            Rectangle frameBounds = c.getBounds();
            if (c instanceof JFrame && 0 != (frameState & 6)) {
                frameBounds = WindowState.getWindowNormalBounds(c);
            }
            WindowState result = null;
            if (frameBounds != null && !frameBounds.isEmpty()) {
                result = new WindowState();
                result.setBounds(frameBounds);
                result.setGcBounds(gcBounds);
                result.setFrameState(frameState);
            }
            return result;
        }

        @Override
        public void setState(Object o, State state) {
            Window w = this.checkComponent(o);
            if (state != null && !(state instanceof WindowState)) {
                throw new IllegalArgumentException("invalid state");
            }
            WindowState windowState = (WindowState)state;
            if (windowState.getBounds() != null) {
                Rectangle gcBounds0;
                WindowState.putWindowNormalBounds(w, windowState.getBounds());
                if (!w.isLocationByPlatform() && state != null && (gcBounds0 = windowState.getGcBounds()) != null && WindowState.isResizable(w)) {
                    if (WindowState.computeVirtualGraphicsBounds().contains(gcBounds0.getLocation())) {
                        w.setBounds(windowState.getBounds());
                    } else {
                        w.setSize(windowState.getBounds().getSize());
                    }
                }
                if (w instanceof Frame) {
                    ((Frame)w).setExtendedState(windowState.getFrameState());
                }
            }
        }
    }

    public static class JTableState
    implements State {
        protected int[] columnWidths = new int[0];

        public JTableState() {
        }

        public JTableState(int[] columnWidths) {
            this.columnWidths = columnWidths;
        }

        public int[] getColumnWidths() {
            return this.columnWidths;
        }

        public void setColumnWidths(int[] columnWidths) {
            this.columnWidths = columnWidths;
        }

        protected JTable checkComponent(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(o instanceof JTable)) {
                throw new IllegalArgumentException("invalid component");
            }
            return (JTable)o;
        }

        @Override
        public State getState(Object o) {
            JTable table = this.checkComponent(o);
            int[] columnWidths = new int[table.getColumnCount()];
            boolean resizableColumnExists = false;
            for (int i = 0; i < columnWidths.length; ++i) {
                TableColumn tc = table.getColumnModel().getColumn(i);
                int n = columnWidths[i] = tc.getResizable() ? tc.getWidth() : -1;
                if (!tc.getResizable()) continue;
                resizableColumnExists = true;
            }
            JTableState result = null;
            if (resizableColumnExists) {
                result = new JTableState();
                result.setColumnWidths(columnWidths);
            }
            return result;
        }

        @Override
        public void setState(Object o, State state) {
            if (!(state instanceof JTableState)) {
                throw new IllegalArgumentException("invalid state");
            }
            JTable table = this.checkComponent(o);
            int[] columnWidths = ((JTableState)state).getColumnWidths();
            if (columnWidths != null && table.getColumnCount() == columnWidths.length) {
                for (int i = 0; i < columnWidths.length; ++i) {
                    TableColumn tc;
                    if (columnWidths[i] == -1 || !(tc = table.getColumnModel().getColumn(i)).getResizable()) continue;
                    tc.setPreferredWidth(columnWidths[i]);
                }
            }
        }
    }

    public static class JSplitPaneState
    implements State {
        protected int dividerLocation = -1;
        protected int orientation = 1;

        public int getDividerLocation() {
            return this.dividerLocation;
        }

        public void setDividerLocation(int dividerLocation) {
            this.dividerLocation = dividerLocation;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public void setOrientation(int orientation) {
            this.orientation = orientation;
        }

        protected JSplitPane checkComponent(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(o instanceof JSplitPane)) {
                throw new IllegalArgumentException("invalid component");
            }
            return (JSplitPane)o;
        }

        @Override
        public State getState(Object o) {
            JSplitPane p = this.checkComponent(o);
            JSplitPaneState result = new JSplitPaneState();
            result.setDividerLocation(p.getUI().getDividerLocation(p));
            result.setOrientation(p.getOrientation());
            return result;
        }

        @Override
        public void setState(Object o, State state) {
            if (state == null) {
                return;
            }
            JSplitPane p = this.checkComponent(o);
            if (state instanceof JSplitPaneState) {
                JSplitPaneState sps = (JSplitPaneState)state;
                if (sps.getDividerLocation() != -1 && p.getOrientation() == sps.getOrientation()) {
                    p.setDividerLocation(sps.getDividerLocation());
                }
            } else {
                throw new IllegalArgumentException("invalid state");
            }
        }
    }

    public static class JTabbedPaneState
    implements State {
        protected int selectedIndex = -1;
        protected int tabCount;

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        public int getTabCount() {
            return this.tabCount;
        }

        public void setTabCount(int tabCount) {
            this.tabCount = tabCount;
        }

        protected JTabbedPane checkComponent(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(o instanceof JTabbedPane)) {
                throw new IllegalArgumentException("invalid component");
            }
            return (JTabbedPane)o;
        }

        @Override
        public State getState(Object o) {
            JTabbedPaneState result = new JTabbedPaneState();
            JTabbedPane p = this.checkComponent(o);
            result.setSelectedIndex(p.getSelectedIndex());
            result.setTabCount(p.getTabCount());
            return result;
        }

        @Override
        public void setState(Object o, State state) {
            if (state == null) {
                return;
            }
            if (state instanceof JTabbedPaneState) {
                JTabbedPane p = this.checkComponent(o);
                JTabbedPaneState tps = (JTabbedPaneState)state;
                if (tps.getSelectedIndex() != -1 && p.getTabCount() == tps.getTabCount()) {
                    p.setSelectedIndex(tps.getSelectedIndex());
                }
            } else {
                throw new IllegalArgumentException("invalid state");
            }
        }
    }

    public static interface State {
        public State getState(Object var1);

        public void setState(Object var1, State var2);
    }

    public static class RestoreStateAction
    implements Action {
        @Override
        public void doAction(SwingSession session, String path, Component c) {
            State manager = session.getStateManager(c.getClass());
            State state = session.getStates(path);
            if (state != null) {
                manager.setState(c, state);
            }
        }
    }

    public static class SaveStateAction
    implements Action {
        @Override
        public void doAction(SwingSession session, String path, Component c) {
            State manager = session.getStateManager(c.getClass());
            State state = manager.getState(c);
            session.setStates(path, state);
        }
    }

    public static interface Action {
        public void doAction(SwingSession var1, String var2, Component var3);
    }

    private static class RectanglePD
    extends DefaultPersistenceDelegate {
        public RectanglePD() {
            super(new String[]{"x", "y", "width", "height"});
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Rectangle oldR = (Rectangle)oldInstance;
            Object[] constructorArgs = new Object[]{oldR.x, oldR.y, oldR.width, oldR.height};
            return new Expression(oldInstance, oldInstance.getClass(), "new", constructorArgs);
        }
    }

    private static class AbortExceptionListener
    implements ExceptionListener {
        public Exception exception = null;

        private AbortExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            if (this.exception == null) {
                this.exception = e;
            }
        }
    }
}

