/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FtpsFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final FtpsFileSystemConfigBuilder BUILDER = new FtpsFileSystemConfigBuilder();
    private static final String FACTORY_KEY = FTPFileEntryParserFactory.class.getName() + ".KEY";
    private static final String PASSIVE_MODE = FtpsFileSystemConfigBuilder.class.getName() + ".PASSIVE";
    private static final String USER_DIR_IS_ROOT = FtpsFileSystemConfigBuilder.class.getName() + ".USER_DIR_IS_ROOT";
    private static final String DATA_TIMEOUT = FtpsFileSystemConfigBuilder.class.getName() + ".DATA_TIMEOUT";
    private static final String FTPS_TYPE = FtpsFileSystemConfigBuilder.class.getName() + ".FTPS_TYPE";
    private static final String SERVER_LANGUAGE_CODE = FtpsFileSystemConfigBuilder.class.getName() + ".SERVER_LANGUAGE_CODE";
    private static final String DEFAULT_DATE_FORMAT = FtpsFileSystemConfigBuilder.class.getName() + ".DEFAULT_DATE_FORMAT";
    private static final String RECENT_DATE_FORMAT = FtpsFileSystemConfigBuilder.class.getName() + ".RECENT_DATE_FORMAT";
    private static final String SERVER_TIME_ZONE_ID = FtpsFileSystemConfigBuilder.class.getName() + ".SERVER_TIME_ZONE_ID";
    private static final String SHORT_MONTH_NAMES = FtpsFileSystemConfigBuilder.class.getName() + ".SHORT_MONTH_NAMES";

    private FtpsFileSystemConfigBuilder() {
    }

    public static FtpsFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setEntryParserFactory(FileSystemOptions opts, FTPFileEntryParserFactory factory) {
        this.setParam(opts, FTPFileEntryParserFactory.class.getName(), factory);
    }

    public FTPFileEntryParserFactory getEntryParserFactory(FileSystemOptions opts) {
        return (FTPFileEntryParserFactory)this.getParam(opts, FTPFileEntryParserFactory.class.getName());
    }

    public void setEntryParser(FileSystemOptions opts, String key) {
        this.setParam(opts, FACTORY_KEY, key);
    }

    public String getEntryParser(FileSystemOptions opts) {
        return (String)this.getParam(opts, FACTORY_KEY);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return FtpFileSystem.class;
    }

    public void setPassiveMode(FileSystemOptions opts, boolean passiveMode) {
        this.setParam(opts, PASSIVE_MODE, passiveMode ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getPassiveMode(FileSystemOptions opts) {
        return (Boolean)this.getParam(opts, PASSIVE_MODE);
    }

    public void setUserDirIsRoot(FileSystemOptions opts, boolean userDirIsRoot) {
        this.setParam(opts, USER_DIR_IS_ROOT, userDirIsRoot ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions opts) {
        return this.getBoolean(opts, USER_DIR_IS_ROOT, Boolean.TRUE);
    }

    public void setFtpsType(FileSystemOptions opts, String ftpsType) {
        this.setParam(opts, FTPS_TYPE, ftpsType);
    }

    public String getFtpsType(FileSystemOptions opts) {
        return this.getString(opts, FTPS_TYPE, "explicit");
    }

    public Integer getDataTimeout(FileSystemOptions opts) {
        return (Integer)this.getParam(opts, DATA_TIMEOUT);
    }

    public void setDataTimeout(FileSystemOptions opts, Integer dataTimeout) {
        this.setParam(opts, DATA_TIMEOUT, dataTimeout);
    }

    public String getServerLanguageCode(FileSystemOptions opts) {
        return (String)this.getParam(opts, SERVER_LANGUAGE_CODE);
    }

    public void setServerLanguageCode(FileSystemOptions opts, String serverLanguageCode) {
        this.setParam(opts, SERVER_LANGUAGE_CODE, serverLanguageCode);
    }

    public String getDefaultDateFormat(FileSystemOptions opts) {
        return (String)this.getParam(opts, DEFAULT_DATE_FORMAT);
    }

    public void setDefaultDateFormat(FileSystemOptions opts, String defaultDateFormat) {
        this.setParam(opts, DEFAULT_DATE_FORMAT, defaultDateFormat);
    }

    public String getRecentDateFormat(FileSystemOptions opts) {
        return (String)this.getParam(opts, RECENT_DATE_FORMAT);
    }

    public void setRecentDateFormat(FileSystemOptions opts, String recentDateFormat) {
        this.setParam(opts, RECENT_DATE_FORMAT, recentDateFormat);
    }

    public String getServerTimeZoneId(FileSystemOptions opts) {
        return (String)this.getParam(opts, SERVER_TIME_ZONE_ID);
    }

    public void setServerTimeZoneId(FileSystemOptions opts, String serverTimeZoneId) {
        this.setParam(opts, SERVER_TIME_ZONE_ID, serverTimeZoneId);
    }

    public String[] getShortMonthNames(FileSystemOptions opts) {
        return (String[])this.getParam(opts, SHORT_MONTH_NAMES);
    }

    public void setShortMonthNames(FileSystemOptions opts, String[] shortMonthNames) {
        String[] clone = null;
        if (shortMonthNames != null) {
            clone = new String[shortMonthNames.length];
            System.arraycopy(shortMonthNames, 0, clone, 0, shortMonthNames.length);
        }
        this.setParam(opts, SHORT_MONTH_NAMES, clone);
    }
}

