package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCatchesUIModel.java 567 2013-03-09 13:59:14Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/EditCatchesUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditCatchesUIModel extends AbstractTuttiBeanUIModel<CatchBatch, EditCatchesUIModel> implements AttachmentModelAware {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CATCH_TOTAL_WEIGHT = "catchTotalWeight";

    public static final String PROPERTY_CATCH_TOTAL_COMPUTED_WEIGHT = "catchTotalComputedWeight";

    public static final String PROPERTY_CATCH_TOTAL_SORTED_COMPUTED_WEIGHT = "catchTotalSortedComputedWeight";

    public static final String PROPERTY_CATCH_TOTAL_UNSORTED_COMPUTED_WEIGHT = "catchTotalUnsortedComputedWeight";

    public static final String PROPERTY_CATCH_TOTAL_SORTED_TREMIS_WEIGHT = "catchTotalSortedTremisWeight";

    public static final String PROPERTY_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT = "catchTotalSortedCarousselWeight";

    public static final String PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT = "catchTotalRejectedWeight";

    public static final String PROPERTY_CATCH_TOTAL_REJECTED_COMPUTED_WEIGHT = "catchTotalRejectedComputedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_COMPUTED_WEIGHT = "speciesTotalComputedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT = "speciesTotalSortedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_SORTED_COMPUTED_WEIGHT = "speciesTotalSortedComputedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_UNSORTED_COMPUTED_WEIGHT = "speciesTotalUnsortedComputedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT = "speciesTotalSampleSortedComputedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_INERT_WEIGHT = "speciesTotalInertWeight";

    public static final String PROPERTY_SPECIES_TOTAL_INERT_COMPUTED_WEIGHT = "speciesTotalInerComputedtWeight";

    public static final String PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT = "speciesTotalLivingNotItemizedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_COMPUTED_WEIGHT = "speciesTotalLivingNotItemizedComputedWeight";

    public static final String PROPERTY_BENTHOS_TOTAL_WEIGHT = "benthosTotalWeight";

    public static final String PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT = "benthosTotalSortedWeight";

    public static final String PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT = "benthosTotalUnsortedWeight";

    public static final String PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT = "benthosTotalSampleSortedWeight";

    public static final String PROPERTY_PLANKTON_TOTAL_WEIGHT = "planktonTotalWeight";

    public static final String PROPERTY_PLANKTON_TOTAL_SAMPLE_WEIGHT = "planktonTotalSampleWeight";

    public static final String PROPERTY_MACRO_WASTE_TOTAL_WEIGHT = "macroWasteTotalWeight";

    public static final String PROPERTY_FISHING_OPERATION = "fishingOperation";

    public static final String PROPERTY_CATCH_BATCH = "catchBatch";

    protected static final Binder<CatchBatch, EditCatchesUIModel> fromBeanBinder = BinderFactory.newBinder(CatchBatch.class, EditCatchesUIModel.class);

    protected static final Binder<EditCatchesUIModel, CatchBatch> toBeanBinder = BinderFactory.newBinder(EditCatchesUIModel.class, CatchBatch.class);

    protected Float speciesTotalComputedWeight;

    protected TuttiComputedOrNotData<Float> speciesTotalSortedComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    protected Float speciesTotalUnsortedComputedWeight;

    protected Float speciesTotalSampleSortedComputedWeight;

    protected TuttiComputedOrNotData<Float> speciesTotalInertComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    protected TuttiComputedOrNotData<Float> speciesTotalLivingNotItemizedComputedOrNotWeight = new TuttiComputedOrNotData<Float>();

    protected Float benthosTotalWeight;

    protected Float benthosTotalSortedWeight;

    protected Float benthosTotalUnsortedWeight;

    protected Float benthosTotalSampleSortedWeight;

    protected Float planktonTotalWeight;

    protected Float planktonTotalSampleWeight;

    protected Float macroWasteTotalWeight;

    protected TuttiComputedOrNotData<Float> catchTotalComputedOrNotWeight
            = new TuttiComputedOrNotData<Float>();

    protected Float catchTotalSortedComputedWeight;

    protected Float catchTotalUnsortedComputedWeight;

    protected Float catchTotalSortedTremisWeight;

    protected Float catchTotalSortedCarousselWeight;

    protected TuttiComputedOrNotData<Float> catchTotalRejectedComputedOrNotWeight
            = new TuttiComputedOrNotData<Float>();

    protected FishingOperation fishingOperation;

    protected CatchBatch catchBatch;

    protected final List<Attachment> attachment = Lists.newArrayList();

    public EditCatchesUIModel() {
        super(CatchBatch.class, fromBeanBinder, toBeanBinder);
        speciesTotalSortedComputedOrNotWeight.addPropertyChangeListener(
                TuttiComputedOrNotData.PROPERTY_DATA,
                new PropertyChangeListener() {

                    public void propertyChange(PropertyChangeEvent evt) {
                        firePropertyChange(PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT,
                                           evt.getOldValue(), evt.getNewValue());
                    }
                });
        catchTotalComputedOrNotWeight.addPropertyChangeListener(
                TuttiComputedOrNotData.PROPERTY_DATA,
                new PropertyChangeListener() {

                    public void propertyChange(PropertyChangeEvent evt) {
                        firePropertyChange(PROPERTY_CATCH_TOTAL_WEIGHT,
                                           evt.getOldValue(), evt.getNewValue());
                    }
                });
        catchTotalRejectedComputedOrNotWeight.addPropertyChangeListener(
                TuttiComputedOrNotData.PROPERTY_DATA,
                new PropertyChangeListener() {

                    public void propertyChange(PropertyChangeEvent evt) {
                        firePropertyChange(PROPERTY_CATCH_TOTAL_COMPUTED_WEIGHT,
                                           evt.getOldValue(), evt.getNewValue());
                    }
                });
    }

    @Override
    public String getTitle() {
        return _("tutti.label.tab.catchesCaracteristics");
    }

    public CatchBatch getCatchBatch() {
        return catchBatch;
    }

    public void setCatchBatch(CatchBatch catchBatch) {
        Object oldValue = getCatchBatch();
        Object oldObjectId = getObjectId();
        this.catchBatch = catchBatch;
        firePropertyChange(PROPERTY_CATCH_BATCH, oldValue, catchBatch);
        firePropertyChange(PROPERTY_OBJECT_ID, oldObjectId, getObjectId());
    }

    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        Object oldValue = getFishingOperation();
        this.fishingOperation = fishingOperation;
        firePropertyChange(PROPERTY_FISHING_OPERATION, oldValue, fishingOperation);
    }

    public TuttiComputedOrNotData<Float> getCatchTotalComputedOrNotWeight() {
        return catchTotalComputedOrNotWeight;
    }

    public Float getCatchTotalWeight() {
        return catchTotalComputedOrNotWeight.getData();
    }

    public void setCatchTotalWeight(Float catchTotalWeight) {
        Object oldValue = getCatchTotalWeight();
        this.catchTotalComputedOrNotWeight.setData(catchTotalWeight);
        firePropertyChange(PROPERTY_CATCH_TOTAL_WEIGHT, oldValue, catchTotalWeight);
    }

    public Float getCatchTotalComputedWeight() {
        return catchTotalComputedOrNotWeight.getComputedData();
    }

    public void setCatchTotalComputedWeight(Float catchTotalComputedWeight) {
        Object oldValue = getCatchTotalComputedWeight();
        this.catchTotalComputedOrNotWeight.setComputedData(catchTotalComputedWeight);
        firePropertyChange(PROPERTY_CATCH_TOTAL_COMPUTED_WEIGHT, oldValue, catchTotalComputedWeight);
    }

    public Float getCatchTotalSortedComputedWeight() {
        return catchTotalSortedComputedWeight;
    }

    public void setCatchTotalSortedComputedWeight(Float catchTotalSortedComputedWeight) {
        Object oldValue = getCatchTotalSortedComputedWeight();
        this.catchTotalSortedComputedWeight = catchTotalSortedComputedWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_SORTED_COMPUTED_WEIGHT, oldValue, catchTotalSortedComputedWeight);
    }

    public Float getCatchTotalUnsortedComputedWeight() {
        return catchTotalUnsortedComputedWeight;
    }

    public void setCatchTotalUnsortedComputedWeight(Float catchTotalUnsortedComputedWeight) {
        Object oldValue = getCatchTotalUnsortedComputedWeight();
        this.catchTotalUnsortedComputedWeight = catchTotalUnsortedComputedWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_UNSORTED_COMPUTED_WEIGHT, oldValue, catchTotalUnsortedComputedWeight);
    }

    public Float getCatchTotalSortedTremisWeight() {
        return catchTotalSortedTremisWeight;
    }

    public void setCatchTotalSortedTremisWeight(Float catchTotalSortedTremisWeight) {
        Object oldValue = getCatchTotalSortedTremisWeight();
        this.catchTotalSortedTremisWeight = catchTotalSortedTremisWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_SORTED_TREMIS_WEIGHT, oldValue, catchTotalSortedTremisWeight);
    }

    public Float getCatchTotalSortedCarousselWeight() {
        return catchTotalSortedCarousselWeight;
    }

    public void setCatchTotalSortedCarousselWeight(Float catchTotalSortedCarousselWeight) {
        Object oldValue = getCatchTotalSortedCarousselWeight();
        this.catchTotalSortedCarousselWeight = catchTotalSortedCarousselWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT, oldValue, catchTotalSortedCarousselWeight);
    }

    public TuttiComputedOrNotData<Float> getCatchTotalRejectedComputedOrNotWeight() {
        return catchTotalRejectedComputedOrNotWeight;
    }

    public Float getCatchTotalRejectedWeight() {
        return catchTotalRejectedComputedOrNotWeight.getData();
    }

    public void setCatchTotalRejectedWeight(Float catchTotalRejectedWeight) {
        Object oldValue = getCatchTotalRejectedWeight();
        this.catchTotalRejectedComputedOrNotWeight.setData(catchTotalRejectedWeight);
        firePropertyChange(PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT, oldValue, catchTotalRejectedWeight);
    }

    public Float getCatchTotalRejectedComputedWeight() {
        return catchTotalRejectedComputedOrNotWeight.getComputedData();
    }

    public void setCatchTotalRejectedComputedWeight(Float catchTotalRejectedComputedWeight) {
        Object oldValue = getCatchTotalRejectedComputedWeight();
        this.catchTotalRejectedComputedOrNotWeight.setComputedData(catchTotalRejectedComputedWeight);
        firePropertyChange(PROPERTY_CATCH_TOTAL_REJECTED_COMPUTED_WEIGHT, oldValue, catchTotalRejectedComputedWeight);
    }

    public Float getSpeciesTotalComputedWeight() {
        return speciesTotalComputedWeight;
    }

    public void setSpeciesTotalComputedWeight(Float speciesTotalComputedWeight) {
        Object oldValue = getSpeciesTotalComputedWeight();
        this.speciesTotalComputedWeight = speciesTotalComputedWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_COMPUTED_WEIGHT, oldValue, speciesTotalComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getSpeciesTotalSortedComputedOrNotWeight() {
        return speciesTotalSortedComputedOrNotWeight;
    }

    public Float getSpeciesTotalSortedWeight() {
        return speciesTotalSortedComputedOrNotWeight.getData();
    }

    public void setSpeciesTotalSortedWeight(Float speciesTotalSortedWeight) {
        Object oldValue = getSpeciesTotalSortedWeight();
        this.speciesTotalSortedComputedOrNotWeight.setData(speciesTotalSortedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT, oldValue, speciesTotalSortedWeight);
    }

    public Float getSpeciesTotalSortedComputedWeight() {
        return speciesTotalSortedComputedOrNotWeight.getComputedData();
    }

    public void setSpeciesTotalSortedComputedWeight(Float speciesTotalSortedComputedWeight) {
        Object oldValue = getSpeciesTotalSortedComputedWeight();
        this.speciesTotalSortedComputedOrNotWeight.setComputedData(speciesTotalSortedComputedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_SORTED_COMPUTED_WEIGHT, oldValue, speciesTotalSortedComputedWeight);
    }

    public Float getSpeciesTotalSampleSortedComputedWeight() {
        return speciesTotalSampleSortedComputedWeight;
    }

    public void setSpeciesTotalSampleSortedComputedWeight(Float speciesTotalSampleSortedComputedWeight) {
        Object oldValue = getSpeciesTotalSampleSortedComputedWeight();
        this.speciesTotalSampleSortedComputedWeight = speciesTotalSampleSortedComputedWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_COMPUTED_WEIGHT, oldValue, speciesTotalSampleSortedComputedWeight);
    }

    public Float getSpeciesTotalUnsortedComputedWeight() {
        return speciesTotalUnsortedComputedWeight;
    }

    public void setSpeciesTotalUnsortedComputedWeight(Float speciesTotalUnsortedComputedWeight) {
        Object oldValue = getSpeciesTotalUnsortedComputedWeight();
        this.speciesTotalUnsortedComputedWeight = speciesTotalUnsortedComputedWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_UNSORTED_COMPUTED_WEIGHT, oldValue, speciesTotalUnsortedComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getSpeciesTotalInertComputedOrNotWeight() {
        return speciesTotalInertComputedOrNotWeight;
    }

    public Float getSpeciesTotalInertWeight() {
        return speciesTotalInertComputedOrNotWeight.getData();
    }

    public void setSpeciesTotalInertWeight(Float speciesTotalInertWeight) {
        Object oldValue = getSpeciesTotalInertWeight();
        this.speciesTotalInertComputedOrNotWeight.setData(speciesTotalInertWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_INERT_WEIGHT, oldValue, speciesTotalInertWeight);
    }

    public Float getSpeciesTotalInertComputedWeight() {
        return speciesTotalInertComputedOrNotWeight.getComputedData();
    }

    public void setSpeciesTotalInertComputedWeight(Float speciesTotalInertComputedWeight) {
        Object oldValue = getSpeciesTotalInertComputedWeight();
        this.speciesTotalInertComputedOrNotWeight.setComputedData(speciesTotalInertComputedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_INERT_COMPUTED_WEIGHT, oldValue, speciesTotalInertComputedWeight);
    }

    public TuttiComputedOrNotData<Float> getSpeciesTotalLivingNotItemizedComputedOrNotWeight() {
        return speciesTotalLivingNotItemizedComputedOrNotWeight;
    }

    public Float getSpeciesTotalLivingNotItemizedWeight() {
        return speciesTotalLivingNotItemizedComputedOrNotWeight.getData();
    }

    public void setSpeciesTotalLivingNotItemizedWeight(Float speciesTotalLivingNotItemizedWeight) {
        Object oldValue = getSpeciesTotalLivingNotItemizedComputedWeight();
        this.speciesTotalLivingNotItemizedComputedOrNotWeight.setData(speciesTotalLivingNotItemizedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT, oldValue, speciesTotalLivingNotItemizedWeight);
    }

    public Float getSpeciesTotalLivingNotItemizedComputedWeight() {
        return speciesTotalLivingNotItemizedComputedOrNotWeight.getComputedData();
    }

    public void setSpeciesTotalLivingNotItemizedComputedWeight(Float speciesTotalLivingNotItemizedComputedWeight) {
        Object oldValue = getSpeciesTotalLivingNotItemizedComputedWeight();
        this.speciesTotalLivingNotItemizedComputedOrNotWeight.setComputedData(speciesTotalLivingNotItemizedComputedWeight);
        firePropertyChange(PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_COMPUTED_WEIGHT, oldValue, speciesTotalLivingNotItemizedComputedWeight);
    }

    public Float getBenthosTotalWeight() {
        return benthosTotalWeight;
    }

    public void setBenthosTotalWeight(Float benthosTotalWeight) {
        Object oldValue = getBenthosTotalWeight();
        this.benthosTotalWeight = benthosTotalWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_WEIGHT, oldValue, benthosTotalWeight);
    }

    public Float getBenthosTotalSampleSortedWeight() {
        return benthosTotalSampleSortedWeight;
    }

    public void setBenthosTotalSampleSortedWeight(Float benthosTotalSampleSortedWeight) {
        Object oldValue = getBenthosTotalSampleSortedWeight();
        this.benthosTotalSampleSortedWeight = benthosTotalSampleSortedWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT, oldValue, benthosTotalSampleSortedWeight);
    }

    public Float getBenthosTotalSortedWeight() {
        return benthosTotalSortedWeight;
    }

    public void setBenthosTotalSortedWeight(Float benthosTotalSortedWeight) {
        Object oldValue = getBenthosTotalSortedWeight();
        this.benthosTotalSortedWeight = benthosTotalSortedWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT, oldValue, benthosTotalSortedWeight);
    }

    public Float getBenthosTotalUnsortedWeight() {
        return benthosTotalUnsortedWeight;
    }

    public void setBenthosTotalUnsortedWeight(Float benthosTotalUnsortedWeight) {
        Object oldValue = getBenthosTotalUnsortedWeight();
        this.benthosTotalUnsortedWeight = benthosTotalUnsortedWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT, oldValue, benthosTotalUnsortedWeight);
    }

    public Float getPlanktonTotalWeight() {
        return planktonTotalWeight;
    }

    public void setPlanktonTotalWeight(Float planktonTotalWeight) {
        Object oldValue = getPlanktonTotalWeight();
        this.planktonTotalWeight = planktonTotalWeight;
        firePropertyChange(PROPERTY_PLANKTON_TOTAL_WEIGHT, oldValue, planktonTotalWeight);
    }

    public Float getPlanktonTotalSampleWeight() {
        return planktonTotalSampleWeight;
    }

    public void setPlanktonTotalSampleWeight(Float planktonTotalSampleWeight) {
        Object oldValue = getPlanktonTotalSampleWeight();
        this.planktonTotalSampleWeight = planktonTotalSampleWeight;
        firePropertyChange(PROPERTY_PLANKTON_TOTAL_SAMPLE_WEIGHT, oldValue, planktonTotalSampleWeight);
    }

    public Float getMacroWasteTotalWeight() {
        return macroWasteTotalWeight;
    }

    public void setMacroWasteTotalWeight(Float macroWasteTotalWeight) {
        Object oldValue = getMacroWasteTotalWeight();
        this.macroWasteTotalWeight = macroWasteTotalWeight;
        firePropertyChange(PROPERTY_MACRO_WASTE_TOTAL_WEIGHT, oldValue, macroWasteTotalWeight);
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.CATCH_BATCH;
    }

    @Override
    public String getObjectId() {
        return catchBatch == null ? null : catchBatch.getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    public void reset() {
        setSpeciesTotalInertComputedWeight(null);
        setSpeciesTotalLivingNotItemizedComputedWeight(null);
        setSpeciesTotalSampleSortedComputedWeight(null);
        setSpeciesTotalSortedComputedWeight(null);
        setSpeciesTotalUnsortedComputedWeight(null);
        setSpeciesTotalComputedWeight(null);
        setCatchTotalRejectedComputedWeight(null);
        setCatchTotalSortedComputedWeight(null);
        setCatchTotalUnsortedComputedWeight(null);
        setCatchTotalComputedWeight(null);
        removeAllAttachment(getAttachment());
    }

    @Override
    protected CatchBatch newEntity() {
        return catchBatch;
    }

}
