/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.ezware.oxbow.swingbits.util.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SpeciesFrequencyUIHandler
extends AbstractTuttiTableUIHandler<SpeciesFrequencyRowModel, SpeciesFrequencyUIModel, SpeciesFrequencyUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIHandler.class);
    private FrequencyCellComponent.FrequencyCellEditor frequencyEditor;
    private TuttiProtocol protocol;
    private Map<Integer, SpeciesProtocol> speciesProtocol;
    private Map<String, Caracteristic> lengthStepCaracteristics;
    protected Set<SpeciesFrequencyRowModel> withWeightRows = Sets.newHashSet();

    public SpeciesFrequencyUIHandler(TuttiUIContext context, SpeciesFrequencyUI ui) {
        super(context, ui, "lengthStep", "number", "weight");
    }

    public SpeciesFrequencyTableModel getTableModel() {
        return (SpeciesFrequencyTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesFrequencyUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesFrequencyRowModel row) {
        return row.getLengthStepCaracteristic() != null && row.getLengthStep() != null && row.getNumber() != null && row.getNumber() > 0 && (this.withWeightRows.isEmpty() || row.getWeight() != null && row.getWeight().floatValue() > 0.0f);
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
        boolean recomputeAllRows;
        if (row.getWeight() != null) {
            recomputeAllRows = this.withWeightRows.isEmpty();
            this.withWeightRows.add(row);
        } else {
            this.withWeightRows.remove(row);
            recomputeAllRows = this.withWeightRows.isEmpty();
        }
        if (recomputeAllRows) {
            List rows = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getRows();
            for (SpeciesFrequencyRowModel r : rows) {
                this.recomputeRowValidState(r);
            }
        } else {
            this.recomputeRowValidState(row);
        }
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesFrequencyRowModel> rowMonitor, SpeciesFrequencyRowModel row) {
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        ((SpeciesFrequencyUI)this.ui).getValidator().doValidate();
    }

    @Override
    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return ((SpeciesFrequencyUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        SpeciesFrequencyUIModel model = new SpeciesFrequencyUIModel();
        ((SpeciesFrequencyUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        List lengthStepCaracterics = (List)SpeciesBatchUIHandler.FREQUENCY_LENGTH_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui);
        Preconditions.checkNotNull((Object)lengthStepCaracterics);
        this.lengthStepCaracteristics = TuttiEntities.splitById((Iterable)lengthStepCaracterics);
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        if (this.context.isProtocolFilled()) {
            this.protocol = TuttiUIUtil.getProtocol(this.context);
            Preconditions.checkNotNull((Object)this.protocol, (String)"Could not find protocol in ui context");
            this.speciesProtocol = Maps.newHashMap();
            for (SpeciesProtocol sp : this.protocol.getSpecies()) {
                this.speciesProtocol.put(sp.getSpeciesReferenceTaxonId(), sp);
            }
        }
        this.initBeanComboBox(((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox(), lengthStepCaracterics, model.getLengthStepCaracteristic());
        model.setStep(0.5f);
        model.setMinStep(Float.valueOf(10.0f));
        model.setMaxStep(Float.valueOf(20.0f));
        ((SpeciesFrequencyUI)this.ui).getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getRafaleStepField().getModel();
                    SpeciesFrequencyUIHandler.this.applyRafaleStep(step);
                    JTextField field = (JTextField)e.getSource();
                    field.selectAll();
                }
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristic", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Caracteristic newValue = (Caracteristic)evt.getNewValue();
                for (SpeciesFrequencyRowModel rowModel : ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).getRows()) {
                    rowModel.setLengthStepCaracteristic(newValue);
                    SpeciesFrequencyUIHandler.this.recomputeRowValidState(rowModel);
                }
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getValidator().doValidate();
            }
        });
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.LENGTH_STEP, "\\d{0,6}|\\d{1,6}\\.\\d{0,1}");
        this.addIntegerColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.NUMBER, "\\d{0,6}");
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}\\.\\d{0,3}");
        SpeciesFrequencyTableModel tableModel = new SpeciesFrequencyTableModel((TableColumnModel)columnModel, model);
        JXTable table = this.getTable();
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        this.listenValidatorValid((SimpleBeanValidator)((SpeciesFrequencyUI)this.ui).getValidator(), model);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        this.frequencyEditor = null;
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean(null);
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setValid(false);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setSpeciesSelectedCard("main");
    }

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    public void generateLengthSteps() {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = this.getTableModel().getRowCache();
        Float minStep = Float.valueOf(model.getLengthStep(model.getMinStep().floatValue()));
        Float maxStep = Float.valueOf(model.getLengthStep(model.getMaxStep().floatValue()));
        float step = model.getStep();
        for (float i = minStep.floatValue(); i <= maxStep.floatValue(); i += step) {
            if (rowsByStep.containsKey(Float.valueOf(i))) continue;
            SpeciesFrequencyRowModel newRow = tableModel.createNewRow();
            newRow.setLengthStep(Float.valueOf(i));
            rowsByStep.put(Float.valueOf(i), newRow);
        }
        ArrayList rows = Lists.newArrayList(rowsByStep.values());
        model.setRows(rows);
    }

    public void applyRafaleStep(Float step) {
        int rowIndex;
        float aroundLengthStep;
        if (log.isInfoEnabled()) {
            log.info((Object)("Will apply rafale step: " + step));
        }
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = tableModel.getRowCache();
        SpeciesFrequencyRowModel row = rowsByStep.get(Float.valueOf(aroundLengthStep = model.getLengthStep(step.floatValue())));
        if (row != null) {
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            rowIndex = tableModel.updateRow(row);
        } else {
            row = tableModel.createNewRow();
            row.setLengthStep(Float.valueOf(aroundLengthStep));
            row.setNumber(1);
            row.setValid(true);
            ArrayList steps = Lists.newArrayList(rowsByStep.keySet());
            steps.add(Float.valueOf(aroundLengthStep));
            Collections.sort(steps);
            rowIndex = steps.indexOf(Float.valueOf(aroundLengthStep));
            tableModel.addNewRow(rowIndex, row);
        }
        this.getTable().scrollRowToVisible(rowIndex);
    }

    public void editBatch(SpeciesBatchRowModel speciesBatch, FrequencyCellComponent.FrequencyCellEditor editor) {
        Integer taxonId;
        SpeciesProtocol speciesProtocol;
        this.withWeightRows.clear();
        this.frequencyEditor = editor;
        Caracteristic lengthStepCaracteristic = null;
        Float lengthStep = Float.valueOf(1.0f);
        ArrayList editFrequency = Lists.newArrayList();
        if (speciesBatch != null) {
            Species species;
            SpeciesProtocol sProtocol;
            List<SpeciesFrequencyRowModel> frequency = speciesBatch.getFrequency();
            if (!CollectionUtils.isEmpty(frequency)) {
                SpeciesFrequencyTableModel tableModel = this.getTableModel();
                for (SpeciesFrequencyRowModel rowModel : frequency) {
                    SpeciesFrequencyRowModel newRow = tableModel.createNewRow();
                    newRow.setLengthStepCaracteristic(rowModel.getLengthStepCaracteristic());
                    newRow.setLengthStep(rowModel.getLengthStep());
                    newRow.setNumber(rowModel.getNumber());
                    newRow.setWeight(rowModel.getWeight());
                    editFrequency.add(newRow);
                    if (newRow.getWeight() == null) continue;
                    this.withWeightRows.add(newRow);
                }
                SpeciesFrequencyRowModel rowModel = frequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            if (lengthStepCaracteristic == null && this.protocol != null && (sProtocol = this.speciesProtocol.get((species = speciesBatch.getSpecies()).getReferenceTaxonId())) != null) {
                String lengthStepPmfmId = sProtocol.getLengthStepPmfmId();
                lengthStepCaracteristic = this.lengthStepCaracteristics.get(lengthStepPmfmId);
                lengthStep = sProtocol.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing from protocol lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will edit batch row: " + (Object)((Object)speciesBatch) + " with " + editFrequency.size() + " frequency"));
        }
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        SpeciesFrequencyUIModel.ConfigurationMode mode = SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE;
        if (this.protocol != null && (speciesProtocol = this.speciesProtocol.get(taxonId = speciesBatch.getSpecies().getReferenceTaxonId())).getLengthStepPmfmId() == null) {
            mode = SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE_COUNTING;
        }
        if (speciesBatch.getNumber() != null && editFrequency.isEmpty()) {
            mode = SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE_COUNTING;
            model.setSimpleCount(speciesBatch.getNumber());
        }
        model.setConfigurationMode(mode);
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean((Object)model);
        model.setRows(editFrequency);
        model.setLengthStepCaracteristic(lengthStepCaracteristic);
        model.setBatch(speciesBatch);
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save UI " + this.ui));
        }
        this.frequencyEditor.validateEdition((SpeciesFrequencyUIModel)((Object)this.getModel()));
        this.closeUI(this.ui);
    }
}

