package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportProtocolAction.java 384 2013-02-10 15:01:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/ExportProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;
import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Opens a file chooser and exports the protocol into the selected file.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ExportProtocolAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ExportProtocolAction.class);

    protected File file;

    public ExportProtocolAction(SelectCruiseUIHandler handler) {
        super(handler,
              "exportProtocol",
              "export",
              _("tutti.action.exportProtocol"),
              _("tutti.action.exportProtocol.tip"),
              true
        );
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        // choose file to import

        file = TuttiUIUtil.chooseFile(
                getContext().getMainUI(),
                _("tutti.title.choose.protocolExportFile"),
                _("tutti.action.chooseProtocolFile"),
                null,
                "^.+\\.tuttiProtocol$", _("tutti.file.protocol")
        );

        boolean doAction = file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {
        TuttiProtocol protocol = getModel().getProtocol();
        Preconditions.checkNotNull(protocol);

        if (log.isInfoEnabled()) {
            log.info("Export protocol: " + protocol.getId());
        }

        if (log.isInfoEnabled()) {
            log.info("Will save protocol " + protocol.getId() +
                     " to file: " + file);
        }

        if (!file.getName().endsWith(".tuttiProtocol")) {
            file = new File(file.getParentFile(), file.getName() + ".tuttiProtocol");
        }
        // export protocol
        TuttiProtocolImportExportService service =
                getService(TuttiProtocolImportExportService.class);
        service.exportProtocol(protocol, file);

        sendMessage("Protocole [" + protocol.getName() +
                    "] exporté dans le fichier " + file.getName() + ".");

        getHandler().resetEditProtolAction();
    }
}
