package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class FishingOperationsUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<FishingOperationsUIModel, FishingOperationsUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CATCHES_TAB_ENABLED = "catchesTab.enabled";
    public static final String BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM = "fishingOperationComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVz28bRRQeO7GdXyW0UUMCBSUpSK2AsZA4VARIYjdWXLlplbhShQ9l1juOp4xnltlnsiEK4sAfwJ8Ady5I3DghDpw5cEH8Cwhx4Ip4s2t7/WNtp6qw5NXuvHnfe++bN9/77k+S8Q3ZfMqCgJq2AtHi9N7e48cPnKe8Dne5XzfCA21I9EulSbpGFt3eug/kZq1i3fMd93xRtzytuOrz3q6QBR/OJPebnAOQVwc96r6fP+6ZtwOvbbqovaSSUL/5+6/01+6X36YJCTzM7gqWsjHNK65ktkLSwgVyDSN9xvKSqRNMwwh1gvlesWtFyXz/kLX4p+QLkquQrMcMggHZunzJIUboH3hA1hvCb2KEBx43DIRWflV7D5niEshOw1DRMLzFDYU2gKBtQf1T3E3rWgHCU911o6VhnEdlzwvjZIHkmky5khsgpefEPIiAYuhMS7s22bvPCXzfwsSwWcfoT2zCt8fjVu3nAXoVwr2x8xz0OFwbOP6OH3NkeILzPY+14WPAE3R0QQdA3kxA4K7AI6UOZ4oW8NHdbdGu90DXFT8drrSAOSMdZMW2U9CBuxetDnrngDm2CCAvDezF7B3uWstgCS8Pl4AbixHzQArPcjr7WN1w3o/KNsxrvWhX6wzqTe73B9l7liAd/zBYMXofjrGodNUwAREL1wZYqDCHy0ECVhIIQFqSG6CsGjpumIW4GrvyFloMeWXAEzWJxpoUi0aqRjKmjcvYRLVRGTtCUyRga0MCZgFD67+rK7/9+McPpa5qzWPs64lb+0QX1cQzlk0QNvRyJFltEDJ/n3nbNUThEhU7VOQbCYkdd8yYHMa7at2pdacHzG8iRCb3+08/r3786wxJl8iC1MwtMbu/TOahaZAFLd3A29kNM1o6ncPni/ifATJrrwX273moDBfIrnjnjnpoeEPgdVqOOqOT/BkFzLSpT4+4bwfBLJg2D5CtGwls9VJ25n/5Z+X4+90uYymsYH3s9pi1zEckK5QUiodK3xHxRGVf9HzednUs1knyTVDAV+39LwkJ2HQoK10l6PTWu+Hzzv9Ek8XeDeu3bwWbzlK/HE1JIoXq/aSJ+gnk9fOtMKD9oiMjidrlrYvRgJPmlzclegZ1uqV4SytRB5I6RAKwwRChbMWCzDAXR/HSkzCtvdAAZPP8cFRSIyOt24NBGhdBa1kVXpUHyNR7k8qK4tEEmaaAQ7vHzs5kdibATCBu7HCYRhz2zlJ0ublbBt4C8kbUQ/SEw3HHMAx96zZSM9dtJ9Qqf8zGuOrtyVU3BJfuyPqEisfO2GkFY5/muLK3Czvi7cvUurH5wYZqS5mYR5/YT4ucxqnS1EZ8jrwwuSfFiWqFo275PJpAtLh/WN0/urBXMuy3W9G9laFR6VF+urwnZdY/8C5BSlayM43hyAvvuwzYhiOUi7E+HIFO2efCJRDnrCZVz7xQBb9KxllHnP8A5pdtNicMAAA=";
    private static final Log log = LogFactory.getLog(FishingOperationsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected TabInfo catchesTab;
    protected EditCatchesUI catchesTabContent;
    protected BeanComboBox<FishingOperation> fishingOperationComboBox;
    protected TabInfo fishingOperationTab;
    protected EditFishingOperationUI fishingOperationTabContent;
    protected FishingOperationsUI fishingOperationsTopPanel = this;
    protected FishingOperationsUIHandler handler;
    protected FishingOperationsUIModel model;
    protected JButton newFishingOperationButton;
    protected JLabel noTraitPane;
    protected JTabbedPane tabPane;
    protected Table topPanel;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        handler.afterInitUI();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FishingOperationsUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            FishingOperationsUIHandler handler = new FishingOperationsUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public FishingOperationsUI() {
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FishingOperationsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FishingOperationsUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public TabInfo getCatchesTab() {
        return catchesTab;
    }

    public EditCatchesUI getCatchesTabContent() {
        return catchesTabContent;
    }

    public BeanComboBox<FishingOperation> getFishingOperationComboBox() {
        return fishingOperationComboBox;
    }

    public TabInfo getFishingOperationTab() {
        return fishingOperationTab;
    }

    public EditFishingOperationUI getFishingOperationTabContent() {
        return fishingOperationTabContent;
    }

    public FishingOperationsUIHandler getHandler() {
        return handler;
    }

    public FishingOperationsUIModel getModel() {
        return model;
    }

    public JButton getNewFishingOperationButton() {
        return newFishingOperationButton;
    }

    public JLabel getNoTraitPane() {
        return noTraitPane;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Table getTopPanel() {
        return topPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFishingOperationsTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topPanel, BorderLayout.NORTH);
        add(tabPane);
        add(noTraitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(fishingOperationTabContent);
        tabPane.add(catchesTabContent);
        fishingOperationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        tabPane.setTitleAt(0, _("tutti.label.tab.fishingOperation"));
        catchesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.catches"));
    }

    protected void addChildrenToTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        topPanel.add(fishingOperationComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        topPanel.add(newFishingOperationButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.fishingOperations.help"));
    }

    protected void createCatchesTab() {
        $objectMap.put("catchesTab", catchesTab = new TabInfo());
        
        catchesTab.setTitle(_("tutti.label.tab.catches"));
    }

    protected void createCatchesTabContent() {
        $objectMap.put("catchesTabContent", catchesTabContent = new EditCatchesUI(this));
        
        catchesTabContent.setName("catchesTabContent");
    }

    protected void createFishingOperationComboBox() {
        $objectMap.put("fishingOperationComboBox", fishingOperationComboBox = new BeanComboBox<FishingOperation>(this));
        
        fishingOperationComboBox.setName("fishingOperationComboBox");
        fishingOperationComboBox.setI18nPrefix("tutti.property.");
        fishingOperationComboBox.setProperty("selectedFishingOperation");
        fishingOperationComboBox.setShowReset(true);
        fishingOperationComboBox.putClientProperty("help", "tuttihelp.fishingOperations.field.fishingOperation.help");
    }

    protected void createFishingOperationTab() {
        $objectMap.put("fishingOperationTab", fishingOperationTab = new TabInfo());
        
        fishingOperationTab.setTitle(_("tutti.label.tab.fishingOperation"));
    }

    protected void createFishingOperationTabContent() {
        $objectMap.put("fishingOperationTabContent", fishingOperationTabContent = new EditFishingOperationUI(this));
        
        fishingOperationTabContent.setName("fishingOperationTabContent");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(FishingOperationsUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FishingOperationsUIModel.class));
    }

    protected void createNewFishingOperationButton() {
        $objectMap.put("newFishingOperationButton", newFishingOperationButton = new JButton());
        
        newFishingOperationButton.setName("newFishingOperationButton");
        newFishingOperationButton.setMnemonic(78);
        newFishingOperationButton.setToolTipText(_("tuttihelp.fishingOperations.action.newFishingOperation.tip"));
        newFishingOperationButton.putClientProperty("help", "tuttihelp.fishingOperations.action.newFishingOperation.help");
        newFishingOperationButton.putClientProperty("tuttiAction", NewFishingOperationAction.class);
    }

    protected void createNoTraitPane() {
        $objectMap.put("noTraitPane", noTraitPane = new JLabel());
        
        noTraitPane.setName("noTraitPane");
        noTraitPane.setText(_("tutti.label.no.fishingOperation.selected"));
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createTopPanel() {
        $objectMap.put("topPanel", topPanel = new Table());
        
        topPanel.setName("topPanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFishingOperationsTopPanel();
        addChildrenToTopPanel();
        addChildrenToTabPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        fishingOperationComboBox.setBeanType(FishingOperation.class);
        fishingOperationComboBox.setBean(model);
        newFishingOperationButton.setIcon(SwingUtil.createActionIcon("add"));
        noTraitPane.setHorizontalAlignment(JLabel.CENTER);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, fishingOperationsTopPanel, "tuttihelp.fishingOperations.help");
        registerHelpId(_broker, fishingOperationComboBox, "tuttihelp.fishingOperations.field.fishingOperation.help");
        registerHelpId(_broker, newFishingOperationButton, "tuttihelp.fishingOperations.action.newFishingOperation.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("fishingOperationsTopPanel", fishingOperationsTopPanel);
        createHandler();
        createModel();
        createBroker();
        createTopPanel();
        createFishingOperationComboBox();
        createNewFishingOperationButton();
        createTabPane();
        createFishingOperationTabContent();
        createCatchesTabContent();
        createNoTraitPane();
        createFishingOperationTab();
        createCatchesTab();
        // inline creation of fishingOperationsTopPanel
        setName("fishingOperationsTopPanel");
        setLayout(new BorderLayout());
        fishingOperationsTopPanel.putClientProperty("help", "tuttihelp.fishingOperations.help");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationComboBox.setSelectedItem(model.getSelectedFishingOperation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_TAB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedFishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesTab.setEnabled(model.getSelectedFishingOperation() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedFishingOperation", this);
                }
            }
        });
    }

}