/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import jaxx.runtime.SwingUtil;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.i18n.I18n;

public class ButtonAttachmentEditor
extends AttachmentEditor {
    private static final long serialVersionUID = 1L;
    protected final AttachmentModelAware model;

    public static String getButtonText(List<Attachment> attachment) {
        return I18n._((String)"tutti.action.attachments", (Object[])new Object[]{attachment.size()});
    }

    public static ButtonAttachmentEditor newEditor(TuttiUI ui, JButton button) {
        Frame frame = (Frame)SwingUtil.getParentContainer((Object)ui, Frame.class);
        return new ButtonAttachmentEditor(frame, button, (AttachmentModelAware)ui.getModel());
    }

    protected ButtonAttachmentEditor(Frame owner, JButton component, AttachmentModelAware model) {
        super(owner, component, model.getObjectType(), null);
        this.model = model;
    }

    @Override
    protected AttachmentModelAware getBean() {
        return this.model;
    }

    @Override
    protected JButton getComponent() {
        return (JButton)this.component;
    }

    public void init() {
        JButton button = this.getComponent();
        button.setIcon(SwingUtil.createActionIcon((String)"edit-attachment"));
        button.setToolTipText(I18n._((String)"tutti.action.attachments.tip", (Object[])new Object[0]));
        ((AbstractSerializableBean)this.model).addPropertyChangeListener("attachment", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List attachment = (List)evt.getNewValue();
                ButtonAttachmentEditor.this.getComponent().setText(ButtonAttachmentEditor.getButtonText(attachment));
            }
        });
        AttachmentModelAware bean = this.getBean();
        List<Attachment> attachment = bean == null ? Collections.emptyList() : bean.getAttachment();
        button.setText(ButtonAttachmentEditor.getButtonText(attachment));
    }
}

