/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.swing.ComponentResizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AttachmentEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AttachmentEditor.class);
    protected AttachmentEditorUI editor;
    protected JComponent component;

    public AttachmentEditor(Frame owner, JComponent component, AttachementObjectTypeEnum objectType, String title) {
        super(owner, true);
        Preconditions.checkNotNull((Object)component, (String)"AttachmentEditor.component can not be null");
        this.component = component;
        this.editor = new AttachmentEditorUI();
        this.editor.setBorder(BorderFactory.createTitledBorder(title));
        this.editor.setObjectType(objectType);
        this.editor.setObjectIdProperty("objectId");
        this.setUndecorated(true);
        this.add((Component)((Object)this.editor));
        this.setResizable(true);
        this.pack();
        ComponentResizer cr = new ComponentResizer();
        cr.registerComponent(new Component[]{this});
        ComponentMover cm = new ComponentMover();
        cm.setDragInsets(cr.getDragInsets());
        cm.registerComponent(new Component[]{this});
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component)e.getSource();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Destroy ui " + ui));
                }
                JAXXUtil.destroy((Component)ui);
            }
        });
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    e.consume();
                    if (((JComponent)e.getSource()).isEnabled()) {
                        AttachmentEditor.this.startEdit();
                    }
                }
            }
        });
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                if (((JComponent)e.getSource()).isEnabled()) {
                    AttachmentEditor.this.startEdit();
                }
            }
        });
    }

    protected abstract AttachmentModelAware getBean();

    public void startEdit() {
        this.editor.setBean(this.getBean());
        int x = 0;
        int y = this.component.getHeight();
        for (Container comp = this.component; comp != null; comp = comp.getParent()) {
            x += ((Component)comp).getX();
            y += ((Component)comp).getY();
        }
        this.pack();
        if (x + this.getWidth() > this.getOwner().getX() + this.getOwner().getWidth()) {
            x = x - this.getWidth() + this.component.getWidth();
        }
        this.setLocation(x, y);
        this.setVisible(true);
    }

    protected JComponent getComponent() {
        return this.component;
    }
}

