/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.util.TuttiExceptionHandler;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;

public class TuttiUIAction<A extends AbstractTuttiAction>
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TuttiUIAction.class);
    private static final Timer t = new Timer();
    private static final TuttiExceptionHandler exceptionHandler = new TuttiExceptionHandler();
    protected final A action;

    public TuttiUIAction(A action) {
        this.action = action;
        String icon = ((AbstractTuttiAction)action).getActionIcon();
        if (icon != null) {
            ImageIcon actionIcon = SwingUtil.createActionIcon((String)icon);
            this.putValue("SmallIcon", actionIcon);
            this.putValue("SwingLargeIconKey", actionIcon);
        }
        this.putValue("ActionCommandKey", action.getClass().getName());
        this.putValue("Name", ((AbstractTuttiAction)action).getActionName());
        this.putValue("ShortDescription", ((AbstractTuttiAction)action).getActionDescription());
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        boolean doAction;
        if (log.isInfoEnabled()) {
            log.info((Object)("Task [" + this + "] starting"));
        }
        if (doAction = ((AbstractTuttiAction)this.action).prepareAction()) {
            final TuttiActionSwingWorker<A> worker = new TuttiActionSwingWorker<A>(this.action);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    worker.updateBusyState(true);
                }
            });
            if (log.isInfoEnabled()) {
                log.info((Object)("Before execute of action " + this.action));
            }
            worker.execute();
            if (log.isInfoEnabled()) {
                log.info((Object)("After execute of action " + this.action));
            }
        } else {
            ((AbstractTuttiAction)this.action).releaseAction();
        }
    }

    protected static class TuttiActionSwingWorker<A extends AbstractTuttiAction>
    extends SwingWorker<Void, String> {
        protected final TuttiActionUI actionUI;
        protected final A action;
        protected TimerTask timer;

        protected TuttiActionSwingWorker(A action) {
            this.action = action;
            this.actionUI = ((AbstractTuttiAction)action).getContext().getActionUI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() throws Exception {
            if (!this.isCancelled()) {
                this.timer = new TimerTask(){

                    @Override
                    public void run() {
                        if (TuttiActionSwingWorker.this.isCancelled() || TuttiActionSwingWorker.this.isDone()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Task [" + TuttiActionSwingWorker.this.action + "] was already canceled or done, do nothing"));
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Task [" + TuttiActionSwingWorker.this.action + "] is started, show waiting dialog"));
                            }
                            TuttiActionSwingWorker.this.actionUI.open((AbstractTuttiAction)TuttiActionSwingWorker.this.action);
                        }
                    }
                };
                t.schedule(this.timer, 1000L);
                try {
                    ((AbstractTuttiAction)this.action).performAction();
                }
                finally {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Task [" + this + "] done"));
                    }
                    ((AbstractTuttiAction)this.action).releaseAction();
                }
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.actionUI.close();
            this.updateBusyState(false);
            if (((AbstractTuttiAction)this.action).isFailed()) {
                exceptionHandler.handle(new TuttiExceptionHandler.TuttiActionException((AbstractTuttiAction)this.action, ((AbstractTuttiAction)this.action).getError()));
            }
        }

        protected void updateBusyState(boolean busy) {
            boolean hideBody = ((AbstractTuttiAction)this.action).isHideBody();
            MainUI mainUI = ((AbstractTuttiAction)this.action).getContext().getMainUI();
            JXTitledPanel body = mainUI.getBody();
            if (busy) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"block ui in busy mode");
                }
                mainUI.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"unblock ui in none busy mode");
                }
                mainUI.setCursor(Cursor.getDefaultCursor());
            }
            if (hideBody) {
                body.setVisible(!busy);
            }
        }
    }
}

