/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.program;

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.event.ActionEvent;
import java.util.List;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProgramUIHandler
extends AbstractTuttiUIHandler<EditProgramUIModel, EditProgramUI> {
    private static final Log log = LogFactory.getLog(EditProgramUIHandler.class);
    private final PersistenceService persistenceService;

    public EditProgramUIHandler(TuttiUI parentUi, EditProgramUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getPersistenceService();
    }

    @Override
    public void beforeInitUI() {
        EditProgramUIModel model = new EditProgramUIModel();
        List programs = this.persistenceService.getAllProgram();
        model.setExistingPrograms(programs);
        String programId = this.context.getProgramId();
        if (programId == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Edit new program");
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Edit existing program " + programId));
            }
            Program program = this.persistenceService.getProgram(programId);
            model.fromBean(program);
            model.getExistingPrograms().remove(program);
        }
        this.listModelIsModify(model);
        ((EditProgramUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        EditProgramUIModel model = (EditProgramUIModel)((Object)this.getModel());
        this.initBeanComboBox(((EditProgramUI)this.ui).getZoneComboBox(), this.persistenceService.getAllProgramZone(), model.getZone());
        SwingValidator<EditProgramUIModel> validator = ((EditProgramUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    @Override
    public boolean canCloseUI(TuttiScreen nextScreen) {
        boolean result = true;
        if (((EditProgramUIModel)((Object)this.getModel())).isModify()) {
            int answer = this.askSaveBeforeLeaving(I18n._((String)"tutti.dialog.askSaveBeforeLeaving.saveProgram", (Object[])new Object[0]));
            boolean bl = result = answer == 1;
            if (answer == 0) {
                ActionEvent event = new ActionEvent((Object)nextScreen, nextScreen.ordinal(), null);
                this.doAction(((EditProgramUI)this.ui).getSaveButton(), event);
            }
        }
        return result;
    }

    @Override
    public SwingValidator<EditProgramUIModel> getValidator() {
        return ((EditProgramUI)this.ui).getValidator();
    }
}

