/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.CaracteristicTabUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTableModel;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueRenderer;
import java.util.List;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class HydrologyTabUIHandler
extends CaracteristicTabUIHandler<HydrologyRowModel, HydrologyTabUIModel, HydrologyTableModel, HydrologyTabUI> {
    private static final Log log = LogFactory.getLog(HydrologyTabUIHandler.class);

    public HydrologyTabUIHandler(EditFishingOperationUI parentUi, HydrologyTabUI ui) {
        super(parentUi, ui, "value");
    }

    @Override
    protected BeanComboBox<Caracteristic> getKeyCombo() {
        return ((HydrologyTabUI)this.ui).getNewRowKey();
    }

    @Override
    protected HydrologyTabUIModel createModel() {
        return new HydrologyTabUIModel();
    }

    @Override
    protected CaracteristicMap getCaracteristics(FishingOperation operation) {
        return operation.getHydrologyCaracteristics();
    }

    @Override
    protected List<String> getProtocolPmfmIds(TuttiProtocol protocol) {
        return protocol.getHydrologyPmfmId();
    }

    @Override
    public JXTable getTable() {
        return ((HydrologyTabUI)this.ui).getHydrologyTable();
    }

    @Override
    public void afterInitUI() {
        super.afterInitUI();
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class, "withUnit"), HydrologyTableModel.KEY);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.context), new CaracteristicValueRenderer(this.context), HydrologyTableModel.VALUE);
        HydrologyTableModel tableModel = new HydrologyTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
    }

    @Override
    public void removeCaracteristic() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        HydrologyRowModel row = (HydrologyRowModel)((Object)((HydrologyTableModel)this.getTableModel()).getEntry(rowIndex));
        CaracteristicMap caracteristicMap = ((HydrologyTabUIModel)((Object)this.getModel())).getCaracteristicMap();
        if (caracteristicMap != null) {
            caracteristicMap.remove((Object)row.getKey());
        }
        BeanComboBox<Caracteristic> keyCombo = ((HydrologyTabUI)this.ui).getNewRowKey();
        keyCombo.addItem((Object)row.getKey());
        this.selectFirstInCombo(keyCombo);
        ((HydrologyTabUIModel)((Object)this.getModel())).getRows().remove(rowIndex);
        ((HydrologyTableModel)this.getTableModel()).fireTableRowsDeleted(rowIndex, rowIndex);
        ((HydrologyTabUIModel)((Object)this.getModel())).removeRowInError(row);
    }
}

