/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.vessel;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.VesselType;
import fr.ifremer.adagio.core.dao.referential.regulation.RightToProduce;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselDao;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselFeatures;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselImpl;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselMasterPeriod;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselOwnerPeriod;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselRegistrationPeriod;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class VesselDaoBase
extends HibernateDaoSupport
implements VesselDao {
    @Override
    public Object load(int transform, String code) {
        if (code == null) {
            throw new IllegalArgumentException("Vessel.load - 'code' can not be null");
        }
        String entityPk = code;
        Object entity = this.getHibernateTemplate().get(VesselImpl.class, (Serializable)((Object)entityPk));
        return this.transformEntity(transform, (Vessel)entity);
    }

    @Override
    public Vessel load(String code) {
        return (Vessel)this.load(0, code);
    }

    @Override
    public Collection<Vessel> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(VesselImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Vessel create(Vessel vessel) {
        return (Vessel)this.create(0, vessel);
    }

    @Override
    public Object create(int transform, Vessel vessel) {
        if (vessel == null) {
            throw new IllegalArgumentException("Vessel.create - 'vessel' can not be null");
        }
        this.getHibernateTemplate().save((Object)vessel);
        return this.transformEntity(transform, vessel);
    }

    @Override
    public Collection<Vessel> create(Collection<Vessel> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Vessel> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Vessel.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    VesselDaoBase.this.create(transform, (Vessel)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Vessel create(String code, Timestamp updateDate, Collection<RightToProduce> rightToProduces, VesselType vesselType, Collection<VesselFeatures> vesselFeatures, Collection<VesselRegistrationPeriod> vesselRegistrationPeriods, Collection<VesselOwnerPeriod> vesselOwnerPeriods, Collection<VesselMasterPeriod> vesselMasterPeriods, Status status) {
        return (Vessel)this.create(0, code, updateDate, rightToProduces, vesselType, vesselFeatures, vesselRegistrationPeriods, vesselOwnerPeriods, vesselMasterPeriods, status);
    }

    @Override
    public Object create(int transform, String code, Timestamp updateDate, Collection<RightToProduce> rightToProduces, VesselType vesselType, Collection<VesselFeatures> vesselFeatures, Collection<VesselRegistrationPeriod> vesselRegistrationPeriods, Collection<VesselOwnerPeriod> vesselOwnerPeriods, Collection<VesselMasterPeriod> vesselMasterPeriods, Status status) {
        VesselImpl entity = new VesselImpl();
        entity.setCode(code);
        entity.setUpdateDate(updateDate);
        entity.setRightToProduces(rightToProduces);
        entity.setVesselType(vesselType);
        entity.setVesselFeatures(vesselFeatures);
        entity.setVesselRegistrationPeriods(vesselRegistrationPeriods);
        entity.setVesselOwnerPeriods(vesselOwnerPeriods);
        entity.setVesselMasterPeriods(vesselMasterPeriods);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public Vessel create(String code, Status status, VesselType vesselType) {
        return (Vessel)this.create(0, code, status, vesselType);
    }

    @Override
    public Object create(int transform, String code, Status status, VesselType vesselType) {
        VesselImpl entity = new VesselImpl();
        entity.setCode(code);
        entity.setStatus(status);
        entity.setVesselType(vesselType);
        return this.create(transform, entity);
    }

    @Override
    public void update(Vessel vessel) {
        if (vessel == null) {
            throw new IllegalArgumentException("Vessel.update - 'vessel' can not be null");
        }
        this.getHibernateTemplate().update((Object)vessel);
    }

    @Override
    public void update(final Collection<Vessel> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Vessel.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    VesselDaoBase.this.update((Vessel)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Vessel vessel) {
        if (vessel == null) {
            throw new IllegalArgumentException("Vessel.remove - 'vessel' can not be null");
        }
        this.getHibernateTemplate().delete((Object)vessel);
    }

    @Override
    public void remove(String code) {
        if (code == null) {
            throw new IllegalArgumentException("Vessel.remove - 'code' can not be null");
        }
        String entityPk = code;
        Vessel entity = this.load(code);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Vessel> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Vessel.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Vessel entity) {
        Vessel target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Vessel toEntity(Object[] row) {
        Vessel target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Vessel)) continue;
                target = (Vessel)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), VesselImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), VesselImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Vessel> search(Search search) {
        return this.search(0, search);
    }
}

