/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.taxon.Author;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceDocumentImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformationHistory;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public abstract class ReferenceDocument
implements Serializable {
    private static final long serialVersionUID = -1529010323374173007L;
    private Integer id;
    private String reference;
    private Date publicationDate;
    private String comments;
    private Date creationDate;
    private Timestamp updateDate;
    private Status status;
    private Collection<Author> authors = new HashSet<Author>();
    private Collection<TaxonInformationHistory> taxonInformationHistories = new HashSet<TaxonInformationHistory>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(Date publicationDate) {
        this.publicationDate = publicationDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Collection<Author> getAuthors() {
        return this.authors;
    }

    public void setAuthors(Collection<Author> authors) {
        this.authors = authors;
    }

    public Collection<TaxonInformationHistory> getTaxonInformationHistories() {
        return this.taxonInformationHistories;
    }

    public void setTaxonInformationHistories(Collection<TaxonInformationHistory> taxonInformationHistories) {
        this.taxonInformationHistories = taxonInformationHistories;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReferenceDocument)) {
            return false;
        }
        ReferenceDocument that = (ReferenceDocument)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static ReferenceDocument newInstance() {
            ReferenceDocumentImpl entity = new ReferenceDocumentImpl();
            return entity;
        }

        public static ReferenceDocument newInstance(String reference, Date creationDate, Status status, Collection<Author> authors) {
            ReferenceDocument entity = Factory.newInstance();
            entity.setReference(reference);
            entity.setCreationDate(creationDate);
            entity.setStatus(status);
            entity.setAuthors(authors);
            return entity;
        }

        public static ReferenceDocument newInstance(String reference, Date publicationDate, String comments, Date creationDate, Timestamp updateDate, Status status, Collection<Author> authors, Collection<TaxonInformationHistory> taxonInformationHistories) {
            ReferenceDocument entity = Factory.newInstance();
            entity.setReference(reference);
            entity.setPublicationDate(publicationDate);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setStatus(status);
            entity.setAuthors(authors);
            entity.setTaxonInformationHistories(taxonInformationHistories);
            return entity;
        }
    }
}

