/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.protocol;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.protocol.SpeciesRow;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import org.nuiton.util.csv.Common;
import org.nuiton.util.csv.ValueFormatter;
import org.nuiton.util.csv.ValueParser;

public class SpeciesRowModel
extends TuttiCsvUtil.AbstractTuttiImportExportModel<SpeciesRow> {
    public SpeciesRowModel(char separator, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        super(separator);
        this.newMandatoryColumn("speciesReferenceTaxonId", "species", (ValueParser)new TuttiCsvUtil.ForeignKeyValue<Species>(Species.class, "referenceTaxonId", speciesMap){
            Set<Integer> taxonIds;
            {
                this.taxonIds = Sets.newHashSet();
            }

            @Override
            public Species parse(String value) throws ParseException {
                Species species = (Species)super.parse(value);
                Integer referenceTaxonId = species.getReferenceTaxonId();
                if (this.taxonIds.contains(referenceTaxonId)) {
                    throw new RuntimeException("Reference taxon Id [" + referenceTaxonId + "] already  used before.");
                }
                this.taxonIds.add(referenceTaxonId);
                return species;
            }
        });
        this.newForeignKeyColumn("lengthStepPmfmId", "lengthStepPmfm", Caracteristic.class, "id", caracteristicMap);
        this.newIgnoredColumn("speciesRefTaxCode");
        this.newIgnoredColumn("speciesName");
        this.newIgnoredColumn("lengthStepPmfmParameterName");
        this.newIgnoredColumn("lengthStepPmfmMatrixName");
        this.newIgnoredColumn("lengthStepPmfmFractionName");
        this.newIgnoredColumn("lengthStepPmfmMethodName");
        this.newMandatoryColumn("speciesSurveyCode", (ValueParser)new TuttiCsvUtil.StringParserFormatter(null, true));
        this.newMandatoryColumn("sizeEnabled", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newMandatoryColumn("sexEnabled", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newMandatoryColumn("maturityEnabled", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newMandatoryColumn("ageEnabled", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newMandatoryColumn("weightEnabled", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newMandatoryColumn("countIfNoFrequencyEnabled", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newMandatoryColumn("calcifySampleEnabled", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newColumnForExport("speciesReferenceTaxonId", (ValueFormatter)Common.INTEGER);
        this.newColumnForExport("speciesRefTaxCode");
        this.newColumnForExport("speciesName");
        this.newColumnForExport("speciesSurveyCode");
        this.newColumnForExport("lengthStepPmfmId");
        this.newColumnForExport("lengthStepPmfmParameterName");
        this.newColumnForExport("lengthStepPmfmMatrixName");
        this.newColumnForExport("lengthStepPmfmFractionName");
        this.newColumnForExport("lengthStepPmfmMethodName");
        this.newColumnForExport("sizeEnabled", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
        this.newColumnForExport("sexEnabled", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
        this.newColumnForExport("maturityEnabled", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
        this.newColumnForExport("ageEnabled", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
        this.newColumnForExport("weightEnabled", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
        this.newColumnForExport("countIfNoFrequencyEnabled", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
        this.newColumnForExport("calcifySampleEnabled", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
    }

    public SpeciesRow newEmptyInstance() {
        return new SpeciesRow();
    }
}

