/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramDao;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramImpl;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonDao;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.ObservedFishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruiseDao;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeaturesExtendDao;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagDao;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.gear.GearDao;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationDao;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmDao;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueDao;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselDao;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.CruisePersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="cruisePersistenceService")
public class CruisePersistenceServiceImpl
extends AbstractPersistenceService
implements CruisePersistenceService {
    private static final Log log = LogFactory.getLog(CruisePersistenceServiceImpl.class);
    protected static String CRUISE_MISC_DATA_VESSELS_TAG = "#VESSELS=";
    protected static String CRUISE_MISC_DATA_MANAGERS_TAG = "#MANAGERS=";
    protected static String CRUISE_MISC_DATA_SORT_MANAGERS_TAG = "#SORT_MANAGERS=";
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Autowired
    protected ProgramPersistenceService programService;
    @Resource(name="scientificCruiseDao")
    protected ScientificCruiseDao scientificCruiseDao;
    @Resource(name="programDao")
    protected ProgramDao programDao;
    @Resource(name="personDao")
    protected PersonDao personDao;
    @Resource(name="vesselDao")
    protected VesselDao vesselDao;
    @Resource(name="locationDao")
    protected LocationDao locationDao;
    @Resource(name="qualityFlagDao")
    protected QualityFlagDao qualityFlagDao;
    @Resource(name="pmfmDao")
    protected PmfmDao pmfmDao;
    @Resource(name="qualitativeValueDao")
    protected QualitativeValueDao qualitativeValueDao;
    @Resource(name="gearDao")
    protected GearDao gearDao;
    @Resource(name="gearPhysicalFeaturesDao")
    protected GearPhysicalFeaturesExtendDao gearPhysicalFeaturesDao;

    @Override
    public List<Cruise> getAllCruise(String programId) {
        Iterator<Object[]> list = this.queryList("allCruises", "programCode", StringType.INSTANCE, programId);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            Cruise target = new Cruise();
            target.setId(String.valueOf(source[0]));
            target.setName((String)source[1]);
            target.setBeginDate((Date)source[2]);
            result.add(target);
        }
        return result;
    }

    @Override
    public Cruise getCruise(String id) {
        Object[] source = this.queryUnique("cruise", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(id), "countryLocationLevelId", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_COUNTRY, "pmfmIdSurveyPart", IntegerType.INSTANCE, this.enumeration.PMFM_ID_SURVEY_PART);
        if (source == null) {
            throw new DataRetrievalFailureException("Could not retrieve cruise with id=" + id);
        }
        Cruise result = new Cruise();
        result.setId(id);
        String programCode = (String)source[0];
        Program program = this.programService.getProgram(programCode);
        result.setProgram(program);
        result.setYear((Integer)source[1]);
        result.setName((String)source[2]);
        String countryId = String.valueOf(source[3]);
        String countryLabel = (String)source[4];
        String countryName = (String)source[5];
        Country c = new Country();
        c.setId(countryId);
        c.setName(countryName);
        c.setLabel(countryLabel);
        result.setCountry(c);
        Timestamp beginDate = (Timestamp)source[6];
        if (beginDate != null && result.getYear() != null) {
            long mili = this.dateOfYearWithOneMiliSecondInMili(result.getYear());
            if (beginDate.getTime() == mili) {
                result.setBeginDate(null);
            } else {
                result.setBeginDate(new Date(beginDate.getTime()));
            }
        }
        result.setEndDate((Date)source[7]);
        String vesselCode = (String)source[8];
        Vessel vessel = this.referentialService.getVessel(vesselCode);
        result.setVessel(Lists.newArrayList((Object[])new Vessel[]{vessel}));
        Integer managerId = (Integer)source[9];
        if (managerId != null && managerId.equals(this.enumeration.PERSON_ID_UNKNOWN_RECORDER_PERSON)) {
            result.setHeadOfMission(null);
        } else {
            fr.ifremer.tutti.persistence.entities.referential.Person manager = this.referentialService.getPerson(managerId);
            result.setHeadOfMission(Lists.newArrayList((Object[])new fr.ifremer.tutti.persistence.entities.referential.Person[]{manager}));
        }
        result.setComment((String)source[10]);
        String miscData = (String)source[11];
        if (miscData != null && miscData.length() > 0) {
            int sortManagersIndex;
            int managersIndex;
            int vesselTagIndex = miscData.indexOf(CRUISE_MISC_DATA_VESSELS_TAG);
            if (vesselTagIndex != -1) {
                String vesselCodesStr = miscData.substring(vesselTagIndex + CRUISE_MISC_DATA_VESSELS_TAG.length()).trim();
                miscData = miscData.substring(0, vesselTagIndex);
                if (!vesselCodesStr.isEmpty()) {
                    String[] vesselCodes;
                    String[] arr$ = vesselCodes = vesselCodesStr.split(",");
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String vesselCode1;
                        vesselCode = vesselCode1 = arr$[i$];
                        result.addVessel(this.referentialService.getVessel(vesselCode));
                    }
                }
            }
            if ((managersIndex = miscData.indexOf(CRUISE_MISC_DATA_MANAGERS_TAG)) != -1) {
                String managersStr = miscData.substring(managersIndex + CRUISE_MISC_DATA_MANAGERS_TAG.length()).trim();
                miscData = miscData.substring(0, managersIndex);
                if (!managersStr.isEmpty()) {
                    String[] managersArray;
                    for (String personId : managersArray = managersStr.split(",")) {
                        fr.ifremer.tutti.persistence.entities.referential.Person person = this.referentialService.getPerson(Integer.valueOf(personId));
                        result.getHeadOfMission().add(person);
                    }
                }
            }
            if ((sortManagersIndex = miscData.indexOf(CRUISE_MISC_DATA_SORT_MANAGERS_TAG)) != -1) {
                String sortManagersStr = miscData.substring(sortManagersIndex + CRUISE_MISC_DATA_SORT_MANAGERS_TAG.length()).trim();
                miscData = miscData.substring(0, sortManagersIndex);
                if (!sortManagersStr.isEmpty()) {
                    String[] managersArray = sortManagersStr.split(",");
                    ArrayList<fr.ifremer.tutti.persistence.entities.referential.Person> persons = new ArrayList<fr.ifremer.tutti.persistence.entities.referential.Person>();
                    for (String personId : managersArray) {
                        fr.ifremer.tutti.persistence.entities.referential.Person person = this.referentialService.getPerson(Integer.valueOf(personId));
                        persons.add(person);
                    }
                    result.setHeadOfSortRoom(persons);
                }
            }
        }
        result.setSurveyPart((String)source[12]);
        if (result.getGear() == null) {
            Iterator<Object[]> list = this.queryList("allCruiseGears", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(id), "pmfmIdTrawlNet", IntegerType.INSTANCE, this.enumeration.PMFM_ID_MULTIRIG_NUMBER);
            ArrayList gears = Lists.newArrayList();
            int maxMultirigNumberFound = 0;
            while (list.hasNext()) {
                Object[] gearRow = list.next();
                Gear target = this.referentialService.getGear((Integer)gearRow[0]);
                Float multirigNumber = (Float)gearRow[1];
                if (multirigNumber != null && multirigNumber.intValue() > maxMultirigNumberFound) {
                    maxMultirigNumberFound = multirigNumber.intValue();
                }
                gears.add(target);
            }
            result.setGear(gears);
            if (maxMultirigNumberFound > 0) {
                result.setMultirigNumber(maxMultirigNumberFound);
            }
        }
        if (result.getMultirigNumber() == null) {
            log.warn((Object)MessageFormat.format("Cruise with id={0} has been load with a default multirigNumber=1, beacause not multirigNumber were found in database.", id));
            result.setMultirigNumber(1);
        }
        return result;
    }

    @Override
    public Cruise createCruise(Cruise bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0, (Object)"Cruise 'id' must be null to call createCruise().");
        ScientificCruise scientificCruise = ScientificCruise.Factory.newInstance();
        this.cruiseToEntity(bean, scientificCruise);
        this.scientificCruiseDao.create(scientificCruise);
        bean.setId(String.valueOf(scientificCruise.getId()));
        return bean;
    }

    @Override
    public Cruise saveCruise(Cruise bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId(), (Object)"Cruise 'id' must not be null or empty to be saved.");
        ScientificCruise scientificCruise = this.scientificCruiseDao.load(Integer.valueOf(bean.getId()));
        if (scientificCruise == null) {
            throw new DataRetrievalFailureException("Could not retrieve cruise with id=" + bean.getId());
        }
        this.cruiseToEntity(bean, scientificCruise);
        this.scientificCruiseDao.update(scientificCruise);
        return bean;
    }

    protected void cruiseToEntity(Cruise source, ScientificCruise target) {
        fr.ifremer.tutti.persistence.entities.referential.Person managerPerson;
        int i;
        List<fr.ifremer.tutti.persistence.entities.referential.Person> persons;
        ObservedFishingTrip fishingTrip;
        StringBuilder miscDataBuffer = new StringBuilder();
        QualityFlag qualityFlagNotQualified = (QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED));
        if (target.getFishingTrips() == null || target.getFishingTrips().size() == 0) {
            fishingTrip = ObservedFishingTrip.Factory.newInstance();
            if (target.getFishingTrips() == null) {
                target.setFishingTrips((Collection)Lists.newArrayList((Object[])new FishingTrip[]{fishingTrip}));
                fishingTrip.setScientificCruise(target);
            } else {
                target.getFishingTrips().add(fishingTrip);
                fishingTrip.setScientificCruise(target);
            }
        } else {
            fishingTrip = (ObservedFishingTrip)target.getFishingTrips().iterator().next();
        }
        target.setName(source.getName());
        if (source.getProgram() == null || source.getProgram().getId() == null) {
            target.setProgram(null);
        } else if (source.getName() != null && source.getProgram().getId() != null) {
            target.setProgram((fr.ifremer.adagio.core.dao.administration.programStrategy.Program)this.load(ProgramImpl.class, (Serializable)((Object)source.getProgram().getId())));
        }
        if (source.getHeadOfSortRoom() == null || source.getHeadOfSortRoom().size() == 0) {
            target.setManagerPerson(null);
        } else if (source.getHeadOfSortRoom() != null && source.getHeadOfSortRoom().size() > 0) {
            persons = source.getHeadOfSortRoom();
            miscDataBuffer.append(CRUISE_MISC_DATA_SORT_MANAGERS_TAG);
            for (i = 0; i < persons.size(); ++i) {
                if (i > 0) {
                    miscDataBuffer.append(',');
                }
                miscDataBuffer.append(persons.get(i).getId());
            }
        }
        if (source.getHeadOfMission() == null || source.getHeadOfMission().size() == 0) {
            target.setManagerPerson(null);
        } else if (source.getHeadOfMission() != null && source.getHeadOfMission().size() > 0) {
            persons = source.getHeadOfMission();
            target.setManagerPerson((Person)this.load(PersonImpl.class, Integer.valueOf(persons.get(0).getId())));
            if (persons.size() > 1) {
                miscDataBuffer.append(CRUISE_MISC_DATA_MANAGERS_TAG);
                for (i = 1; i < persons.size(); ++i) {
                    if (i > 1) {
                        miscDataBuffer.append(',');
                    }
                    miscDataBuffer.append(persons.get(i).getId());
                }
            }
        }
        if (source.getVessel() == null || source.getVessel().size() == 0) {
            target.setProgram(null);
        } else if (source.getVessel() != null && source.getVessel().size() > 0) {
            List<Vessel> vessels = source.getVessel();
            target.setVessel(this.vesselDao.load(vessels.get(0).getId()));
            if (vessels.size() > 1) {
                miscDataBuffer.append(CRUISE_MISC_DATA_VESSELS_TAG);
                for (i = 1; i < vessels.size(); ++i) {
                    if (i > 1) {
                        miscDataBuffer.append(',');
                    }
                    miscDataBuffer.append(vessels.get(i).getId());
                }
            }
        }
        if (source.getYear() == null && source.getBeginDate() == null) {
            target.setDepartureDateTime(null);
        } else if (source.getYear() != null && source.getBeginDate() == null) {
            target.setDepartureDateTime(this.dateOfYearWithOneMiliSecond(source.getYear()));
        }
        if (source.getYear() == null && source.getBeginDate() == null) {
            target.setDepartureDateTime(null);
        } else if (source.getBeginDate() != null) {
            target.setDepartureDateTime(this.dateWithNoSecondAndMiliSecond(source.getBeginDate()));
        }
        if (source.getEndDate() == null) {
            target.setReturnDateTime(null);
        } else if (source.getEndDate() != null) {
            target.setReturnDateTime(this.dateWithNoSecondAndMiliSecond(source.getEndDate()));
        }
        if (source.getComment() == null) {
            target.setComments(null);
        } else if (source.getComment() != null) {
            target.setComments(source.getComment());
        }
        if (source.getHeadOfMission() == null || source.getHeadOfMission().size() == 0) {
            target.setComments(null);
        } else if (source.getHeadOfMission() != null && source.getHeadOfMission().size() > 0 && source.getHeadOfMission().size() > 0 && (managerPerson = source.getHeadOfMission().get(0)).getId() != null) {
            target.setManagerPerson((Person)this.load(PersonImpl.class, Integer.valueOf(managerPerson.getId())));
        }
        if (target.getManagerPerson() == null) {
            target.setManagerPerson((Person)this.load(PersonImpl.class, this.enumeration.PERSON_ID_UNKNOWN_RECORDER_PERSON));
        }
        target.setSynchronizationStatus(SynchronizationStatus.DIRTY.getValue());
        if (target.getCreationDate() == null) {
            target.setCreationDate(this.newCreateDate());
        }
        if (target.getManagerPerson() != null) {
            target.setRecorderPerson(target.getManagerPerson());
            target.setRecorderDepartment(target.getManagerPerson().getDepartment());
        }
        fishingTrip.setDepartureDateTime(target.getDepartureDateTime());
        fishingTrip.setReturnDateTime(target.getReturnDateTime());
        fishingTrip.setVessel(target.getVessel());
        fishingTrip.setProgram(target.getProgram());
        fishingTrip.setRecorderPerson(target.getRecorderPerson());
        fishingTrip.setRecorderDepartment(target.getRecorderDepartment());
        fishingTrip.setCreationDate(target.getCreationDate());
        fishingTrip.setSynchronizationStatus(target.getSynchronizationStatus());
        fishingTrip.setQualityFlag(qualityFlagNotQualified);
        if (fishingTrip.getReturnDateTime() == null && fishingTrip.getDepartureDateTime() != null) {
            fishingTrip.setReturnDateTime(this.dateWithOneMiliSecond(fishingTrip.getDepartureDateTime()));
        }
        if (source.getCountry() == null || source.getCountry().getId() == null) {
            fishingTrip.setDepartureLocation(null);
            fishingTrip.setReturnLocation(null);
        } else if (source.getCountry() != null && source.getCountry().getId() != null) {
            Location locationCountry = this.locationDao.load(Integer.valueOf(source.getCountry().getId()));
            fishingTrip.setDepartureLocation(locationCountry);
            fishingTrip.setReturnLocation(locationCountry);
        }
        this.setSurveyMeasurement((FishingTrip)fishingTrip, this.enumeration.PMFM_ID_SURVEY_PART, null, source.getSurveyPart(), null);
        if (source.isGearEmpty() && fishingTrip.getGearPhysicalFeatures() != null) {
            fishingTrip.getGearPhysicalFeatures().clear();
        } else if (!source.isGearEmpty()) {
            HashSet notChangedGearPhysicalFeatures = new HashSet();
            if (fishingTrip.getGearPhysicalFeatures() != null) {
                notChangedGearPhysicalFeatures.addAll(fishingTrip.getGearPhysicalFeatures());
            }
            for (Gear gear : source.getGear()) {
                GearPhysicalFeatures guf = this.gearPhysicalFeaturesDao.getGearPhysicalfeatures((FishingTrip)fishingTrip, Integer.valueOf(gear.getId()), true);
                notChangedGearPhysicalFeatures.remove(guf);
                guf.setStartDate(fishingTrip.getDepartureDateTime());
                guf.setEndDate(fishingTrip.getReturnDateTime());
                guf.setVessel(fishingTrip.getVessel());
                guf.setProgram(fishingTrip.getProgram());
                guf.setCreationDate(target.getCreationDate());
                guf.setQualityFlag(qualityFlagNotQualified);
                guf.setRankOrder(Short.valueOf((short)1));
                if (source.getMultirigNumber() == null) {
                    this.gearPhysicalFeaturesDao.removeGearPhysicalMeasurement(guf, this.enumeration.PMFM_ID_MULTIRIG_NUMBER);
                    continue;
                }
                this.gearPhysicalFeaturesDao.setGearPhysicalMeasurement(target, guf, this.enumeration.PMFM_ID_MULTIRIG_NUMBER, Float.valueOf(source.getMultirigNumber().intValue()), null, null);
            }
            if (fishingTrip.getGearPhysicalFeatures() != null && notChangedGearPhysicalFeatures.size() > 0) {
                for (GearPhysicalFeatures guf : notChangedGearPhysicalFeatures) {
                    if (guf.getGearPhysicalMeasurements() != null) {
                        guf.getGearPhysicalMeasurements().clear();
                    }
                    fishingTrip.getGearPhysicalFeatures().remove(guf);
                }
            }
        }
        fishingTrip.setComments(miscDataBuffer.toString());
    }

    protected SurveyMeasurement getOrCreateSurveyMeasurement(FishingTrip fishingTrip, Integer pmfmId) {
        SurveyMeasurement result = null;
        for (SurveyMeasurement vum : fishingTrip.getSurveyMeasurements()) {
            if (!pmfmId.equals(vum.getPmfm().getId())) continue;
            result = vum;
            break;
        }
        if (result == null) {
            result = SurveyMeasurement.Factory.newInstance();
            result.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
            result.setDepartment(fishingTrip.getRecorderDepartment());
            Pmfm pmfm = (Pmfm)this.load(PmfmImpl.class, pmfmId);
            result.setPmfm(pmfm);
            result.setFishingTrip(fishingTrip);
            if (fishingTrip.getSurveyMeasurements() == null) {
                fishingTrip.setSurveyMeasurements((Collection)Sets.newHashSet());
            }
            fishingTrip.getSurveyMeasurements().add(result);
        }
        return result;
    }

    protected SurveyMeasurement setSurveyMeasurement(FishingTrip fishingTrip, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        SurveyMeasurement result = this.getOrCreateSurveyMeasurement(fishingTrip, pmfmId);
        if (alphanumericalValue != null) {
            result.setAlphanumericalValue(alphanumericalValue);
        } else if (numericalValue != null) {
            result.setNumericalValue(numericalValue);
        } else if (qualitativevalueId != null) {
            result.setQualitativeValue((QualitativeValue)this.load(QualitativeValueImpl.class, qualitativevalueId));
        }
        return result;
    }
}

