/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.config;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.RessourceClassLoader;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfigOption;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.config.ApplicationConfig;

public class TuttiPersistenceConfig {
    private static final Log log = LogFactory.getLog(TuttiPersistenceConfig.class);
    private static TuttiPersistenceConfig instance;
    protected final ApplicationConfig config;

    public static TuttiPersistenceConfig getInstance() {
        return instance;
    }

    public static void setInstance(TuttiPersistenceConfig instance) {
        TuttiPersistenceConfig.instance = instance;
    }

    public TuttiPersistenceConfig(ApplicationConfig config) {
        this.config = config;
    }

    public void initConfig(RessourceClassLoader resourceLoader) throws IOException {
        FileUtils.forceMkdir((File)this.getDbDirectory());
        FileUtils.forceMkdir((File)this.getDbAttachmentDirectory());
        FileUtils.forceMkdir((File)this.getProtocolDirectory());
        resourceLoader.addSearchInDirectoriesPredicate(new Predicate<String>(){
            Set<String> matchingNames;
            {
                this.matchingNames = Sets.newHashSet((Object[])new String[]{TuttiPersistenceConfig.this.getDbConfigurationPath().getName(), TuttiPersistenceConfig.this.getDbEnumerationPath().getName()});
            }

            public boolean apply(String input) {
                return this.matchingNames.contains(input);
            }
        });
        File configurationPath = this.getDbConfigurationPath();
        resourceLoader.addDirectory(configurationPath.getParentFile());
        this.generateDbConfiguration(configurationPath);
        File enumerationPath = this.getDbEnumerationPath();
        resourceLoader.addDirectory(enumerationPath.getParentFile());
        this.generateDbEnumerationConfiguration(enumerationPath);
    }

    public File getDbConfigurationPath() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_CONFIGURATION_PATH.getKey());
    }

    public File getDbDirectory() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_DIRECTORY.getKey());
    }

    public File getDbAttachmentDirectory() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_ATTACHMENT_DIRECTORY.getKey());
    }

    public File getCacheDirectory() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.CACHE_DIRECTORY.getKey());
    }

    public File getProtocolDirectory() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.PROTOCOL_DIRECTORY.getKey());
    }

    public String getDbName() {
        return this.config.getOption(TuttiPersistenceConfigOption.DB_NAME.getKey());
    }

    public boolean isDbExists() {
        File f = new File(this.getDbDirectory(), this.getDbName() + ".data");
        return f.exists();
    }

    public File getDbEnumerationPath() {
        return this.config.getOptionAsFile(TuttiPersistenceConfigOption.DB_ENUMERATION_PATH.getKey());
    }

    public String getJdbcUrl() {
        return this.config.getOption(TuttiPersistenceConfigOption.JDBC_URL.getKey());
    }

    public Class getJdbcDriver() {
        return this.config.getOptionAsClass(TuttiPersistenceConfigOption.JDBC_DRIVER.getKey());
    }

    public String getJdbcUsername() {
        return this.config.getOption(TuttiPersistenceConfigOption.JDBC_USERNAME.getKey());
    }

    public String getJdbcPassword() {
        return this.config.getOption(TuttiPersistenceConfigOption.JDBC_PASSWORD.getKey());
    }

    public Class getHibernateDialect() {
        return this.config.getOptionAsClass(TuttiPersistenceConfigOption.HIBERNATE_DIALECT.getKey());
    }

    public boolean isHibernateShowSql() {
        Boolean result = this.config.getOptionAsBoolean(TuttiPersistenceConfigOption.HIBERNATE_SHOW_SQL.getKey());
        return result != null && result != false;
    }

    public boolean isHibernateUseSqlComment() {
        Boolean result = this.config.getOptionAsBoolean(TuttiPersistenceConfigOption.HIBERNATE_USE_SQL_COMMENT.getKey());
        return result != null && result != false;
    }

    public boolean isHibernateFormatSql() {
        Boolean result = this.config.getOptionAsBoolean(TuttiPersistenceConfigOption.HIBERNATE_FORMAT_SQL.getKey());
        return result != null && result != false;
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDbConfiguration(File destination) throws IOException {
        if (!destination.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Generate " + destination + " from classpath."));
            }
            Properties result = new Properties();
            InputStream in = this.getClass().getResourceAsStream("/tutti-db-conf.properties");
            try {
                result.load(in);
                in.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            result.put("dataSource.jdbc.driver", this.getJdbcDriver().getName());
            result.put("dataSource.jdbc.username", this.getJdbcUsername());
            result.put("dataSource.jdbc.password", this.getJdbcPassword());
            result.put("dataSource.jdbc.url", this.getJdbcUrl());
            result.put("hibernate.dialect", this.getHibernateDialect().getName());
            result.put("hibernate.show_sql", this.isHibernateShowSql() + "");
            result.put("hibernate.format_sql", this.isHibernateFormatSql() + "");
            result.put("hibernate.use_sql_comments", this.isHibernateUseSqlComment() + "");
            result.put("ehcache.disk.store.dir", this.getCacheDirectory().getAbsolutePath());
            BufferedWriter writer = Files.newWriter((File)destination, (Charset)Charsets.UTF_8);
            try {
                result.store(writer, "Generated by " + this.getClass().getName());
                writer.close();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDbEnumerationConfiguration(File destination) throws IOException {
        if (!destination.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Generate " + destination + " from classpath."));
            }
            Properties result = new Properties();
            InputStream in = this.getClass().getResourceAsStream("/tutti-db-enumerations.properties");
            try {
                result.load(in);
                in.close();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            BufferedWriter writer = Files.newWriter((File)destination, (Charset)Charsets.UTF_8);
            try {
                result.store(writer, "Generated by " + this.getClass().getName());
                writer.close();
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getDbEnumerations() throws IOException {
        Properties result = new Properties();
        BufferedReader in = Files.newReader((File)this.getDbEnumerationPath(), (Charset)Charsets.UTF_8);
        try {
            result.load(in);
            in.close();
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
        return result;
    }
}

