package fr.ifremer.tutti.ui.swing.util.editor;

/*
 * #%L
 * Tutti :: UI
 * $Id: SimpleTimeEditorModel.java 39 2012-12-10 13:33:13Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/editor/SimpleTimeEditorModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.jdesktop.beans.AbstractSerializableBean;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class SimpleTimeEditorModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_DATE = "date";

    public static final String PROPERTY_TIME_MODEL = "timeModel";

    public static final String PROPERTY_PROPERTY = "property";

    public static final String PROPERTY_BEAN = "bean";

    /** Bean where to push data. */
    protected Serializable bean;

    /** Property of the bean to use. */
    protected String property;

    /** Time model in minutes. */
    protected Integer timeModel = 0;

    /** Real date which contains the edited time. */
    protected Date date;

    public Serializable getBean() {
        return bean;
    }

    public void setBean(Serializable bean) {
        Object oldValue = getBean();
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public String getProperty() {
        return property;
    }

    public void setProperty(String property) {
        Object oldValue = getProperty();
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        Object oldValue = getDate();
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public Integer getTimeModel() {
        return timeModel;
    }

    public void setTimeModel(Integer timeModel) {
        if (timeModel == null) {
            timeModel = 0;
        }
        Object oldValue = getTimeModel();
        this.timeModel = timeModel;
        firePropertyChange(PROPERTY_TIME_MODEL, oldValue, timeModel);
    }

    public int getMinute() {
        return timeModel % 60;
    }

    public int getHour() {
        return timeModel / 60;
    }

}
