package fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class HydrologyTabUI extends Table implements TuttiUI<HydrologyTabUIModel, HydrologyTabUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ROW_ENABLED = "addRow.enabled";
    public static final String BINDING_NEW_ROW_KEY_ENABLED = "newRowKey.enabled";
    public static final String BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED = "removeCaracteristicMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTW8bRRgeO7ETp0mhjZqmakFOKagR6rhVL0jho7FxiFMnDXaQInwoY+/YnnQ8s8y+W69lFfET+Alw54LEjRPiwJkDF8RfQIgDV8Q7u7bXTrZKDt3DajXzfjzvx/Ps93+RjGfIxgkLAmp8BaLH6d728fGT5glvwcfcaxnhgjYkelJpkm6QS87k3APyVqNq3Qsj90JJ91ytuJry3qqSJQ8GkntdzgHIG7MeLc8r1CfXW4Hrm3HUCaikqN/+83f6G+fr79KEBC6iy2Ep+fO84krmqyQtHCBXMdNzVpBMdRCGEaqDeFfsWUkyzztgPf4l+YosVEnWZQaDAbl98ZLDGKF/4AJZuHPEmpLfB1JtGyrahve4oeADCOoL6vUxO21pBRiMapcbBkIr2hZe1950B47RUncGdHf8hfE+q7humCKLCbpMOZIbIPVXmWA3ihrnyfS0wyWQT19lln0bM86xBLZXh9r1sXNrdiDBKPReeLjPlR9bX0cQ+jkvMcNawI3wQLSsBZBrM672rAK8Z92uTrxzivdruv+YD4C8O7NDkRt3BE6VNjlTtIgvHHlTF3Vg3XOTKFnmOBgFyOpMyiI2RqtZ05U7e/UW1i4PmbL7cH3GI76a9brcnWqY5EBuatOhJ0jIZ6DdyDuge8fhrfV500VS3JwpCOlGY7rFfEg1SMb4eAxkvXGWoTW8iri5foqbNmB4+9/a6u8//fnjzpiQC5j7WqLplJ4gUVxjdwSETf1axEYfhCzsM3ergbTmEsUoFJtbCcDqo2sEh/muWHdq3eku87oYIrPwx8+/rH3x2xxJ75AlqZmzw6x9heSga7ALWjqB+9GjENFyfxHfr1tsuIDiwXvq0PC2CBBYtN4jrAMaYCduJXRiAqeZ+/Xf1foPj8bdSCG6Gy81jzuS+ZxkhZJC8VCgRtqTKEiXXI/7jo41Jkl1CLJneXpnR5zZDN/3zhQ+hyrClV0gFMe14caEGVR45Z4Lg7ubL4AsjhuB/IoGxJ0Z7iGnsLX9Gves5GfaTHo88G3KB2Ez7NdDMs089xxg6Wlgbw9jXB0O9REEy+y7m/mND/LKlxJxLiEi1J6KVSMyh/xMwjDi7XkA5pG2Ua0Y0YqVhVHFauvTh5LWKwefVMtP6+VquXRUeXJg2+VpAxFlo1agRkxC7WjDO0b7CutaGZaQ34YWq9ulxy+mrYqs9WxslR2G5SXVckoizqsJ1zwjWdNq+Xq04SBActpk0Opuh4m9pDRT4nyBtsVze2cY/jlwl2pn9bocWYULNg88wMXJR6CiKdIEjcfe9hQeK/uZqp2a+HJYxz3MyCFx/V7227hA3xbt3+Bo4OIsL7/vMGD5plAOKvCHZxKl7PsGxvwf5usy+3IJAAA=";
    private static final Log log = LogFactory.getLog(HydrologyTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addRow;
    protected HydrologyTabUIHandler handler;
    protected JXTable hydrologyTable;
    protected HydrologyTabUIModel model;
    protected BeanComboBox<Caracteristic> newRowKey;
    protected JMenuItem removeCaracteristicMenu;
    protected JPopupMenu tablePopup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private HydrologyTabUI $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        handler.afterInitUI(); 
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HydrologyTabUI(EditFishingOperationUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            HydrologyTabUIHandler handler = new HydrologyTabUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public HydrologyTabUI() {
        $initialize();
    }

    public HydrologyTabUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addRow(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addRow();
    }

    public void doActionPerformed__on__removeCaracteristicMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeCaracteristic();
    }

    public void doMouseClicked__on__hydrologyTable(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddRow() {
        return addRow;
    }

    public HydrologyTabUIHandler getHandler() {
        return handler;
    }

    public JXTable getHydrologyTable() {
        return hydrologyTable;
    }

    public HydrologyTabUIModel getModel() {
        return model;
    }

    public BeanComboBox<Caracteristic> getNewRowKey() {
        return newRowKey;
    }

    public JMenuItem getRemoveCaracteristicMenu() {
        return removeCaracteristicMenu;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeCaracteristicMenu);
    }

    protected void createAddRow() {
        $objectMap.put("addRow", addRow = new JButton());
        
        addRow.setName("addRow");
        addRow.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addRow"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(HydrologyTabUIHandler.class));
    }

    protected void createHydrologyTable() {
        $objectMap.put("hydrologyTable", hydrologyTable = new JXTable());
        
        hydrologyTable.setName("hydrologyTable");
        hydrologyTable.setSortable(false);
        hydrologyTable.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__hydrologyTable"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(HydrologyTabUIModel.class));
    }

    protected void createNewRowKey() {
        $objectMap.put("newRowKey", newRowKey = new BeanComboBox<Caracteristic>(this));
        
        newRowKey.setName("newRowKey");
        newRowKey.setI18nPrefix("tutti.property.");
        newRowKey.setProperty("selectedCaracteristic");
        newRowKey.setShowReset(false);
    }

    protected void createRemoveCaracteristicMenu() {
        $objectMap.put("removeCaracteristicMenu", removeCaracteristicMenu = new JMenuItem());
        
        removeCaracteristicMenu.setName("removeCaracteristicMenu");
        removeCaracteristicMenu.setText(_("tutti.action.removeCaracteristic"));
        removeCaracteristicMenu.setMnemonic(82);
        removeCaracteristicMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeCaracteristicMenu"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.title.batchActions");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(newRowKey, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addRow, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTablePopup();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(hydrologyTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        newRowKey.setBeanType(Caracteristic.class);
        removeCaracteristicMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        addRow.setIcon(SwingUtil.createActionIcon("add"));
        hydrologyTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        hydrologyTable.setSelectionForeground(Color.BLACK);
        hydrologyTable.setSelectionBackground(null);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createModel();
        createTablePopup();
        createRemoveCaracteristicMenu();
        createNewRowKey();
        createAddRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createHydrologyTable();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_CARACTERISTIC_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeCaracteristicMenu.setEnabled(model.isRemoveCaracteristicEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeCaracteristicEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_ROW_KEY_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    newRowKey.setEnabled(!newRowKey.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ROW_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (newRowKey != null) {
                    newRowKey.addPropertyChangeListener("selectedItem", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (newRowKey != null) {
                    addRow.setEnabled(newRowKey.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (newRowKey != null) {
                    newRowKey.removePropertyChangeListener("selectedItem", this);
                }
            }
        });
    }

}