package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

/*
 * #%L
 * Tutti :: UI
 * $Id: AccidentalBatchTableModel.java 496 2013-02-28 08:55:41Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/accidental/AccidentalBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class AccidentalBatchTableModel extends AbstractTuttiTableModel<AccidentalBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<AccidentalBatchRowModel> SPECIES_BY_CODE = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.table.accidental.batch.header.speciesByCode"),
            n_("tutti.table.accidental.batch.header.speciesByCode"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> SPECIES_BY_GENUS_CODE = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.table.accidental.batch.header.speciesByGenusCode"),
            n_("tutti.table.accidental.batch.header.speciesByGenusCode"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.table.accidental.batch.header.weight"),
            n_("tutti.table.accidental.batch.header.weight"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> COMMENT = ColumnIdentifier.newId(
            BenthosBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.table.accidental.batch.header.comment"),
            n_("tutti.table.accidental.batch.header.comment"));

    public static final ColumnIdentifier<AccidentalBatchRowModel> ATTACHMENTS = ColumnIdentifier.newId(
            AccidentalBatchRowModel.PROPERTY_ATTACHMENTS,
            n_("tutti.table.accidental.batch.header.file"),
            n_("tutti.table.accidental.batch.header.file"));


    public AccidentalBatchTableModel(TableColumnModelExt columnModel) {
        super(columnModel, true, true);

        setNoneEditableCols();
    }

    @Override
    public AccidentalBatchRowModel createNewRow() {
        AccidentalBatchRowModel result = new AccidentalBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue,
                           int rowIndex,
                           int columnIndex,
                           ColumnIdentifier<AccidentalBatchRowModel> propertyName,
                           AccidentalBatchRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);

        if (propertyName == SPECIES_BY_CODE) {

            // update also other columns
            fireTableCellUpdated(rowIndex, SPECIES_BY_GENUS_CODE);

        } else if (propertyName == SPECIES_BY_GENUS_CODE) {

            // update also other columns
            fireTableCellUpdated(rowIndex, SPECIES_BY_CODE);
        }
    }

    @Override
    protected boolean isCellEditable(int rowIndex,
                                     int columnIndex,
                                     ColumnIdentifier<AccidentalBatchRowModel> propertyName) {

        boolean result = super.isCellEditable(rowIndex,
                                              columnIndex,
                                              propertyName);

        return result;
    }
}