package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportProtocolAction.java 515 2013-03-02 16:03:05Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/ImportProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Opens a file chooser and imports the protocol from the selected file.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportProtocolAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportProtocolAction.class);

    public static final JAXXContextEntryDef<TuttiProtocol> IMPORT_PROTOCOL_ENTRY = new JAXXContextEntryDef<TuttiProtocol>("importProtocol", TuttiProtocol.class);

    private File file;

    public ImportProtocolAction(SelectCruiseUIHandler handler) {
        super(handler,
              "import",
              _("tutti.action.importProtocol"),
              _("tutti.action.importProtocol.tip"),
              true
        );
    }

    @Override
    protected boolean prepareAction() {

        boolean doAction = super.prepareAction();

        if (doAction) {
            // choose file to import
            file = TuttiUIUtil.chooseFile(
                    getContext().getMainUI(),
                    _("tutti.title.choose.protocolImportFile"),
                    _("tutti.action.chooseProtocolFile"),
                    null,
                    "^.+\\.tuttiProtocol$", _("tutti.file.protocol")
            );

            doAction = file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        file = null;
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will import protocol file: " + file);
        }

        // import protocol
        TuttiProtocolImportExportService service =
                getContext().getTuttiProtocolImportExportService();
        TuttiProtocol protocol = service.importProtocol(file);

        sendMessage("Protocole [" + protocol.getName() + "] lu depuis le fichier.");

        IMPORT_PROTOCOL_ENTRY.setContextValue(getContext().getMainUI(), protocol);

        // remove id
        protocol.setId(null);

        getContext().setProtocolId(null);
        getContext().setScreen(TuttiScreen.EDIT_PROTOCOL);
    }
}
