package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id: SaveCruiseAction.java 538 2013-03-05 12:32:36Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/cruise/SaveCruiseAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;

import static org.nuiton.i18n.I18n._;

/**
 * Saves a cruise
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class SaveCruiseAction extends AbstractTuttiAction<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {

    public SaveCruiseAction(EditCruiseUIHandler handler) {
        super(handler,
              "save",
              _("tutti.action.saveCruise"),
              _("tutti.action.saveCruise.tip"),
              true
        );
    }

    /**
     * If the event source is a TuttiScreen, then the screen changes to the source.
     * Otherwise, the screen changes to the home.
     */
    @Override
    protected void doAction() {
        TuttiUIContext context = getContext();
        EditCruiseUIModel model = getModel();
        PersistenceService persistenceService =
                getContext().getPersistenceService();

        Cruise bean = model.toBean();

        Cruise saved;
        if (TuttiEntities.isNew(bean)) {

            saved = persistenceService.createCruise(bean);
            model.setId(saved.getId());
        } else {
            saved = persistenceService.saveCruise(bean);
        }

        context.setProgramId(saved.getProgram().getId());
        context.setCruiseId(saved.getId());

        //TODO-TC Make this works again but in another manner
//        TuttiScreen nextScreen;
//        if (event.getSource().getClass().isAssignableFrom(TuttiScreen.class)) {
//            nextScreen = (TuttiScreen) event.getSource();
//        } else {
//            nextScreen = TuttiScreen.SELECT_CRUISE;
//        }
//        context.setScreen(nextScreen);
    }

}
