/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.awt.event.ActionEvent;
import java.util.Collection;
import org.nuiton.i18n.I18n;

public class AddSpeciesProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final long serialVersionUID = 1L;

    public AddSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler, "addSpeciesProtocol", "add", null, I18n._((String)"tutti.action.addSpeciesProtocol.tip", (Object[])new Object[0]), false);
    }

    @Override
    protected void doAction(ActionEvent event) {
        EditProtocolUI ui = (EditProtocolUI)this.getUI();
        EditProtocolUIHandler handler = (EditProtocolUIHandler)this.getHandler();
        EditProtocolSpeciesTableModel tableModel = handler.getTableModel();
        Species species = (Species)ui.getSpeciesComboBox().getSelectedItem();
        Preconditions.checkNotNull((Object)species, (Object)"Can't add a speciesProtocol with a null species");
        Preconditions.checkArgument((boolean)species.isReferenceTaxon(), (Object)"Can't add a speciesProtocol with a not referent species");
        Integer taxonId = species.getReferenceTaxonId();
        String taxonIdStr = String.valueOf(taxonId);
        Collection<Species> allSynonyms = ((EditProtocolUIModel)((Object)this.getModel())).getAllSynonyms(taxonIdStr);
        ((EditProtocolUIModel)((Object)this.getModel())).getAllSynonyms().removeAll(allSynonyms);
        ui.getSpeciesComboBox().getData().remove(species);
        ui.getSpeciesComboBox().getHandler().sortData();
        handler.selectFirstInCombo(ui.getSpeciesComboBox());
        EditProtocolSpeciesRowModel protocol = tableModel.createNewRow();
        protocol.setSpecies(species);
        tableModel.addNewRow(protocol);
        ((EditProtocolUIModel)((Object)this.getModel())).setModify(true);
        String speciesStr = this.getDecorator(Species.class, "byCruiseCode").toString((Object)species);
        this.sendMessage(I18n._((String)"tutti.flash.information.species.add.to.protocol", (Object[])new Object[]{speciesStr}));
    }
}

