/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.oxbow.swingbits.popup;

import com.ezware.oxbow.swingbits.popup.ResizablePopupMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;

public abstract class PopupWindow {
    private final JPopupMenu menu;
    private Dimension defaultSize = new Dimension(100, 100);

    public PopupWindow(boolean resizable) {
        this.menu = new ResizablePopupMenu(resizable){
            private static final long serialVersionUID = 1L;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (PopupWindow.this.menu.getComponentCount() == 0) {
                    JComponent content = PopupWindow.this.buildContent();
                    PopupWindow.this.defaultSize = content.getPreferredSize();
                    PopupWindow.this.menu.add(content);
                }
                PopupWindow.this.beforeShow();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                PopupWindow.this.beforeHide();
            }
        };
    }

    public final Dimension getDefaultSize() {
        return this.defaultSize;
    }

    public final Dimension getPreferredSize() {
        return this.menu.getPreferredSize();
    }

    public final void setPreferredSize(Dimension preferredSize) {
        this.menu.setPreferredSize(preferredSize);
    }

    protected abstract JComponent buildContent();

    public void show(Component invoker, int x, int y) {
        this.menu.show(invoker, x, y);
    }

    public void show(Component invoker, Point location) {
        this.show(invoker, location.x, location.y);
    }

    public final void hide() {
        this.menu.setVisible(false);
    }

    protected void beforeShow() {
    }

    protected void beforeHide() {
    }

    public class CommandAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CommandAction(String name, Icon icon) {
            super(name, icon);
            if (icon != null) {
                this.putValue("ShortDescription", name);
                this.putValue("Name", null);
            }
        }

        public CommandAction(String name) {
            super(name);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            if (this.perform()) {
                PopupWindow.this.hide();
            }
        }

        protected boolean perform() {
            return true;
        }
    }
}

