/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatchDao;
import fr.ifremer.adagio.core.dao.data.batch.denormalized.DenormalizedBatchDao;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationException;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.BatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.type.IntegerType;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="batchPersistenceService")
public class BatchPersistenceServiceImpl
extends AbstractPersistenceService
implements BatchPersistenceService {
    private static final Log log = LogFactory.getLog(BatchPersistenceServiceImpl.class);
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="denormalizedBatchDao")
    protected DenormalizedBatchDao denormalizedBatchDao;
    @Resource(name="sortingBatchDao")
    protected SortingBatchDao sortingBatchDao;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    @Resource(name="scientificCruiseCatchBatchValidator")
    protected CatchBatchValidator catchBatchValidator;

    @Override
    public void init() {
        super.init();
        this.catchBatchDao.registerCatchBatchValidator(this.catchBatchValidator);
    }

    @Override
    public void close() {
        this.catchBatchDao.unregisterCatchBatchValidator(this.catchBatchValidator);
        super.close();
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.data.CatchBatch getCatchBatchFromFishingOperation(String fishingOperationId) throws CatchBatchValidationException {
        return this.getCatchBatchFromFishingOperation(fishingOperationId, false);
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.data.CatchBatch getCatchBatchFromFishingOperation(String fishingOperationId, boolean tryToRepair) throws CatchBatchValidationException {
        SortingBatch unsortedBatch;
        SortingBatch horsVracBatch;
        SortingBatch livingNotItemizedBatch;
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(Integer.valueOf(fishingOperationId));
        CatchBatch source = this.catchBatchDao.loadFullTree(catchBatchId, true, tryToRepair);
        fr.ifremer.tutti.persistence.entities.data.CatchBatch result = new fr.ifremer.tutti.persistence.entities.data.CatchBatch();
        result.setId(source.getId().toString());
        result.setCatchTotalWeight(source.getWeight());
        SortingBatch vracBatch = this.catchBatchDao.getSortingBatch(source.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID});
        result.setCatchTotalSortedCarousselWeight(vracBatch.getWeight());
        result.setCatchTotalSortedTremisWeight(vracBatch.getWeightBeforeSampling());
        SortingBatch speciesBatch = this.catchBatchDao.getSortingBatch(vracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
        result.setSpeciesTotalSampleSortedWeight(speciesBatch.getWeight());
        result.setSpeciesTotalSortedWeight(speciesBatch.getWeightBeforeSampling());
        SortingBatch inertBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_INERT});
        if (inertBatch != null) {
            result.setSpeciesTotalInertWeight(inertBatch.getWeight());
        }
        if ((livingNotItemizedBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_LIFE})) != null) {
            result.setSpeciesTotalLivingNotItemizedWeight(livingNotItemizedBatch.getWeight());
        }
        if ((horsVracBatch = this.catchBatchDao.getSortingBatch(source.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID})) != null) {
            result.setCatchTotalUnsortedWeight(horsVracBatch.getWeight());
            SortingBatch speciesBatch2 = this.catchBatchDao.getSortingBatch(horsVracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
            result.setSpeciesTotalUnsortedWeight(speciesBatch2.getWeight());
        }
        if ((unsortedBatch = this.catchBatchDao.getSortingBatch(source.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID})) != null) {
            result.setCatchTotalRejectedWeight(unsortedBatch.getWeight());
        }
        return result;
    }

    @Override
    public void cleanEntity(CatchBatch catchBatch, boolean keepTotalWeight) {
        for (Batch batch : catchBatch.getChildBatchs()) {
            this.catchBatchDao.removeWithChildren(batch.getId());
        }
        catchBatch.getChildBatchs().clear();
        fr.ifremer.tutti.persistence.entities.data.CatchBatch bean = new fr.ifremer.tutti.persistence.entities.data.CatchBatch();
        bean.setId(catchBatch.getId().toString());
        FishingOperation fishingOperation = new FishingOperation();
        fishingOperation.setId(catchBatch.getFishingOperation().getId().toString());
        bean.setFishingOperation(fishingOperation);
        if (keepTotalWeight) {
            bean.setCatchTotalWeight(catchBatch.getWeight());
        }
        this.beanToEntity(bean, catchBatch, true);
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.data.CatchBatch createCatchBatch(fr.ifremer.tutti.persistence.entities.data.CatchBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        CatchBatch catchBatch = CatchBatch.Factory.newInstance();
        this.beanToEntity(bean, catchBatch, true);
        catchBatch = this.catchBatchDao.create(catchBatch);
        bean.setId(String.valueOf(catchBatch.getId()));
        this.getCurrentSession().flush();
        Integer fishingOperationId = Integer.valueOf(bean.getFishingOperation().getId());
        int rowUpdated = this.queryUpdate("updateFishingOperationCatchBatch", "fishingOperationId", IntegerType.INSTANCE, fishingOperationId, "catchBatchId", IntegerType.INSTANCE, catchBatch.getId());
        if (rowUpdated == 0) {
            throw new DataIntegrityViolationException("Could not attach catch batch to the given operation : operation was not found.");
        }
        return bean;
    }

    @Override
    @CacheEvict(value={"batchTree"}, key="#bean.fishingOperation.id")
    public fr.ifremer.tutti.persistence.entities.data.CatchBatch saveCatchBatch(fr.ifremer.tutti.persistence.entities.data.CatchBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        this.getCurrentSession().enableFetchProfile("batch-with-childs");
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        CatchBatch catchBatch = this.catchBatchDao.load(Integer.valueOf(bean.getId()));
        if (catchBatch == null) {
            throw new DataRetrievalFailureException("Could not retrieve catch batch with id=" + bean.getId());
        }
        this.beanToEntity(bean, catchBatch, true);
        this.catchBatchDao.update(catchBatch);
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public List<SpeciesBatch> getAllRootSpeciesBatch(String fishingOperationId) {
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(Integer.valueOf(fishingOperationId));
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        ArrayList<SpeciesBatch> result = new ArrayList<SpeciesBatch>();
        SortingBatch vracSpeciesBatch = this.catchBatchDao.getSortingBatch(catchBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
        for (SortingBatch source : vracSpeciesBatch.getChildBatchs()) {
            if (source.getReferenceTaxon() == null || this.enumeration.REFERENCE_TAXON_ID_LIFE.equals(source.getReferenceTaxon().getId()) || this.enumeration.REFERENCE_TAXON_ID_INERT.equals(source.getReferenceTaxon().getId())) continue;
            SpeciesBatch target = new SpeciesBatch();
            this.entityToBean(source, target);
            result.add(target);
        }
        SortingBatch horsVracSpeciesBatch = this.catchBatchDao.getSortingBatch(catchBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
        if (horsVracSpeciesBatch != null) {
            for (SortingBatch source : horsVracSpeciesBatch.getChildBatchs()) {
                SpeciesBatch target = new SpeciesBatch();
                this.entityToBean(source, target);
                result.add(target);
            }
        }
        return result;
    }

    protected SpeciesBatch entityToBean(SortingBatch source, SpeciesBatch target) {
        Integer referenceTaxonId;
        SampleCategoryEnum sampleCategory;
        target.setId(source.getId().toString());
        target.setNumber(source.getIndividualCount());
        if (source.getWeight() != null && source.getWeightBeforeSampling() == null) {
            target.setSampleCategoryWeight(source.getWeight());
        } else {
            target.setWeight(source.getWeight());
            target.setSampleCategoryWeight(source.getWeightBeforeSampling());
        }
        target.setComment(source.getComments());
        SortingMeasurement sm = null;
        if (source.getSortingMeasurements().size() == 1) {
            sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        } else if (source.getReferenceTaxon() != null && source.getReferenceTaxon().getId() != null) {
            sm = this.catchBatchDao.getInheritedSortingMeasurement(source, this.enumeration.PMFM_ID_SORTED_UNSORTED);
        }
        if (sm != null && (sampleCategory = this.referentialService.getSampleCategoryByPmfmId(sm.getPmfm().getId())) != null) {
            this.setSampleCategoryQualitative(target, sm.getPmfm().getId(), sm.getNumericalValue(), sm.getAlphanumericalValue(), sm.getQualitativeValue().getId());
        }
        if ((referenceTaxonId = source.getInheritedReferenceTaxonId()) == null && source.getReferenceTaxon() != null) {
            referenceTaxonId = source.getReferenceTaxon().getId();
        }
        if (referenceTaxonId != null) {
            Species species = this.referentialService.getSpeciesByReferenceTaxonId(referenceTaxonId);
            target.setSpecies(species);
        }
        if (target.getSampleCategoryType() != null && source.getChildBatchs().size() > 0) {
            ArrayList targetChilds = Lists.newArrayList();
            for (SortingBatch sourceChild : source.getChildBatchs()) {
                SpeciesBatch targetChild = new SpeciesBatch();
                this.entityToBean(sourceChild, targetChild);
                if (targetChild.getSampleCategoryValue() == null) continue;
                targetChilds.add(targetChild);
                targetChild.setParentBatch(target);
            }
            target.setChildBatchs(targetChilds);
        }
        return target;
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSpecies().getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(Integer.valueOf(bean.getFishingOperation().getId()));
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.beanToEntity(bean, batch, parentBatchId, catchBatch, true);
        batch = this.sortingBatchDao.create(batch);
        bean.setId(String.valueOf(batch.getId()));
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(Integer.valueOf(bean.getId()));
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        SortingBatch batch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(bean.getId()));
        String parentBatchId = null;
        if (bean.getParentBatch() != null) {
            parentBatchId = bean.getParentBatch().getId();
        }
        this.beanToEntity(bean, batch, parentBatchId, catchBatch, true);
        this.sortingBatchDao.update(batch);
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public void deleteSpeciesBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        this.catchBatchDao.removeWithChildren(Integer.valueOf(id));
        this.getCurrentSession().flush();
    }

    @Override
    public void deleteSpeciesSubBatch(String id) {
        this.deleteSpeciesBatch(id);
    }

    @Override
    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        int rowUpdated;
        Preconditions.checkNotNull((Object)batchId);
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getReferenceTaxonId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changing species for batch id=" + batchId));
        }
        Preconditions.checkArgument(((rowUpdated = this.queryUpdate("updateBatchSpecies", "batchId", IntegerType.INSTANCE, Integer.valueOf(batchId), "referenceTaxonId", IntegerType.INSTANCE, species.getReferenceTaxonId())) == 1 ? 1 : 0) != 0, (Object)"Unable to update operation, to be linked with catch batch.");
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        ArrayList results = Lists.newArrayList();
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(Integer.valueOf(speciesBatchId));
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        if (catchBatchId == null) {
            return results;
        }
        SortingBatch sortingBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(speciesBatchId));
        for (SortingBatch source : sortingBatch.getChildBatchs()) {
            SpeciesBatchFrequency target = new SpeciesBatchFrequency();
            this.entityToBean(source, target);
            results.add(target);
        }
        return results;
    }

    protected void entityToBean(SortingBatch source, SpeciesBatchFrequency target) {
        target.setId(source.getId().toString());
        target.setNumber(source.getIndividualCount());
        target.setWeight(source.getWeight());
        target.setComment(source.getComments());
        if (source.getSortingMeasurements().size() == 1) {
            SortingMeasurement sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
            if (sm.getPmfm() != null && sm.getPmfm().getId() != null) {
                Caracteristic lengthStepCaracteristic = this.referentialService.getCaracteristic(sm.getPmfm().getId());
                target.setLengthStepCaracteristic(lengthStepCaracteristic);
            }
            target.setLengthStep(sm.getNumericalValue());
        }
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        Preconditions.checkNotNull((Object)speciesBatchId);
        Preconditions.checkNotNull(frequencies);
        if (frequencies.size() == 0) {
            return frequencies;
        }
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(Integer.valueOf(speciesBatchId));
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        if (catchBatch == null) {
            return frequencies;
        }
        SortingBatch parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(speciesBatchId));
        ArrayList notUpdatedChildIds = Lists.newArrayList();
        for (SortingBatch sortingBatch : parentBatch.getChildBatchs()) {
            notUpdatedChildIds.add(sortingBatch.getId());
        }
        short rankOrder = 0;
        String pmfmId = null;
        ArrayList batchsToUpdate = Lists.newArrayList();
        for (SpeciesBatchFrequency source : frequencies) {
            rankOrder = (short)(rankOrder + 1);
            if (pmfmId == null) {
                source.getLengthStepCaracteristic().getId();
            } else if (!pmfmId.equals(source.getLengthStepCaracteristic().getId())) {
                throw new DataIntegrityViolationException("Batch frequencies under one Speciesbatch must have all the same lengthStepCaracteristic");
            }
            SortingBatch target = null;
            if (source.getId() == null) {
                target = SortingBatch.Factory.newInstance();
                this.beanToEntity(source, target, parentBatch, rankOrder, true);
                this.sortingBatchDao.create(target);
                source.setId(target.getId().toString());
                continue;
            }
            target = this.sortingBatchDao.load(Integer.valueOf(source.getId()));
            this.beanToEntity(source, target, parentBatch, rankOrder, true);
            batchsToUpdate.add(target);
            notUpdatedChildIds.remove(target.getId());
        }
        if (batchsToUpdate.size() > 0) {
            this.sortingBatchDao.update((Collection)batchsToUpdate);
        }
        if (notUpdatedChildIds.size() > 0) {
            for (Integer batchId : notUpdatedChildIds) {
                this.catchBatchDao.removeWithChildren(batchId);
            }
        }
        this.getCurrentSession().flush();
        return frequencies;
    }

    protected void beanToEntity(SpeciesBatch source, SortingBatch target, String parentBatchId, CatchBatch catchBatch, boolean copyIfNull) {
        Integer pmfmId;
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        Integer recorderDepartmentId = this.getRecorderDepartmentId();
        HashSet notChangedQuantificationMeasurements = new HashSet();
        if (target.getQuantificationMeasurements() != null) {
            notChangedQuantificationMeasurements.addAll(target.getQuantificationMeasurements());
        }
        HashSet notChangedSortingMeasurements = new HashSet();
        if (target.getSortingMeasurements() != null) {
            notChangedSortingMeasurements.addAll(target.getSortingMeasurements());
        }
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().toString().equals(parentBatchId)) {
            this.setBatchParents(source, target, parentBatchId, catchBatch);
        }
        if (target.getRankOrder() == null) {
            short rankOrder = 3;
            if (source.getParentBatch() != null && source.getParentBatch().getChildBatchs() != null) {
                rankOrder = (short)(rankOrder + (short)source.getParentBatch().getChildBatchs().size());
            } else if (target.getParentBatch() != null && target.getParentBatch().getChildBatchs() != null) {
                rankOrder = (short)(rankOrder + (short)target.getParentBatch().getChildBatchs().size());
            }
            target.setRankOrder(Short.valueOf(rankOrder));
        }
        target.setSubgroupCount(Float.valueOf(1.0f));
        if (!copyIfNull || source.getWeight() != null || source.getSampleCategoryWeight() != null) {
            if (source.getSampleCategoryWeight() != null && source.getWeight() == null) {
                QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getSampleCategoryWeight(), true);
                notChangedQuantificationMeasurements.remove(quantificationMeasurement);
            } else if (source.getWeight() != null && source.getSampleCategoryWeight() == null) {
                QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getWeight(), true);
                notChangedQuantificationMeasurements.remove(quantificationMeasurement);
            }
        }
        if (copyIfNull && (source.getSampleCategoryWeight() == null || source.getWeight() == null)) {
            target.setSamplingRatio(null);
            target.setSamplingRatioText(null);
        } else if (source.getSampleCategoryWeight() != null && source.getWeight() != null) {
            String samplingRatioText = source.getWeight() + "/" + source.getSampleCategoryWeight();
            samplingRatioText = samplingRatioText.replaceAll(",", ".");
            target.setSamplingRatioText(samplingRatioText);
            target.setSamplingRatio(Float.valueOf(source.getWeight().floatValue() / source.getSampleCategoryWeight().floatValue()));
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getWeight(), true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if ((!copyIfNull || source.getSampleCategoryType() != null && source.getSampleCategoryValue() != null) && source.getSampleCategoryType() != null && source.getSampleCategoryValue() != null && !(pmfmId = this.sampleCategory2PmfmId(source.getSampleCategoryType())).equals(this.enumeration.PMFM_ID_SORTED_UNSORTED)) {
            SortingMeasurement sortingMeasurement = this.setSortingMeasurement(target, recorderDepartmentId, source.getSampleCategoryType(), source.getSampleCategoryValue());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        if (copyIfNull && source.getNumber() == null) {
            target.setIndividualCount(null);
        } else if (source.getNumber() != null) {
            target.setIndividualCount(source.getNumber());
        }
        if (copyIfNull && (source.getSpecies() == null || parentBatchId != null)) {
            target.setReferenceTaxon(null);
        } else if (source.getSpecies() != null && parentBatchId == null) {
            ReferenceTaxon referenceTaxon = (ReferenceTaxon)this.load(ReferenceTaxonImpl.class, source.getSpecies().getReferenceTaxonId());
            target.setReferenceTaxon(referenceTaxon);
        }
        if (source.isSpeciesToConfirm()) {
            target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_DOUBTFUL)));
        } else {
            target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        }
        if (copyIfNull && source.getComment() == null) {
            target.setComments(null);
        } else if (source.getComment() != null) {
            target.setComments(source.getComment());
        }
        target.setExhaustiveInventory(Boolean.valueOf(true));
        if (target.getQuantificationMeasurements() != null && notChangedQuantificationMeasurements.size() > 0) {
            for (QuantificationMeasurement qm : notChangedQuantificationMeasurements) {
                target.getQuantificationMeasurements().remove(qm);
            }
        }
        if (target.getSortingMeasurements() != null && notChangedSortingMeasurements.size() > 0) {
            for (SortingMeasurement sm : notChangedSortingMeasurements) {
                target.getSortingMeasurements().remove(sm);
            }
        }
    }

    public void setBatchParents(SpeciesBatch source, SortingBatch target, String parentBatchIdStr, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        SortingBatch parentBatch = null;
        if (parentBatchIdStr != null) {
            parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(parentBatchIdStr));
        } else {
            Integer pmfmId = this.sampleCategory2PmfmId(source.getSampleCategoryType());
            if (pmfmId == null || !pmfmId.equals(this.enumeration.PMFM_ID_SORTED_UNSORTED)) {
                throw new DataIntegrityViolationException(MessageFormat.format("A species batch with no parent should have a sampleCategoryType {0} (PMFM.ID={1})", SampleCategoryEnum.sortedUnsorted.name(), this.enumeration.PMFM_ID_SORTED_UNSORTED));
            }
            Integer qualitativeValueId = this.convertSampleCategoryValueIntoQualitativeId(source.getSampleCategoryValue());
            parentBatch = this.catchBatchDao.getSortingBatch(catchBatch.getChildBatchs(), new Object[]{"pmfmId", pmfmId, qualitativeValueId, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
            target.setParentBatch((Batch)parentBatch);
        }
        if (parentBatch == null) {
            throw new DataIntegrityViolationException("Could not retrieve parent batch, for a given speciesBatch : invalid batch tree structure. Please make sure CatchBatch has been saved before to create a SpeciesBatch.");
        }
        target.setParentBatch((Batch)parentBatch);
        target.setRootBatch(catchBatch);
    }

    Integer convertSampleCategoryValueIntoQualitativeId(Serializable value) {
        if (value == null) {
            return null;
        }
        Integer qualitativeValueId = null;
        if (value instanceof CaracteristicQualitativeValue) {
            CaracteristicQualitativeValue cqValue = (CaracteristicQualitativeValue)value;
            qualitativeValueId = Integer.valueOf(cqValue.getId());
        } else if (value instanceof String) {
            qualitativeValueId = Integer.valueOf((String)((Object)value));
        }
        return qualitativeValueId;
    }

    protected void setSampleCategoryQualitative(SpeciesBatch target, Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (pmfmId == null || pmfmId.equals(this.enumeration.PMFM_ID_SORTING_TYPE)) {
            return;
        }
        SampleCategoryEnum sampleCategory = this.referentialService.getSampleCategoryByPmfmId(pmfmId);
        Preconditions.checkNotNull((Object)((Object)sampleCategory), (Object)("Unable to find corresponding SampleCategoryEnum for PMFM.ID : " + pmfmId));
        target.setSampleCategoryType(sampleCategory);
        if (numericalvalue != null) {
            target.setSampleCategoryValue(numericalvalue);
            return;
        }
        if (alphanumericalValue != null) {
            target.setSampleCategoryValue((Serializable)((Object)alphanumericalValue));
            return;
        }
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        if (caracteristic == null || caracteristic.getCaracteristicType() != CaracteristicType.QUALITATIVE) {
            return;
        }
        CaracteristicQualitativeValue value = null;
        for (CaracteristicQualitativeValue qv : caracteristic.getQualitativeValue()) {
            if (qualitativeValueId != Integer.parseInt(qv.getId())) continue;
            value = qv;
            break;
        }
        target.setSampleCategoryValue(value);
    }

    protected void beanToEntity(SpeciesBatchFrequency source, SortingBatch target, SortingBatch parentBatch, short rankOrder, boolean copyIfNull) {
        Preconditions.checkNotNull((Object)source.getBatch());
        Preconditions.checkNotNull((Object)source.getBatch().getId());
        Integer recorderDepartmentId = this.getRecorderDepartmentId();
        HashSet notChangedQuantificationMeasurements = new HashSet();
        if (target.getQuantificationMeasurements() != null) {
            notChangedQuantificationMeasurements.addAll(target.getQuantificationMeasurements());
        }
        HashSet notChangedSortingMeasurements = new HashSet();
        if (target.getSortingMeasurements() != null) {
            notChangedSortingMeasurements.addAll(target.getSortingMeasurements());
        }
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().equals(parentBatch.getId())) {
            target.setParentBatch((Batch)parentBatch);
            target.setRootBatch(parentBatch.getRootBatch());
        }
        target.setRankOrder(Short.valueOf(rankOrder));
        if (!(copyIfNull && source.getWeight() == null || source.getWeight() == null)) {
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getWeight(), true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if ((!copyIfNull || source.getLengthStepCaracteristic() != null && source.getLengthStep() != null) && source.getLengthStepCaracteristic() != null && source.getLengthStep() != null) {
            Integer pmfmId = Integer.valueOf(source.getLengthStepCaracteristic().getId());
            SortingMeasurement sortingMeasurement = this.setSortingMeasurement(target, recorderDepartmentId, pmfmId, (Serializable)source.getLengthStep());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        if (copyIfNull && source.getNumber() == null) {
            target.setIndividualCount(null);
        } else if (source.getNumber() != null) {
            target.setIndividualCount(source.getNumber());
        }
        target.setReferenceTaxon(null);
        target.setQualityFlag(parentBatch.getQualityFlag());
        if (copyIfNull && source.getComment() == null) {
            target.setComments(null);
        } else if (source.getComment() != null) {
            target.setComments(source.getComment());
        }
        target.setExhaustiveInventory(Boolean.valueOf(true));
        if (target.getQuantificationMeasurements() != null && notChangedQuantificationMeasurements.size() > 0) {
            for (QuantificationMeasurement qm : notChangedQuantificationMeasurements) {
                target.getQuantificationMeasurements().remove(qm);
            }
        }
        if (target.getSortingMeasurements() != null && notChangedSortingMeasurements.size() > 0) {
            for (SortingMeasurement sm : notChangedSortingMeasurements) {
                target.getSortingMeasurements().remove(sm);
            }
        }
    }

    protected UIWeight convertDatabase2UI(Float weight, Float samplingRatio, String samplingRatioText) {
        UIWeight result = new UIWeight();
        if (samplingRatio == null) {
            result.sampleCategoryWeight = weight;
        } else if (weight != null) {
            String startStr = weight.toString().replace(',', '.') + "/";
            if (samplingRatioText != null && samplingRatioText.startsWith(startStr)) {
                String weightStr = samplingRatioText.substring(startStr.length());
                if (weightStr != null && !weightStr.isEmpty()) {
                    result.sampleCategoryWeight = Float.valueOf(Float.parseFloat(weightStr));
                    result.weight = weight;
                }
            } else {
                result.sampleCategoryWeight = weight;
            }
        }
        return result;
    }

    protected void beanToEntity(fr.ifremer.tutti.persistence.entities.data.CatchBatch source, CatchBatch target, boolean copyIfNull) {
        Map<Integer, SortingBatch> catchBatchChilds;
        SortingBatch batch;
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        Integer recorderDepartmentId = this.getRecorderDepartmentId();
        Integer fishingOperationId = Integer.valueOf(source.getFishingOperation().getId());
        target.setFishingOperation((fr.ifremer.adagio.core.dao.data.operation.FishingOperation)this.load(FishingOperationImpl.class, fishingOperationId));
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        target.setRankOrder(Short.valueOf((short)1));
        target.setSynchronizationStatus(SynchronizationStatus.DIRTY.getValue());
        HashSet notChangedQuantificationMeasurements = new HashSet();
        if (target.getQuantificationMeasurements() != null) {
            notChangedQuantificationMeasurements.addAll(target.getQuantificationMeasurements());
        }
        if (!(copyIfNull && source.getCatchTotalWeight() == null || source.getCatchTotalWeight() == null)) {
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, source.getCatchTotalWeight(), true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (target.getQuantificationMeasurements() != null && notChangedQuantificationMeasurements.size() > 0) {
            for (QuantificationMeasurement qm : notChangedQuantificationMeasurements) {
                target.getQuantificationMeasurements().remove(qm);
            }
        }
        if ((batch = (catchBatchChilds = this.getChildsMap((Batch)target, this.enumeration.PMFM_ID_SORTED_UNSORTED)).get(this.enumeration.QUALITATIVE_VRAC_ID)) == null) {
            batch = SortingBatch.Factory.newInstance();
            target.getChildBatchs().add(batch);
        }
        this.beanToEntitySortingBatch(target, (Batch)target, batch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, source.getCatchTotalSortedCarousselWeight(), source.getCatchTotalSortedTremisWeight(), copyIfNull);
        batch.setRankOrder(Short.valueOf((short)1));
        Map<Integer, SortingBatch> batchChilds = this.getChildsMap((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE);
        SortingBatch speciesBatch = batchChilds.get(this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
        if (speciesBatch == null) {
            speciesBatch = SortingBatch.Factory.newInstance();
            if (batch.getChildBatchs() == null) {
                batch.setChildBatchs((Collection)Lists.newArrayList((Object[])new Batch[]{speciesBatch}));
            } else {
                batch.getChildBatchs().add(speciesBatch);
            }
        }
        this.beanToEntitySortingBatch(target, (Batch)batch, speciesBatch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES, source.getSpeciesTotalSampleSortedWeight(), source.getSpeciesTotalSortedWeight(), copyIfNull);
        speciesBatch.setRankOrder(Short.valueOf((short)1));
        SortingBatch aliveNotItemizedBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_LIFE});
        if (aliveNotItemizedBatch == null) {
            aliveNotItemizedBatch = SortingBatch.Factory.newInstance();
            if (speciesBatch.getChildBatchs() == null) {
                speciesBatch.setChildBatchs((Collection)Lists.newArrayList((Object[])new Batch[]{aliveNotItemizedBatch}));
            } else {
                speciesBatch.getChildBatchs().add(aliveNotItemizedBatch);
            }
        }
        this.beanToEntityReferenceTaxonBatch(target, (Batch)speciesBatch, aliveNotItemizedBatch, recorderDepartmentId, this.enumeration.REFERENCE_TAXON_ID_LIFE, source.getSpeciesTotalLivingNotItemizedWeight(), null, copyIfNull);
        aliveNotItemizedBatch.setRankOrder(Short.valueOf((short)1));
        SortingBatch inertBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_INERT});
        if (inertBatch == null) {
            inertBatch = SortingBatch.Factory.newInstance();
            speciesBatch.getChildBatchs().add(inertBatch);
        }
        this.beanToEntityReferenceTaxonBatch(target, (Batch)speciesBatch, inertBatch, recorderDepartmentId, this.enumeration.REFERENCE_TAXON_ID_INERT, source.getSpeciesTotalInertWeight(), null, copyIfNull);
        inertBatch.setRankOrder(Short.valueOf((short)2));
        batch = catchBatchChilds.get(this.enumeration.QUALITATIVE_HORS_VRAC_ID);
        if (batch == null) {
            batch = SortingBatch.Factory.newInstance();
            target.getChildBatchs().add(batch);
        }
        this.beanToEntitySortingBatch(target, (Batch)target, batch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, source.getCatchTotalUnsortedWeight(), null, copyIfNull);
        batch.setRankOrder(Short.valueOf((short)2));
        batchChilds = this.getChildsMap((Batch)batch, this.enumeration.PMFM_ID_SORTING_TYPE);
        speciesBatch = batchChilds.get(this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
        if (speciesBatch == null) {
            speciesBatch = SortingBatch.Factory.newInstance();
            if (batch.getChildBatchs() == null) {
                batch.setChildBatchs((Collection)Lists.newArrayList((Object[])new Batch[]{speciesBatch}));
            } else {
                batch.getChildBatchs().add(speciesBatch);
            }
        }
        this.beanToEntitySortingBatch(target, (Batch)batch, speciesBatch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES, source.getSpeciesTotalUnsortedWeight(), null, copyIfNull);
        speciesBatch.setRankOrder(Short.valueOf((short)1));
        SortingBatch unsortedBatch = catchBatchChilds.get(this.enumeration.QUALITATIVE_UNSORTED_ID);
        if (unsortedBatch == null) {
            unsortedBatch = SortingBatch.Factory.newInstance();
            target.getChildBatchs().add(unsortedBatch);
        }
        this.beanToEntitySortingBatch(target, (Batch)target, unsortedBatch, recorderDepartmentId, this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID, source.getCatchTotalRejectedWeight(), null, copyIfNull);
        unsortedBatch.setRankOrder(Short.valueOf((short)3));
    }

    protected Map<Integer, SortingBatch> getChildsMap(Batch parentBatch, Integer pmfmId) {
        HashMap<Integer, SortingBatch> batchByQualitativeValueId = new HashMap<Integer, SortingBatch>();
        if (parentBatch.getChildBatchs() == null) {
            return batchByQualitativeValueId;
        }
        for (Batch childBatch : parentBatch.getChildBatchs()) {
            SortingBatch childSortingBatch = (SortingBatch)childBatch;
            SortingMeasurement sm = this.catchBatchDao.getSortingMeasurement((SortingBatch)childBatch, pmfmId, null, false);
            if (sm == null || sm.getQualitativeValue() == null || sm.getQualitativeValue().getId() == null) continue;
            batchByQualitativeValueId.put(sm.getQualitativeValue().getId(), childSortingBatch);
        }
        return batchByQualitativeValueId;
    }

    protected Map<Integer, SortingBatch> getChildAliveNotSortedOrInert(Batch parentBatch) {
        HashMap<Integer, SortingBatch> batchByQualitativeValueId = new HashMap<Integer, SortingBatch>();
        if (parentBatch.getChildBatchs() == null) {
            return batchByQualitativeValueId;
        }
        for (Batch childBatch : parentBatch.getChildBatchs()) {
            SortingBatch childSortingBatch = (SortingBatch)childBatch;
            if (childSortingBatch.getReferenceTaxon() == null || childSortingBatch.getId() >= 0) continue;
            if (this.enumeration.REFERENCE_TAXON_ID_LIFE.equals(childSortingBatch.getId())) {
                batchByQualitativeValueId.put(this.enumeration.REFERENCE_TAXON_ID_LIFE, childSortingBatch);
                continue;
            }
            if (!this.enumeration.REFERENCE_TAXON_ID_LIFE.equals(childSortingBatch.getId())) continue;
            batchByQualitativeValueId.put(this.enumeration.REFERENCE_TAXON_ID_LIFE, childSortingBatch);
        }
        return batchByQualitativeValueId;
    }

    protected void beanToEntitySortingBatch(CatchBatch rootBatch, Batch parentBatch, SortingBatch target, Integer recorderDepartmentId, Integer sortingPmfmId, Integer sortingQualitativeValueId, Float weight, Float sampleWeight, boolean copyIfNull) {
        HashSet notChangedQuantificationMeasurements = new HashSet();
        if (target.getQuantificationMeasurements() != null) {
            notChangedQuantificationMeasurements.addAll(target.getQuantificationMeasurements());
        }
        HashSet notChangedSortingMeasurements = new HashSet();
        if (target.getSortingMeasurements() != null) {
            notChangedSortingMeasurements.addAll(target.getSortingMeasurements());
        }
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        target.setRootBatch(rootBatch);
        target.setParentBatch(parentBatch);
        target.setExhaustiveInventory(Boolean.valueOf(true));
        target.setReferenceTaxon(null);
        target.setTaxonGroup(null);
        if ((!copyIfNull || sortingPmfmId != null && sortingQualitativeValueId != null) && sortingPmfmId != null && sortingQualitativeValueId != null) {
            SortingMeasurement sm = this.setSortingMeasurement(target, recorderDepartmentId, sortingPmfmId, (Serializable)sortingQualitativeValueId);
            notChangedSortingMeasurements.remove(sm);
        }
        if (copyIfNull && (sampleWeight == null || weight == null)) {
            target.setSamplingRatio(null);
            target.setSamplingRatioText(null);
        } else if (sampleWeight != null && weight != null) {
            String samplingRatioText = weight + "/" + sampleWeight;
            samplingRatioText = samplingRatioText.replaceAll(",", ".");
            target.setSamplingRatioText(samplingRatioText);
            target.setSamplingRatio(Float.valueOf(weight.floatValue() / sampleWeight.floatValue()));
        }
        if (!(copyIfNull && sampleWeight == null && weight == null || sampleWeight == null && weight == null)) {
            Float batchReferenceWeight = weight;
            if (batchReferenceWeight == null) {
                batchReferenceWeight = sampleWeight;
            }
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, batchReferenceWeight, true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (target.getQuantificationMeasurements() != null && notChangedQuantificationMeasurements.size() > 0) {
            for (QuantificationMeasurement qm : notChangedQuantificationMeasurements) {
                target.getQuantificationMeasurements().remove(qm);
            }
        }
        if (target.getSortingMeasurements() != null && notChangedSortingMeasurements.size() > 0) {
            for (SortingMeasurement sm : notChangedSortingMeasurements) {
                target.getSortingMeasurements().remove(sm);
            }
        }
    }

    protected void beanToEntityReferenceTaxonBatch(CatchBatch rootBatch, Batch parentBatch, SortingBatch target, Integer recorderDepartmentId, Integer referenceTaxonId, Float weight, Float sampleWeight, boolean copyIfNull) {
        HashSet notChangedQuantificationMeasurements = new HashSet();
        if (target.getQuantificationMeasurements() != null) {
            notChangedQuantificationMeasurements.addAll(target.getQuantificationMeasurements());
        }
        HashSet notChangedSortingMeasurements = new HashSet();
        if (target.getSortingMeasurements() != null) {
            notChangedSortingMeasurements.addAll(target.getSortingMeasurements());
        }
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        target.setRootBatch(rootBatch);
        target.setParentBatch(parentBatch);
        target.setExhaustiveInventory(Boolean.valueOf(true));
        target.setReferenceTaxon((ReferenceTaxon)this.load(ReferenceTaxonImpl.class, referenceTaxonId));
        target.setTaxonGroup(null);
        if (copyIfNull && (sampleWeight == null || weight == null)) {
            target.setSamplingRatio(null);
            target.setSamplingRatioText(null);
        } else if (sampleWeight != null && weight != null) {
            String samplingRatioText = weight + "/" + sampleWeight;
            samplingRatioText = samplingRatioText.replaceAll(",", ".");
            target.setSamplingRatioText(samplingRatioText);
            target.setSamplingRatio(Float.valueOf(weight.floatValue() / sampleWeight.floatValue()));
        }
        if (!(copyIfNull && sampleWeight == null && weight == null || sampleWeight == null && weight == null)) {
            Float batchReferenceWeight = weight;
            if (batchReferenceWeight == null) {
                batchReferenceWeight = sampleWeight;
            }
            QuantificationMeasurement quantificationMeasurement = this.catchBatchDao.setQuantificationMeasurement((Batch)target, this.enumeration.PMFM_ID_WEIGHT_MEASURED, recorderDepartmentId, batchReferenceWeight, true);
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (target.getQuantificationMeasurements() != null && notChangedQuantificationMeasurements.size() > 0) {
            for (QuantificationMeasurement qm : notChangedQuantificationMeasurements) {
                target.getQuantificationMeasurements().remove(qm);
            }
        }
        if (target.getSortingMeasurements() != null && notChangedSortingMeasurements.size() > 0) {
            for (SortingMeasurement sm : notChangedSortingMeasurements) {
                target.getSortingMeasurements().remove(sm);
            }
        }
    }

    protected Integer getRecorderDepartmentId() {
        return this.enumeration.DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT;
    }

    public void setMeasurement(Measurement measurement, Caracteristic caracteristic, Serializable value) {
        if (caracteristic.getCaracteristicType() == CaracteristicType.TEXT) {
            measurement.setAlphanumericalValue((String)((Object)value));
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.NUMBER) {
            measurement.setNumericalValue((Float)value);
        } else if (caracteristic.getCaracteristicType() == CaracteristicType.QUALITATIVE) {
            Integer qvId = null;
            qvId = value instanceof CaracteristicQualitativeValue ? Integer.valueOf(((CaracteristicQualitativeValue)value).getId()) : (value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString()));
            QualitativeValue qv = (QualitativeValue)this.load(QualitativeValueImpl.class, qvId);
            measurement.setQualitativeValue(qv);
        }
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer recorderDepartmentId, SampleCategoryEnum sampleCategory, Serializable value) {
        Preconditions.checkNotNull((Object)((Object)sampleCategory));
        Preconditions.checkNotNull((Object)value);
        Integer pmfmId = this.sampleCategory2PmfmId(sampleCategory);
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.catchBatchDao.getSortingMeasurement(sortingBatch, pmfmId, recorderDepartmentId, true);
        this.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }

    public SortingMeasurement setSortingMeasurement(SortingBatch sortingBatch, Integer recorderDepartmentId, Integer pmfmId, Serializable value) {
        Preconditions.checkNotNull((Object)pmfmId);
        Preconditions.checkNotNull((Object)value);
        Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
        SortingMeasurement sortingMeasurement = this.catchBatchDao.getSortingMeasurement(sortingBatch, pmfmId, recorderDepartmentId, true);
        this.setMeasurement((Measurement)sortingMeasurement, caracteristic, value);
        return sortingMeasurement;
    }

    public Integer sampleCategory2PmfmId(SampleCategoryEnum sampleCategory) {
        Integer pmfmId = null;
        if (sampleCategory == SampleCategoryEnum.sortedUnsorted) {
            pmfmId = this.enumeration.PMFM_ID_SORTED_UNSORTED;
        } else if (sampleCategory == SampleCategoryEnum.size) {
            pmfmId = this.enumeration.PMFM_ID_SIZE_CATEGORY;
        } else if (sampleCategory == SampleCategoryEnum.maturity) {
            pmfmId = this.enumeration.PMFM_ID_MATURITY;
        } else if (sampleCategory == SampleCategoryEnum.sex) {
            pmfmId = this.enumeration.PMFM_ID_SEX;
        } else if (sampleCategory == SampleCategoryEnum.age) {
            pmfmId = this.enumeration.PMFM_ID_AGE;
        }
        if (pmfmId == null) {
            throw new IllegalArgumentException("Unable to find corresponding PMFM.ID for sampleCategory : " + sampleCategory.name());
        }
        return pmfmId;
    }

    @Override
    public void setCatchBatchDao(CatchBatchExtendDao catchBatchDao) {
        this.catchBatchDao = catchBatchDao;
    }

    static class UIWeight {
        Float sampleCategoryWeight = null;
        Float weight = null;

        UIWeight() {
        }
    }
}

