/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MacroWasteBatch;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste.MacroWasteBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste.MacroWasteBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste.MacroWasteBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste.MacroWasteBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentCellComponent;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextCellComponent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class MacroWasteBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<MacroWasteBatchRowModel, MacroWasteBatchUIModel> {
    private static final Log log = LogFactory.getLog(MacroWasteBatchUIHandler.class);
    private final MacroWasteBatchUI ui;

    public MacroWasteBatchUIHandler(TuttiUI<?, ?> parentUi, MacroWasteBatchUI ui) {
        super(parentUi, "macroWasteCategory", "macroWasteSizeCategory", "weight", "number", "comment");
        this.ui = ui;
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        MacroWasteBatchUIModel model = this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get macroWaste batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((IdAware)bean)) {
                List catches = this.persistenceService.getAllMacroWasteBatch(bean.getId());
                for (MacroWasteBatch aBatch : catches) {
                    MacroWasteBatchRowModel entry = new MacroWasteBatchRowModel(aBatch);
                    rows.add(entry);
                }
            }
        }
        model.setRows(rows);
    }

    protected MacroWasteBatchTableModel getTableModel() {
        return (MacroWasteBatchTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getTable();
    }

    @Override
    protected boolean isRowValid(MacroWasteBatchRowModel row) {
        boolean result = row.getMacroWasteCategory() != null && row.getMacroWasteSizeCategory() != null && row.getWeight() != null;
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, MacroWasteBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<MacroWasteBatchRowModel> rowMonitor, MacroWasteBatchRowModel row) {
        if (row != null) {
            if (row.isValid()) {
                if (rowMonitor.wasModified()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Row " + (Object)((Object)row) + " was modified, will save it"));
                    }
                    this.saveRow(row);
                    rowMonitor.clearModified();
                }
            } else {
                MacroWasteBatch catchBean = (MacroWasteBatch)row.toBean();
                if (!TuttiEntities.isNew((IdAware)catchBean)) {
                    this.persistenceService.deleteMacroWasteBatch(catchBean.getId());
                }
            }
        }
    }

    @Override
    protected MacroWasteBatchUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = this.ui.getContextValue(EditCatchesUIModel.class);
        MacroWasteBatchUIModel model = new MacroWasteBatchUIModel(catchesUIModel);
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> decorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, MacroWasteBatchTableModel.MACRO_WASTE_CATEGORY, decorator, this.persistenceService.getMacroWasteCategoryCaracteristic().getQualitativeValue());
        decorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        this.addComboDataColumnToModel((TableColumnModel)columnModel, MacroWasteBatchTableModel.MACRO_WASTE_SIZE_CATEGORY, decorator, this.persistenceService.getMacroWasteSizeCategoryCaracteristic().getQualitativeValue());
        this.addFloatColumnToModel((TableColumnModel)columnModel, MacroWasteBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        this.addIntegerColumnToModel((TableColumnModel)columnModel, MacroWasteBatchTableModel.NUMBER, "\\d{0,3}");
        this.addColumnToModel((TableColumnModel)columnModel, LongTextCellComponent.newEditor(this.ui.getLongTextEditor()), LongTextCellComponent.newRender(I18n.n_((String)"tutti.tooltip.comment.none", (Object[])new Object[0])), MacroWasteBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellComponent.newEditor(this.ui.getAttachmentEditor()), AttachmentCellComponent.newRender(this.getDecorator(Attachment.class, null), I18n.n_((String)"tutti.tooltip.attachment.none", (Object[])new Object[0])), MacroWasteBatchTableModel.ATTACHMENTS);
        MacroWasteBatchTableModel tableModel = new MacroWasteBatchTableModel((TableColumnModel)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    protected void saveRow(MacroWasteBatchRowModel row) {
        MacroWasteBatch catchBean = (MacroWasteBatch)row.toBean();
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        catchBean.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew((IdAware)catchBean)) {
            catchBean = this.persistenceService.createMacroWasteBatch(catchBean);
            row.setId(catchBean.getId());
        } else {
            this.persistenceService.saveMacroWasteBatch(catchBean);
        }
    }
}

