package fr.ifremer.tutti.ui.swing.util.table;

/*
 * #%L
 * Tutti :: UI
 * $Id: CaracteristicRow.java 129 2012-12-29 20:50:48Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/table/CaracteristicRow.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 0.3
 */
public class CaracteristicRow implements DecoratorService.LabelAware {

    private static final long serialVersionUID = 1L;

    protected Caracteristic[] caracteristics;

    protected String name;

    public CaracteristicRow(String name, Caracteristic... caracteristics) {
        this.name = name;
        this.caracteristics = caracteristics;
    }

    public Caracteristic[] getCaracteristics() {
        return caracteristics;
    }

    public void setCaracteristics(Caracteristic... caracteristics) {
        this.caracteristics = caracteristics;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel() {
        return name;
    }
}
