package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryType;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SplitSpeciesBatchUI extends JPanel implements TuttiUI<SplitSpeciesBatchUIModel, SplitSpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_WEIGHT_FIELD_TEXT = "batchWeightField.text";
    public static final String BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM = "categoryComboBox.selectedItem";
    public static final String BINDING_SAMPLE_CHECK_BOX_SELECTED = "sampleCheckBox.selected";
    public static final String BINDING_SAMPLE_WEIGHT_FIELD_TEXT = "sampleWeightField.text";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SPECIES_FIELD_TEXT = "speciesField.text";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SplitSpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JTextField batchWeightField;
    protected JLabel batchWeightLabel;
    protected JButton cancelButton;
    @ValidatorField( validatorId = "validator",  propertyName = "selectedCategory",  editorName = "categoryComboBox")
    protected BeanComboBox<SampleCategoryType> categoryComboBox;
    protected JLabel categoryLabel;
    protected Table configurationPanel;
    protected JTable errorTable;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected SplitSpeciesBatchUIHandler handler;
    protected SplitSpeciesBatchUI homePanel = this;
    protected JPanel messagePanel;
    protected SplitSpeciesBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sample",  editorName = "sampleCheckBox")
    protected JCheckBox sampleCheckBox;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleWeight",  editorName = "sampleWeightField")
    protected JTextField sampleWeightField;
    protected JLabel sampleWeightLabel;
    protected JButton saveButton;
    protected JTextField speciesField;
    protected JLabel speciesLabel;
    protected JSplitPane splitPane;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<SplitSpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SplitSpeciesBatchUI(SpeciesBatchUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            SplitSpeciesBatchUIHandler handler = new SplitSpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SplitSpeciesBatchUI() {
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SplitSpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SplitSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doItemStateChanged__on__sampleCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "sample");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JTextField getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public BeanComboBox<SampleCategoryType> getCategoryComboBox() {
        return categoryComboBox;
    }

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public JTable getErrorTable() {
        return errorTable;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public SplitSpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public JPanel getMessagePanel() {
        return messagePanel;
    }

    public SplitSpeciesBatchUIModel getModel() {
        return model;
    }

    public JCheckBox getSampleCheckBox() {
        return sampleCheckBox;
    }

    public JTextField getSampleWeightField() {
        return sampleWeightField;
    }

    public JLabel getSampleWeightLabel() {
        return sampleWeightLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getSpeciesField() {
        return speciesField;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<SplitSpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(saveButton);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(categoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(categoryComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleCheckBox), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add($JSeparator0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(speciesField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(sampleWeightLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(sampleWeightField), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(splitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMessagePanel() {
        if (!allComponentsCreated) {
            return;
        }
        messagePanel.add($JScrollPane0);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JPanel0, JSplitPane.LEFT);
        splitPane.add(messagePanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new JTextField());
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setColumns(15);
        batchWeightField.setEnabled(false);
        batchWeightField.setEditable(false);
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(_("tutti.label.sampleCategoryConfiguration.batchWeight"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.setMnemonic(65);
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCategoryComboBox() {
        $objectMap.put("categoryComboBox", categoryComboBox = new BeanComboBox<SampleCategoryType>(this));
        
        categoryComboBox.setName("categoryComboBox");
        categoryComboBox.setI18nPrefix("tutti.property.");
        categoryComboBox.setProperty("selectedCategory");
        categoryComboBox.setShowReset(true);
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
        categoryLabel.setText(_("tutti.label.sampleCategoryConfiguration.category"));
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new JTable());
        
        errorTable.setName("errorTable");
        errorTable.setCellSelectionEnabled(false);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setAutoCreateRowSorter(true);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SplitSpeciesBatchUIHandler.class));
    }

    protected void createMessagePanel() {
        $objectMap.put("messagePanel", messagePanel = new JPanel());
        
        messagePanel.setName("messagePanel");
        messagePanel.setLayout(new GridLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SplitSpeciesBatchUIModel.class));
    }

    protected void createSampleCheckBox() {
        $objectMap.put("sampleCheckBox", sampleCheckBox = new JCheckBox());
        
        sampleCheckBox.setName("sampleCheckBox");
        sampleCheckBox.setText(_("tutti.label.sampleCategoryConfiguration.sample"));
        sampleCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__sampleCheckBox"));
    }

    protected void createSampleWeightField() {
        $objectMap.put("sampleWeightField", sampleWeightField = new JTextField());
        
        sampleWeightField.setName("sampleWeightField");
        sampleWeightField.setColumns(15);
        sampleWeightField.setEnabled(false);
        sampleWeightField.setEditable(false);
    }

    protected void createSampleWeightLabel() {
        $objectMap.put("sampleWeightLabel", sampleWeightLabel = new JLabel());
        
        sampleWeightLabel.setName("sampleWeightLabel");
        sampleWeightLabel.setText(_("tutti.label.sampleCategoryConfiguration.sampleWeight"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.setMnemonic(69);
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSpeciesField() {
        $objectMap.put("speciesField", speciesField = new JTextField());
        
        speciesField.setName("speciesField");
        speciesField.setColumns(15);
        speciesField.setEnabled(false);
        speciesField.setEditable(false);
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(_("tutti.label.sampleCategoryConfiguration.species"));
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.2);
        splitPane.setOneTouchExpandable(true);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SplitSpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToSplitPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(configurationPanel, BorderLayout.NORTH);
        $JPanel0.add(tableScrollPane, BorderLayout.CENTER);
        $JPanel0.add(actionPanel, BorderLayout.SOUTH);
        addChildrenToConfigurationPanel();
        addChildrenToTableScrollPane();
        addChildrenToActionPanel();
        addChildrenToMessagePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 21 property setters
        categoryComboBox.setBeanType(SampleCategoryType.class);
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        configurationPanel.setBorder(new TitledBorder(null, _("tutti.legend.splitSpeciesBatchConfiguration")));
        categoryLabel.setLabelFor(categoryComboBox);
        categoryComboBox.setBean(model);
        speciesLabel.setLabelFor(speciesField);
        batchWeightLabel.setLabelFor(batchWeightField);
        sampleWeightLabel.setLabelFor(sampleWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        messagePanel.setBorder(BorderFactory.createTitledBorder(_("tutti.title.messages")));
        errorTable.setModel(errorTableModel);
        errorTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        errorTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createSplitPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigurationPanel();
        createCategoryLabel();
        createCategoryComboBox();
        createSampleCheckBox();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createSpeciesLabel();
        createSpeciesField();
        createBatchWeightLabel();
        createBatchWeightField();
        createSampleWeightLabel();
        createSampleWeightField();
        createTableScrollPane();
        createTable();
        createActionPanel();
        createCancelButton();
        createSaveButton();
        createMessagePanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATEGORY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    categoryComboBox.setSelectedItem(model.getSelectedCategory());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sample", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleCheckBox.setSelected(model.isSample());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sample", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesField, handler.decorateSpecies(model.getSpecies()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(batchWeightField, getStringValue(model.getBatchWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(sampleWeightField, getStringValue(model.getSampleWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedCategory", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getSelectedCategory() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedCategory", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}