package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextEditorUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SpeciesBatchUI extends JPanel implements TuttiUI<SpeciesBatchUIModel, SpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_SPECIES_BATCH_BUTTON_ENABLED = "createSpeciesBatchButton.enabled";
    public static final String BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED = "filterSpeciesBatchAllButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED = "filterSpeciesBatchLeafButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED = "filterSpeciesBatchRootButton.selected";
    public static final String BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED = "removeSpeciesBatchMenu.enabled";
    public static final String BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED = "removeSpeciesSubBatchMenu.enabled";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSampleSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSampleSortedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSortedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_MODEL = "speciesTotalWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalWeightField.numberPattern";
    public static final String BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED = "splitSpeciesBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1YT0/cRhQfCMu/QEgThRCFAAGBFiUxUQ9ppURJYAPJ0uVP8UKjoorOroddJ7Me1x7DRiuqfoR+hPbeS6Xeeqp66LmHXqp+harqodeqb8betb1rr70UpJgwfu/33vu98bz35rs/Uca20N03uF5XLMfgeo0om6uvX++U3pAyf0HssqWbnFnI/enrR/2H6LLWWrc5WjgsCPUVT30lx2omM4gR0H5cQKM2f0eJXSWEc3QnrFG27RW19fpx3XSsJmrLqSjUb/7+q/9r7atv+xGqm+DdDIQyl6TlRzJQQP26xtE1sHSCVyg2KuCGpRsV8HdcrOUotu1tXCNfoC/RUAENmtgCMI7m04csMaR+3eRopMpqZBcbhHK0eWwp+rFFasRSuMO5rji6Yp+CfaXMDA5wCjOJhbnODKWMeblKbMU2SVmH36r7e00s7+dNU5oY5Gioig2NEoujjy8O/pWL6VvJ1JgmQti5OBtbAtG3MEEsi1lFXKJky7X1JJTZE0x1DQPRnjlVPA+ai1vEtnGF+Oo+8EhLk6N7PUD6CFcoMypFUufrmi5hHsWz4HCdKkTKKYWQ2n5ewI20UK9iznG5WgPOmrgfpsNdbVNsRx7lgoZdZjqwASfFvq57KJtycYsYjh/dDdukOg/mRryH9ZCiWMtzUhNKMy3dSfCVnZB2ZfF2ISx5KySpOqVuwgPHzKpxNBXKluuIzHA43Jve/ioyjuknRK9UeQGXxA66FgpBLgqdbDfVDZ1QOCOWImx79G87tRKxXOrDcHeCcCpklGgBf4TQg5QK0gsh9DCssBBSwDWTkjR2EtTirM0G1fYNO4WlLioes+ENKb6PlnkfZkxu4SJjtISt9kTK4zQsP1W2COahjbgGHxAcSeh6SNddFVpP/aPnWKecuGePwBbLz8MiN12RIH6YgRct0dudoquUNr2ZCnmzhzWd+S75INMR9gg+9kU3E+X3GOOx8hOSX7VsMUpFyBBhyDH/Tfhby0g9CJJZFeUNtAVvOTNdpbqy+br1de74R0SnZ+KAhpIa8YWJTsT1+aXF4IwyocDfDslB66D4rYNf2/sOUcZyYBkoPuzsNvbgldtnTLX1GQJQvv138vpvP/7xw0azuZgE2zciRQO9ERR90xIVj+vC9ITbWYjDemULm48P0YhNKDRWsnGajnBM9V6Dc2DvPaHunvWvsF0FiMzQ7z/9PPn5r5dQ/wYapQxrG1jI59EIr1rAAqNa3Xz2XHo0djoMz6vwbwAO0RLBsOGGGrJ0n0EhxA5nXlVYaXhtg1IhPMeMY72SXVZ0e7UpEjzksstCG0yd7hFbtHMD3HKA/AmxJKWbu/thDKwKgkFEVx5w65CR6YiMtGgpjfzyz3X1++fNrPQBS7dixf3MZD5Fg7pBdYPIps/r5yKbvMumTRyN+X1bVCeHgLSxYAheAf1MPnFHAvo5GqbihNgQhf1WI6bQnAky4QiEguMWfKnT3jkFtOqyXr6VTIj/1VB8ATQTfBzw+7pZd5eItKkdYDL/44YMfhe6FmJBqicb+e3i0aOjF/mX+aJ6tLtaLK7vbYPgsGOTDdioEFPmGFPYMGjY+0bewUl+7pAkX0khhWmfbXStrz7595PID+pG+du98veQiMXoRAQhLzIdUxcS5DlSs9hI0ZL4CXo/MUEdCFERpGmfekjWvZhkdQBfZMpmLjzsc6TvbiOhz/NTpySlLqwd5X9SH5rk+yUog8QQvYnmU+q590FDZE/eAsDo55BsZErDRrPLIp/DYh5w2yEXs0fXU9HeB+DUnWamXCK5zilRSrKvLIs5246yG5gBk0xkguyseVtat2Uvd6CTU9GuQQebXZ5bWpprvlXbh8Z1F0HudI/aGddhLL1UOsZMYLBmwFRo6GWO+lTw2ZXMi5sEdFlG+EBqwV8cRoGibhYl8Hx3YKDIjOIketLtiZ5cSnr2OubiCH5mQ2F0jtJhgvbaCBpzCQJ7hJN2hhYSoOMoihnoe+Jo4zwcNW8EImiaj4+lqfU/mFpKRo8jK/5OI0UNGXcHAzDqjkOLjYJuczW4SBU1v/2ysH6krhfWc8X8jiwO4ggJnjow4bag4GwmFZicDEjDeCPHKLOUtcJq7qOzoNQaLr9tSg02DIfSs6jw3FkvRSh+6hdbqc91zOOJH0DnCB9Oay46ra5aVACxlwIpDt3BErM0cas63TDI6VxRHLramlzLCsbuz83PL0fS1n6bkKI4jR3Z3GJGRQ62rfHKIykbrJ/Rw7TiVYjwzr6fVjFuf8ddeqQ4DYbdzSb2xHSX48DfCvdSOCtwFExFoCX/kqDLFUPmRFR0ji65SiF2VnowGEdQt6ue3ki6E02SuPMJspQmpdJpCoo90zTgaYV4etiLyTiiul5nXQhT4rbrXExZoNg7U57W+ZgSyj0w5V/kpTm3KH7HQBhdeaJhjudKuqFBa/u0w1afeI4mIsJy3754HEQjPAOE/wAnZ6QNVRwAAA==";
    private static final Log log = LogFactory.getLog(SpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AttachmentEditorUI attachmentEditor;
    protected JButton createSpeciesBatchButton;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JRadioButton filterSpeciesBatchAllButton;
    protected JLabel filterSpeciesBatchLabel;
    protected JRadioButton filterSpeciesBatchLeafButton;
    protected JAXXButtonGroup filterSpeciesBatchMode;
    protected JRadioButton filterSpeciesBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected SpeciesBatchUIHandler handler;
    protected SpeciesBatchUI homePanel = this;
    protected LongTextEditorUI longTextEditor;
    protected SpeciesBatchUIModel model;
    protected JMenuItem removeSpeciesBatchMenu;
    protected JMenuItem removeSpeciesSubBatchMenu;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSampleSortedWeight",  editorName = "speciesTotalSampleSortedWeightField")
    protected NumberEditor speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected NumberEditor speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalUnsortedWeight",  editorName = "speciesTotalUnsortedWeightField")
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalWeight",  editorName = "speciesTotalWeightField")
    protected NumberEditor speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JMenuItem splitSpeciesBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            SpeciesBatchUIHandler handler = new SpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SpeciesBatchUI() {
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createSpeciesBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createSpeciesBatch();
    }

    public void doActionPerformed__on__filterSpeciesBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterSpeciesBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterSpeciesBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__removeSpeciesBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeSpeciesBatch();
    }

    public void doActionPerformed__on__removeSpeciesSubBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeSpeciesSubBatch();
    }

    public void doActionPerformed__on__splitSpeciesBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.splitSpeciesBatch();
    }

    public void doFocusLost__on__table(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSelectedRowIfRequired(event);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI getAttachmentEditor() {
        return attachmentEditor;
    }

    public JButton getCreateSpeciesBatchButton() {
        return createSpeciesBatchButton;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JRadioButton getFilterSpeciesBatchAllButton() {
        return filterSpeciesBatchAllButton;
    }

    public JLabel getFilterSpeciesBatchLabel() {
        return filterSpeciesBatchLabel;
    }

    public JRadioButton getFilterSpeciesBatchLeafButton() {
        return filterSpeciesBatchLeafButton;
    }

    public JAXXButtonGroup getFilterSpeciesBatchMode() {
        return filterSpeciesBatchMode;
    }

    public JRadioButton getFilterSpeciesBatchRootButton() {
        return filterSpeciesBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public SpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public LongTextEditorUI getLongTextEditor() {
        return longTextEditor;
    }

    public SpeciesBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveSpeciesBatchMenu() {
        return removeSpeciesBatchMenu;
    }

    public JMenuItem getRemoveSpeciesSubBatchMenu() {
        return removeSpeciesSubBatchMenu;
    }

    public NumberEditor getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public NumberEditor getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public NumberEditor getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JMenuItem getSplitSpeciesBatchMenu() {
        return splitSpeciesBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFilterSpeciesBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchAllButton); }
    }

    protected void addChildrenToFilterSpeciesBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchLeafButton); }
    }

    protected void addChildrenToFilterSpeciesBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterSpeciesBatchLabel);
        filterTablePane.add(filterSpeciesBatchAllButton);
        filterTablePane.add(filterSpeciesBatchLeafButton);
        filterTablePane.add(filterSpeciesBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(speciesTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSampleSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(speciesTotalUnsortedWeightField), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(longTextEditor);
        add(attachmentEditor);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitSpeciesBatchMenu);
        tablePopup.add(removeSpeciesBatchMenu);
        tablePopup.add(removeSpeciesSubBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add(createSpeciesBatchButton, BorderLayout.WEST);
        tableToolbar.add(filterTablePane, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAttachmentEditor() {
        $objectMap.put("attachmentEditor", attachmentEditor = new AttachmentEditorUI());
        
        attachmentEditor.setName("attachmentEditor");
    }

    protected void createCreateSpeciesBatchButton() {
        $objectMap.put("createSpeciesBatchButton", createSpeciesBatchButton = new JButton());
        
        createSpeciesBatchButton.setName("createSpeciesBatchButton");
        createSpeciesBatchButton.setText(_("tutti.action.createSpeciesBatch"));
        createSpeciesBatchButton.setMnemonic(67);
        createSpeciesBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createSpeciesBatchButton"));
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFilterSpeciesBatchAllButton() {
        $objectMap.put("filterSpeciesBatchAllButton", filterSpeciesBatchAllButton = new JRadioButton());
        
        filterSpeciesBatchAllButton.setName("filterSpeciesBatchAllButton");
        filterSpeciesBatchAllButton.setText(_("tutti.label.filterSpeciesBatchMode.mode.all"));
        { filterSpeciesBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterSpeciesBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchAllButton.setToolTipText(_("tutti.label.filterSpeciesBatchMode.mode.all.tip"));
        filterSpeciesBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchAllButton"));
    }

    protected void createFilterSpeciesBatchLabel() {
        $objectMap.put("filterSpeciesBatchLabel", filterSpeciesBatchLabel = new JLabel());
        
        filterSpeciesBatchLabel.setName("filterSpeciesBatchLabel");
        filterSpeciesBatchLabel.setText(_("tutti.label.filterSpeciesBatchMode.label"));
        filterSpeciesBatchLabel.setToolTipText(_("tutti.label.filterSpeciesBatchMode.label.tip"));
        filterSpeciesBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterSpeciesBatchLeafButton() {
        $objectMap.put("filterSpeciesBatchLeafButton", filterSpeciesBatchLeafButton = new JRadioButton());
        
        filterSpeciesBatchLeafButton.setName("filterSpeciesBatchLeafButton");
        filterSpeciesBatchLeafButton.setText(_("tutti.label.filterSpeciesBatchMode.mode.leaf"));
        { filterSpeciesBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterSpeciesBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchLeafButton.setToolTipText(_("tutti.label.filterSpeciesBatchMode.mode.leaf.tip"));
        filterSpeciesBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchLeafButton"));
    }

    protected void createFilterSpeciesBatchMode() {
        $objectMap.put("filterSpeciesBatchMode", filterSpeciesBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterSpeciesBatchRootButton() {
        $objectMap.put("filterSpeciesBatchRootButton", filterSpeciesBatchRootButton = new JRadioButton());
        
        filterSpeciesBatchRootButton.setName("filterSpeciesBatchRootButton");
        filterSpeciesBatchRootButton.setText(_("tutti.label.filterSpeciesBatchMode.mode.root"));
        { filterSpeciesBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterSpeciesBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchRootButton.setToolTipText(_("tutti.label.filterSpeciesBatchMode.mode.root.tip"));
        filterSpeciesBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SpeciesBatchUIHandler.class));
    }

    protected void createLongTextEditor() {
        $objectMap.put("longTextEditor", longTextEditor = new LongTextEditorUI());
        
        longTextEditor.setName("longTextEditor");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesBatchUIModel.class));
    }

    protected void createRemoveSpeciesBatchMenu() {
        $objectMap.put("removeSpeciesBatchMenu", removeSpeciesBatchMenu = new JMenuItem());
        
        removeSpeciesBatchMenu.setName("removeSpeciesBatchMenu");
        removeSpeciesBatchMenu.setText(_("tutti.action.removeSpeciesBatch"));
        removeSpeciesBatchMenu.setMnemonic(82);
        removeSpeciesBatchMenu.setToolTipText(_("tutti.action.removeSpeciesBatch.tip"));
        removeSpeciesBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeSpeciesBatchMenu"));
    }

    protected void createRemoveSpeciesSubBatchMenu() {
        $objectMap.put("removeSpeciesSubBatchMenu", removeSpeciesSubBatchMenu = new JMenuItem());
        
        removeSpeciesSubBatchMenu.setName("removeSpeciesSubBatchMenu");
        removeSpeciesSubBatchMenu.setText(_("tutti.action.removeSpeciesSubBatch"));
        removeSpeciesSubBatchMenu.setMnemonic(82);
        removeSpeciesSubBatchMenu.setToolTipText(_("tutti.action.removeSpeciesSubBatch.tip"));
        removeSpeciesSubBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeSpeciesSubBatchMenu"));
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new NumberEditor(this));
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setProperty("speciesTotalSampleSortedWeight");
        speciesTotalSampleSortedWeightField.setUseFloat(false);
        speciesTotalSampleSortedWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSampleSortedWeight"));
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new NumberEditor(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setProperty("speciesTotalSortedWeight");
        speciesTotalSortedWeightField.setUseFloat(false);
        speciesTotalSortedWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSortedWeight"));
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.setEnabled(false);
        speciesTotalUnsortedWeightField.setEditable(false);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(_("tutti.label.catches.speciesTotalUnsortedWeight"));
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new NumberEditor(this));
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setProperty("speciesTotalWeight");
        speciesTotalWeightField.setUseFloat(false);
        speciesTotalWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(_("tutti.label.catches.speciesTotalWeight"));
    }

    protected void createSplitSpeciesBatchMenu() {
        $objectMap.put("splitSpeciesBatchMenu", splitSpeciesBatchMenu = new JMenuItem());
        
        splitSpeciesBatchMenu.setName("splitSpeciesBatchMenu");
        splitSpeciesBatchMenu.setText(_("tutti.action.splitSpeciesBatch"));
        splitSpeciesBatchMenu.setMnemonic(83);
        splitSpeciesBatchMenu.setToolTipText(_("tutti.action.splitSpeciesBatch.tip"));
        splitSpeciesBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__splitSpeciesBatchMenu"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        addChildrenToFilterTablePane();
        addChildrenToFilterSpeciesBatchAllButton();
        addChildrenToFilterSpeciesBatchLeafButton();
        addChildrenToFilterSpeciesBatchRootButton();
        addChildrenToTableScrollPane();
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 23 property setters
        splitSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        removeSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesSubBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalWeightField.setBean(model);
        speciesTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightField.setBean(model);
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalSampleSortedWeightField.setBean(model);
        speciesTotalSampleSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSampleSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        createSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createLongTextEditor();
        createAttachmentEditor();
        createTablePopup();
        createSplitSpeciesBatchMenu();
        createRemoveSpeciesBatchMenu();
        createRemoveSpeciesSubBatchMenu();
        createForm();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createTableToolbar();
        createCreateSpeciesBatchButton();
        createFilterTablePane();
        createFilterSpeciesBatchLabel();
        createFilterSpeciesBatchAllButton();
        createFilterSpeciesBatchLeafButton();
        createFilterSpeciesBatchRootButton();
        createTableScrollPane();
        createTable();
        createFilterSpeciesBatchMode();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSpeciesSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSpeciesSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSpeciesSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalWeightField.setModel(model.getSpeciesTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setModel(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSampleSortedWeightField.setModel(model.getSpeciesTotalSampleSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSampleSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, getStringValue(model.getSpeciesTotalUnsortedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_SPECIES_BATCH_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("createSpeciesBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createSpeciesBatchButton.setEnabled(model.isCreateSpeciesBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("createSpeciesBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
    }

}