package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SampleCategory.java 197 2013-01-14 21:43:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/SampleCategory.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.io.Serializable;

/**
 * Represents a sample category value in the species batch table.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class SampleCategory<C extends Serializable> implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Sample category type.
     *
     * @since 0.3
     */
    protected SampleCategoryType categoryType;

    /**
     * Sample category value.
     *
     * @since 0.3
     */
    protected C categoryValue;

    /**
     * Sample category weight.
     *
     * @since 0.3
     */
    protected Float categoryWeight;

    public static <C extends Serializable> SampleCategory<C> newSample(SampleCategoryType categoryType) {
        SampleCategory<C> result = new SampleCategory<C>();
        result.setCategoryType(categoryType);
        return result;
    }

    protected SampleCategory() {
    }

    public SampleCategoryType getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(SampleCategoryType categoryType) {
        this.categoryType = categoryType;
    }

    public C getCategoryValue() {
        return categoryValue;
    }

    public void setCategoryValue(C categoryValue) {
        this.categoryValue = categoryValue;
    }

    public Float getCategoryWeight() {
        return categoryWeight;
    }

    public void setCategoryWeight(Float categoryWeight) {
        this.categoryWeight = categoryWeight;
    }

    public boolean isValid() {
        return categoryValue != null && categoryWeight != null;
    }

    public boolean isEmpty() {
        return categoryValue == null && categoryWeight == null;
    }

    public boolean isEmptyOrValid() {
        return isEmpty() || isValid();
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).
                appendSuper(super.toString()).
                toString();
    }
}
