package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.SwingValidatorMessageWidget;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class MainUI extends JFrame implements TuttiUI<TuttiUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MENU_ACTION_FILL_CATCHES_ENABLED = "menuActionFillCatches.enabled";
    public static final String BINDING_MENU_ACTION_MANAGE_PROTOCOL_ENABLED = "menuActionManageProtocol.enabled";
    public static final String BINDING_MENU_ACTION_SELECT_CAMPAIGN_ENABLED = "menuActionSelectCampaign.enabled";
    public static final String BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED = "menuActionValidateCatches.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected MainUIHandler handler;
    protected MainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenuItem menuActionFillCatches;
    protected JMenuItem menuActionManageProtocol;
    protected JMenuItem menuActionSelectCampaign;
    protected JMenuItem menuActionValidateCatches;
    protected JMenu menuActions;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpSite;
    protected JMenuItem menuSynchronisationAllegro;
    protected JMenuItem menuSynchronisationExport;
    protected JMenuItem menuSynchronisationImport;
    protected JMenu menuSynchronisations;
    protected TuttiUIContext model;
    protected StatusMessagePanel status;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            getHandler().afterInitUI();
        }
        
        public void registerValidator(SwingValidator validator) {
            handler.registerValidator(validator);
        }
        
        public void clearValidators() {
            handler.clearValidators();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(TuttiUIContext context) {
        setContextValue(context);
                MainUIHandler handler = new MainUIHandler(context, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuActionFillCatches(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFillCatches();
    }

    public void doActionPerformed__on__menuActionManageProtocol(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showManageProtocol();
    }

    public void doActionPerformed__on__menuActionSelectCampaign(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showSelectCampaign();
    }

    public void doActionPerformed__on__menuActionValidateCatches(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showFillCatches();
    }

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showConfig();
    }

    public void doActionPerformed__on__menuFileExit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeTutti();
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAbout();
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().gotoSite();
    }

    public void doActionPerformed__on__menuSynchronisationAllegro(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAllegroScreen();
    }

    public void doActionPerformed__on__menuSynchronisationExport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showExportScreen();
    }

    public void doActionPerformed__on__menuSynchronisationImport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showImportScreen();
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeTutti();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenuItem getMenuActionFillCatches() {
        return menuActionFillCatches;
    }

    public JMenuItem getMenuActionManageProtocol() {
        return menuActionManageProtocol;
    }

    public JMenuItem getMenuActionSelectCampaign() {
        return menuActionSelectCampaign;
    }

    public JMenuItem getMenuActionValidateCatches() {
        return menuActionValidateCatches;
    }

    public JMenu getMenuActions() {
        return menuActions;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JMenuItem getMenuSynchronisationAllegro() {
        return menuSynchronisationAllegro;
    }

    public JMenuItem getMenuSynchronisationExport() {
        return menuSynchronisationExport;
    }

    public JMenuItem getMenuSynchronisationImport() {
        return menuSynchronisationImport;
    }

    public JMenu getMenuSynchronisations() {
        return menuSynchronisations;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(validatorMessageWidget);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(bottomBar);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuActions);
        menu.add(menuSynchronisations);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuActions() {
        if (!allComponentsCreated) {
            return;
        }
        menuActions.add(menuActionManageProtocol);
        menuActions.add(menuActionSelectCampaign);
        menuActions.add(menuActionFillCatches);
        menuActions.add(menuActionValidateCatches);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void addChildrenToMenuSynchronisations() {
        if (!allComponentsCreated) {
            return;
        }
        menuSynchronisations.add(menuSynchronisationImport);
        menuSynchronisations.add(menuSynchronisationExport);
        menuSynchronisations.add(menuSynchronisationAllegro);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setFloatable(false);
        bottomBar.setBorderPainted(false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(MainUIHandler.class));
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuActionFillCatches() {
        $objectMap.put("menuActionFillCatches", menuActionFillCatches = new JMenuItem());
        
        menuActionFillCatches.setName("menuActionFillCatches");
        menuActionFillCatches.setText(_("tutti.action.fillCatches"));
        menuActionFillCatches.setMnemonic(67);
        menuActionFillCatches.setToolTipText(_("tutti.action.fillCatches.tip"));
        menuActionFillCatches.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuActionFillCatches"));
    }

    protected void createMenuActionManageProtocol() {
        $objectMap.put("menuActionManageProtocol", menuActionManageProtocol = new JMenuItem());
        
        menuActionManageProtocol.setName("menuActionManageProtocol");
        menuActionManageProtocol.setText(_("tutti.action.manageProtocol"));
        menuActionManageProtocol.setMnemonic(80);
        menuActionManageProtocol.setToolTipText(_("tutti.action.manageProtocol.tip"));
        menuActionManageProtocol.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuActionManageProtocol"));
    }

    protected void createMenuActionSelectCampaign() {
        $objectMap.put("menuActionSelectCampaign", menuActionSelectCampaign = new JMenuItem());
        
        menuActionSelectCampaign.setName("menuActionSelectCampaign");
        menuActionSelectCampaign.setText(_("tutti.action.selectCampaign"));
        menuActionSelectCampaign.setMnemonic(83);
        menuActionSelectCampaign.setToolTipText(_("tutti.action.selectCampaign.tip"));
        menuActionSelectCampaign.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuActionSelectCampaign"));
    }

    protected void createMenuActionValidateCatches() {
        $objectMap.put("menuActionValidateCatches", menuActionValidateCatches = new JMenuItem());
        
        menuActionValidateCatches.setName("menuActionValidateCatches");
        menuActionValidateCatches.setText(_("tutti.action.validateCatches"));
        menuActionValidateCatches.setMnemonic(86);
        menuActionValidateCatches.setToolTipText(_("tutti.action.validateCatches.tip"));
        menuActionValidateCatches.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuActionValidateCatches"));
    }

    protected void createMenuActions() {
        $objectMap.put("menuActions", menuActions = new JMenu());
        
        menuActions.setName("menuActions");
        menuActions.setText(_("tutti.menu.actions"));
        menuActions.setMnemonic(65);
        menuActions.setToolTipText(_("tutti.menu.actions.tip"));
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("tutti.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.setToolTipText(_("tutti.menu.file.tip"));
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("tutti.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("tutti.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("tutti.action.exit"));
        menuFileExit.setToolTipText(_("tutti.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("tutti.menu.help"));
        menuHelp.setMnemonic(69);
        menuHelp.setToolTipText(_("tutti.menu.help.tip"));
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("tutti.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("tutti.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("tutti.action.site"));
        menuHelpSite.setMnemonic(83);
        menuHelpSite.setToolTipText(_("tutti.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
    }

    protected void createMenuSynchronisationAllegro() {
        $objectMap.put("menuSynchronisationAllegro", menuSynchronisationAllegro = new JMenuItem());
        
        menuSynchronisationAllegro.setName("menuSynchronisationAllegro");
        menuSynchronisationAllegro.setEnabled(false);
        menuSynchronisationAllegro.setText(_("tutti.menu.synchronisationAllegro"));
        menuSynchronisationAllegro.setMnemonic(65);
        menuSynchronisationAllegro.setToolTipText(_("tutti.menu.synchronisationAllegro.tip"));
        menuSynchronisationAllegro.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuSynchronisationAllegro"));
    }

    protected void createMenuSynchronisationExport() {
        $objectMap.put("menuSynchronisationExport", menuSynchronisationExport = new JMenuItem());
        
        menuSynchronisationExport.setName("menuSynchronisationExport");
        menuSynchronisationExport.setEnabled(false);
        menuSynchronisationExport.setText(_("tutti.menu.synchronisationExport"));
        menuSynchronisationExport.setMnemonic(69);
        menuSynchronisationExport.setToolTipText(_("tutti.menu.synchronisationExport.tip"));
        menuSynchronisationExport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuSynchronisationExport"));
    }

    protected void createMenuSynchronisationImport() {
        $objectMap.put("menuSynchronisationImport", menuSynchronisationImport = new JMenuItem());
        
        menuSynchronisationImport.setName("menuSynchronisationImport");
        menuSynchronisationImport.setEnabled(false);
        menuSynchronisationImport.setText(_("tutti.menu.synchronisationImport"));
        menuSynchronisationImport.setMnemonic(73);
        menuSynchronisationImport.setToolTipText(_("tutti.menu.synchronisationImport.tip"));
        menuSynchronisationImport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuSynchronisationImport"));
    }

    protected void createMenuSynchronisations() {
        $objectMap.put("menuSynchronisations", menuSynchronisations = new JMenu());
        
        menuSynchronisations.setName("menuSynchronisations");
        menuSynchronisations.setText(_("tutti.menu.synchronisations"));
        menuSynchronisations.setMnemonic(83);
        menuSynchronisations.setToolTipText(_("tutti.menu.synchronisations.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuActions();
        addChildrenToMenuSynchronisations();
        addChildrenToMenuHelp();
        addChildrenToBottomBar();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuActionValidateCatches.setIcon(SwingUtil.createActionIcon("validate"));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createHandler();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileExit();
        createMenuActions();
        createMenuActionManageProtocol();
        createMenuActionSelectCampaign();
        createMenuActionFillCatches();
        createMenuActionValidateCatches();
        createMenuSynchronisations();
        createMenuSynchronisationImport();
        createMenuSynchronisationExport();
        createMenuSynchronisationAllegro();
        createMenuHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createBottomBar();
        createValidatorMessageWidget();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,600);
        SwingUtil.setComponentWidth(mainFrame,800);
        setTitle(_("tutti.application.name"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_MANAGE_PROTOCOL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("protocolFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionManageProtocol.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROTOCOL && model.isProtocolFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("protocolFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_SELECT_CAMPAIGN_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionSelectCampaign.setEnabled(model.getScreen() != TuttiScreen.SELECT_CRUISE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_FILL_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseContextFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionFillCatches.setEnabled(model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION && model.isCruiseContextFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseContextFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseContextFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionValidateCatches.setEnabled(model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION && model.isCruiseContextFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseContextFilled", this);
                }
            }
        });
    }

}