/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.editor;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentEditorUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.HBox;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentEditorUIHandler {
    private static final Log log = LogFactory.getLog(AttachmentEditorUIHandler.class);
    private final AttachmentEditorUI ui;
    private JFileChooser fileChooser = new JFileChooser();

    public AttachmentEditorUIHandler(AttachmentEditorUI attachmentEditorUI) {
        this.ui = attachmentEditorUI;
        this.ui.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AttachmentEditorUIHandler.this.init();
            }
        });
    }

    public void init() {
        List list;
        this.resetFields();
        this.ui.getAttachments().removeAll();
        AbstractTuttiBeanUIModel bean = this.ui.getBean();
        String property = this.ui.getProperty();
        if (bean != null && !StringUtils.isEmpty((CharSequence)property) && (list = (List)TuttiUIUtil.getProperty((Object)bean, property)) != null) {
            for (Attachment attachment : list) {
                this.addAttachment(attachment);
            }
        }
    }

    protected void addAttachment(final Attachment attachment) {
        final HBox hbox = new HBox();
        hbox.setVerticalAlignment(0);
        JButton deleteButton = new JButton(SwingUtil.createActionIcon((String)"delete"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String property;
                AbstractTuttiBeanUIModel bean = AttachmentEditorUIHandler.this.ui.getBean();
                List list = (List)TuttiUIUtil.getProperty((Object)bean, property = AttachmentEditorUIHandler.this.ui.getProperty());
                if (list != null) {
                    list.remove(attachment);
                    TuttiUIUtil.setProperty((Object)bean, property, list);
                }
                AttachmentEditorUIHandler.this.ui.getAttachments().remove((Component)hbox);
                JDialog parent = (JDialog)SwingUtil.getParentContainer((Object)((Object)AttachmentEditorUIHandler.this.ui), JDialog.class);
                parent.pack();
            }
        });
        hbox.add((Component)deleteButton);
        final JLabel label = new JLabel("<html><body><a href=''>" + attachment.getName() + "</a></body></html>");
        label.setToolTipText(attachment.getComment());
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingUtil.openLink((String)("file://" + attachment.getFile().getAbsolutePath()));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setCursor(Cursor.getDefaultCursor());
            }
        });
        hbox.add((Component)label);
        this.ui.getAttachments().add((Component)hbox);
    }

    public void close() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will close UI " + (Object)((Object)this.ui)));
        }
        ((Window)SwingUtil.getParentContainer((Object)((Object)this.ui), Window.class)).dispose();
    }

    public void chooseFile() {
        if (this.fileChooser.showOpenDialog((Component)((Object)this.ui)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.ui.getModel().setFile(file);
            this.ui.getFile().setText(file.getAbsolutePath());
        }
    }

    public void addAttachment() {
        Attachment attachment;
        File file;
        String property;
        AbstractTuttiBeanUIModel bean = this.ui.getBean();
        List list = (List)TuttiUIUtil.getProperty((Object)bean, property = this.ui.getProperty());
        if (list == null) {
            list = Lists.newArrayList();
        }
        if ((file = (attachment = this.ui.getModel()).getFile()) != null) {
            String name = this.ui.getFileName().getText();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = file.getName();
            }
            attachment.setName(name);
            attachment.setComment(this.ui.getFileComment().getText());
            list.add(attachment);
            TuttiUIUtil.setProperty((Object)bean, property, list);
            this.resetFields();
            this.addAttachment(attachment);
            JDialog parent = (JDialog)SwingUtil.getParentContainer((Object)((Object)this.ui), JDialog.class);
            parent.pack();
        }
    }

    protected void resetFields() {
        this.ui.setModel(new Attachment());
        this.fileChooser.setSelectedFile(null);
        this.ui.getFile().setText("");
        this.ui.getFileName().setText("");
        this.ui.getFileComment().setText("");
    }
}

