package fr.ifremer.tutti.ui.swing.content.operation.accidental;

/*
 * #%L
 * Tutti :: UI
 * $Id: AccidentalBatchUIModel.java 55 2012-12-13 01:57:28Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/accidental/AccidentalBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class AccidentalBatchUIModel extends AbstractTuttiTableUIModel<FishingOperation, AccidentalBatchRowModel, AccidentalBatchUIModel> {

    private static final long serialVersionUID = 1L;

    /**
     * Editing fishing operation.
     *
     * @since 0.2
     */
    protected FishingOperation fishingOperation;


    protected static final Binder<FishingOperation, AccidentalBatchUIModel> fromBeanBinder = BinderModelBuilder.newEmptyBuilder(FishingOperation.class, AccidentalBatchUIModel.class)
            .addProperty(FishingOperation.PROPERTY_ID, PROPERTY_ID)
            .toBinder();

    protected static final Binder<AccidentalBatchUIModel, FishingOperation> toBeanBinder = BinderModelBuilder.newEmptyBuilder(AccidentalBatchUIModel.class, FishingOperation.class)
            .toBinder();


    public AccidentalBatchUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
    }

    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }


    @Override
    protected FishingOperation newEntity() {
        return fishingOperation;
    }
}