/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.program;

import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIModel;
import javax.swing.JTable;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProgramUIHandler
extends AbstractTuttiUIHandler<EditProgramUIModel> {
    private static final Log log = LogFactory.getLog(EditProgramUIHandler.class);
    private final EditProgramUI ui;
    private final PersistenceService persistenceService;

    public EditProgramUIHandler(TuttiUIContext context, EditProgramUI ui) {
        super(context);
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        EditProgramUIModel model = new EditProgramUIModel();
        String surveyId = this.context.getProgramId();
        if (surveyId == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Edit new program");
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Edit existing program " + surveyId));
            }
            Program program = this.persistenceService.getProgram(surveyId);
            model.fromBean(program);
        }
        this.listModelIsModify(model);
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        EditProgramUIModel model = this.getModel();
        this.initBeanComboBox(this.ui.getZoneComboBox(), this.persistenceService.getAllZone(), model.getZone());
        SwingValidatorUtil.installUI((JTable)this.ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new SwingValidatorMessageTableRenderer());
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), model);
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        this.ui.getValidator().setBean(null);
    }

    @Override
    protected EditProgramUIModel getModel() {
        return this.ui.getModel();
    }

    public void cancel() {
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }

    public void save() {
        EditProgramUIModel model = this.getModel();
        Program bean = (Program)model.toBean();
        Program saved = TuttiEntities.isNew((IdAware)bean) ? this.persistenceService.createProgram(bean) : this.persistenceService.saveProgram(bean);
        this.context.setProgramId(saved.getId());
        this.context.setScreen(TuttiScreen.SELECT_CRUISE);
    }
}

