package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: SpeciesBatchUIModel.java 145 2013-01-02 18:17:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/SpeciesBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;

import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SpeciesBatchUIModel extends AbstractTuttiBatchUIModel<SpeciesBatchRowModel, SpeciesBatchUIModel> {

    private static final long serialVersionUID = 1L;


    public static final String PROPERTY_TABLE_VIEW_MODE = "tableViewMode";

    public static final String PROPERTY_AVAILABLE_SPECIES = "availableSpecies";

    public static final String PROPERTY_ALL_SPECIES = "allSpecies";

    public static final String PROPERTY_CREATE_SPECIES_BATCH_ENABLED = "createSpeciesBatchEnabled";

    public static final String PROPERTY_SPLIT_SPECIES_BATCH_ENABLED = "splitSpeciesBatchEnabled";

    public static final String PROPERTY_REMOVE_SPECIES_SUB_BATCH_ENABLED = "removeSpeciesSubBatchEnabled";

    /**
     * Sampling order (sets by protocol).
     *
     * @since 0.2
     */
    protected List<SampleCategoryType> samplingOrder;

    /**
     * All usable species (sets by protocol).
     *
     * @since 0.3
     */
    protected List<Species> allSpecies;

    /**
     * All available species (says available species that are not used in any batch).
     *
     * @since 0.3
     */
    protected List<Species> availableSpecies;

    /**
     * What to show in the table.
     *
     * @since 0.3
     */
    protected TableViewMode tableViewMode;

    /**
     * Can user create a new species batch ?
     *
     * @since 0.3
     */
    protected boolean createSpeciesBatchEnabled;

    /**
     * Can user split a selected species batch ?
     *
     * @since 0.3
     */
    protected boolean splitSpeciesBatchEnabled;

    /**
     * Can user remove a selected species sub batches?
     *
     * @since 0.3
     */
    protected boolean removeSpeciesSubBatchEnabled;

    public SpeciesBatchUIModel(EditCatchesUIModel catchesUIModel) {
        super(catchesUIModel,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_WEIGHT,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT);
    }

    public Float getSpeciesTotalWeight() {
        return catchesUIModel.getSpeciesTotalWeight();
    }

    public void setSpeciesTotalWeight(Float speciesTotalWeight) {
        catchesUIModel.setSpeciesTotalWeight(speciesTotalWeight);
    }

    public Float getSpeciesTotalSortedWeight() {
        return catchesUIModel.getSpeciesTotalSortedWeight();
    }

    public void setSpeciesTotalSortedWeight(Float speciesTotalSortedWeight) {
        catchesUIModel.setSpeciesTotalSortedWeight(speciesTotalSortedWeight);
    }

    public Float getSpeciesTotalSampleSortedWeight() {
        return catchesUIModel.getSpeciesTotalSampleSortedWeight();
    }

    public void setSpeciesTotalSampleSortedWeight(Float speciesSampleSortedWeight) {
        catchesUIModel.setSpeciesTotalSampleSortedWeight(speciesSampleSortedWeight);
    }

    public Float getSpeciesTotalUnsortedWeight() {
        return catchesUIModel.getSpeciesTotalUnsortedWeight();
    }

    public void setSpeciesTotalUnsortedWeight(Float speciesTotalUnsortedWeight) {
        catchesUIModel.setSpeciesTotalUnsortedWeight(speciesTotalUnsortedWeight);
    }

    public List<SampleCategoryType> getSamplingOrder() {
        return samplingOrder;
    }

    public void setSamplingOrder(List<SampleCategoryType> samplingOrder) {
        this.samplingOrder = samplingOrder;
    }

    public TableViewMode getTableViewMode() {
        return tableViewMode;
    }

    public void setTableViewMode(TableViewMode tableViewMode) {
        Object oldValue = getTableViewMode();
        this.tableViewMode = tableViewMode;
        firePropertyChange(PROPERTY_TABLE_VIEW_MODE, oldValue, tableViewMode);
        firePropertyChange("tableViewModeAll", null, isTableViewModeAll());
        firePropertyChange("tableViewModeLeaf", null, isTableViewModeLeaf());
        firePropertyChange("tableViewModeRoot", null, isTableViewModeRoot());
    }

    public boolean isTableViewModeAll() {
        return TableViewMode.ALL.equals(tableViewMode);
    }

    public boolean isTableViewModeLeaf() {
        return TableViewMode.LEAF.equals(tableViewMode);
    }

    public boolean isTableViewModeRoot() {
        return TableViewMode.ROOT.equals(tableViewMode);
    }

    public List<Species> getAllSpecies() {
        return allSpecies;
    }

    public void setAllSpecies(List<Species> allSpecies) {
        Object oldValue = getAllSpecies();
        this.allSpecies = allSpecies;
        firePropertyChange(PROPERTY_ALL_SPECIES, oldValue, allSpecies);
    }

    public List<Species> getAvailableSpecies() {
        return availableSpecies;
    }

    public void setAvailableSpecies(List<Species> availableSpecies) {
        Object oldValue = getAvailableSpecies();
        this.availableSpecies = availableSpecies;
        firePropertyChange(PROPERTY_AVAILABLE_SPECIES, oldValue, availableSpecies);
    }

    public boolean isCreateSpeciesBatchEnabled() {
        return createSpeciesBatchEnabled;
    }

    public void setCreateSpeciesBatchEnabled(boolean createSpeciesBatchEnabled) {
        Object oldValue = isCreateSpeciesBatchEnabled();
        this.createSpeciesBatchEnabled = createSpeciesBatchEnabled;
        firePropertyChange(PROPERTY_CREATE_SPECIES_BATCH_ENABLED, oldValue, createSpeciesBatchEnabled);
    }

    public boolean isSplitSpeciesBatchEnabled() {
        return splitSpeciesBatchEnabled;
    }

    public void setSplitSpeciesBatchEnabled(boolean splitSpeciesBatchEnabled) {
        Object oldValue = isSplitSpeciesBatchEnabled();
        this.splitSpeciesBatchEnabled = splitSpeciesBatchEnabled;
        firePropertyChange(PROPERTY_SPLIT_SPECIES_BATCH_ENABLED, oldValue, splitSpeciesBatchEnabled);
    }

    public boolean isRemoveSpeciesSubBatchEnabled() {
        return removeSpeciesSubBatchEnabled;
    }

    public void setRemoveSpeciesSubBatchEnabled(boolean removeSpeciesSubBatchEnabled) {
        Object oldValue = isRemoveSpeciesSubBatchEnabled();
        this.removeSpeciesSubBatchEnabled = removeSpeciesSubBatchEnabled;
        firePropertyChange(PROPERTY_REMOVE_SPECIES_SUB_BATCH_ENABLED, oldValue, removeSpeciesSubBatchEnabled);
    }
}
