package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosBatchUIModel.java 105 2012-12-21 20:51:46Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/BenthosBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class BenthosBatchUIModel extends AbstractTuttiBatchUIModel<BenthosBatchRowModel, BenthosBatchUIModel> {

    private static final long serialVersionUID = 1L;

    public BenthosBatchUIModel(EditCatchesUIModel catchesUIModel) {
        super(catchesUIModel,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_WEIGHT,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT,
              EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT);
    }

    public Float getBenthosTotalWeight() {
        return catchesUIModel.getBenthosTotalWeight();
    }

    public void setBenthosTotalWeight(Float benthosTotalWeight) {
        catchesUIModel.setBenthosTotalWeight(benthosTotalWeight);
    }

    public Float getBenthosTotalSampleSortedWeight() {
        return catchesUIModel.getBenthosTotalSampleSortedWeight();
    }

    public void setBenthosTotalSampleSortedWeight(Float benthosTotalSampleSortedWeight) {
        catchesUIModel.setBenthosTotalSampleSortedWeight(benthosTotalSampleSortedWeight);
    }

    public Float getBenthosTotalSortedWeight() {
        return catchesUIModel.getBenthosTotalSortedWeight();
    }

    public void setBenthosTotalSortedWeight(Float benthosTotalSortedWeight) {
        catchesUIModel.setBenthosTotalSortedWeight(benthosTotalSortedWeight);
    }

    public Float getBenthosTotalUnsortedWeight() {
        return catchesUIModel.getBenthosTotalUnsortedWeight();
    }

    public void setBenthosTotalUnsortedWeight(Float benthosTotalUnsortedWeight) {
        catchesUIModel.setBenthosTotalUnsortedWeight(benthosTotalUnsortedWeight);
    }
}