package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCatchesUIModel.java 111 2012-12-27 14:49:03Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/EditCatchesUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditCatchesUIModel extends AbstractTuttiBeanUIModel<FishingOperation, EditCatchesUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CATCH_TOTAL_WEIGHT = "catchTotalWeight";

    public static final String PROPERTY_CATCH_TOTAL_SORTED_TREMIS_WEIGHT = "catchTotalSortedTremisWeight";

    public static final String PROPERTY_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT = "catchTotalSortedCarousselWeight";

    public static final String PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT = "catchTotalRejectedWeight";

    public static final String PROPERTY_CATCH_TOTAL_UNSORTED_WEIGHT = "catchTotalUnsortedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_WEIGHT = "speciesTotalWeight";

    public static final String PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT = "speciesTotalSortedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT = "speciesTotalSampleSortedWeight";

    public static final String PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT = "speciesTotalUnsortedWeight";

    public static final String PROPERTY_BENTHOS_TOTAL_WEIGHT = "benthosTotalWeight";

    public static final String PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT = "benthosTotalSortedWeight";

    public static final String PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT = "benthosTotalUnsortedWeight";

    public static final String PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT = "benthosTotalSampleSortedWeight";

    public static final String PROPERTY_PLANKTON_TOTAL_WEIGHT = "planktonTotalWeight";

    public static final String PROPERTY_PLANKTON_TOTAL_SAMPLE_WEIGHT = "planktonTotalSampleWeight";

    public static final String PROPERTY_MACRO_WASTE_TOTAL_WEIGHT = "macroWasteTotalWeight";

    public static final String PROPERTY_FISHING_OPERATION = "fishingOperation";

    protected static final Binder<FishingOperation, EditCatchesUIModel> fromBeanBinder = BinderModelBuilder.newEmptyBuilder(FishingOperation.class, EditCatchesUIModel.class)
            .addSimpleProperties(
                    PROPERTY_SPECIES_TOTAL_WEIGHT,
                    PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT,
                    PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT,
                    PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT,
                    PROPERTY_BENTHOS_TOTAL_WEIGHT,
                    PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT,
                    PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT,
                    PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT,
                    PROPERTY_PLANKTON_TOTAL_WEIGHT,
                    PROPERTY_PLANKTON_TOTAL_SAMPLE_WEIGHT,
                    PROPERTY_MACRO_WASTE_TOTAL_WEIGHT
            ).toBinder();

    protected static final Binder<EditCatchesUIModel, FishingOperation> toBeanBinder = BinderModelBuilder.newEmptyBuilder(EditCatchesUIModel.class, FishingOperation.class)
            .addSimpleProperties(
                    PROPERTY_SPECIES_TOTAL_WEIGHT,
                    PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT,
                    PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT,
                    PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT,
                    PROPERTY_BENTHOS_TOTAL_WEIGHT,
                    PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT,
                    PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT,
                    PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT,
                    PROPERTY_PLANKTON_TOTAL_WEIGHT,
                    PROPERTY_PLANKTON_TOTAL_SAMPLE_WEIGHT,
                    PROPERTY_MACRO_WASTE_TOTAL_WEIGHT
            ).toBinder();

    protected Float speciesTotalWeight;

    protected Float speciesTotalSortedWeight;

    protected Float speciesTotalSampleSortedWeight;

    protected Float speciesTotalUnsortedWeight;

    protected Float benthosTotalWeight;

    protected Float benthosTotalSortedWeight;

    protected Float benthosTotalUnsortedWeight;

    protected Float benthosTotalSampleSortedWeight;

    protected Float planktonTotalWeight;

    protected Float planktonTotalSampleWeight;

    protected Float macroWasteTotalWeight;

    protected Float catchTotalWeight;

    protected Float catchTotalSortedTremisWeight;

    protected Float catchTotalSortedCarousselWeight;

    protected Float catchTotalRejectedWeight;

    protected Float catchTotalUnsortedWeight;

    protected FishingOperation fishingOperation;

    public EditCatchesUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
    }

    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        Object oldValue = getFishingOperation();
        this.fishingOperation = fishingOperation;
        firePropertyChange(PROPERTY_FISHING_OPERATION, oldValue, fishingOperation);
    }

    public Float getCatchTotalWeight() {
        return catchTotalWeight;
    }

    public void setCatchTotalWeight(Float catchTotalWeight) {
        Object oldValue = getCatchTotalWeight();
        this.catchTotalWeight = catchTotalWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_WEIGHT, oldValue, catchTotalWeight);
    }

    public Float getCatchTotalSortedTremisWeight() {
        return catchTotalSortedTremisWeight;
    }

    public void setCatchTotalSortedTremisWeight(Float catchTotalSortedTremisWeight) {
        Object oldValue = getCatchTotalSortedTremisWeight();
        this.catchTotalSortedTremisWeight = catchTotalSortedTremisWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_SORTED_TREMIS_WEIGHT, oldValue, catchTotalSortedTremisWeight);
    }

    public Float getCatchTotalSortedCarousselWeight() {
        return catchTotalSortedCarousselWeight;
    }

    public void setCatchTotalSortedCarousselWeight(Float catchTotalSortedCarousselWeight) {
        Object oldValue = getCatchTotalSortedCarousselWeight();
        this.catchTotalSortedCarousselWeight = catchTotalSortedCarousselWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT, oldValue, catchTotalSortedCarousselWeight);
    }

    public Float getCatchTotalRejectedWeight() {
        return catchTotalRejectedWeight;
    }

    public void setCatchTotalRejectedWeight(Float catchTotalRejectedWeight) {
        Object oldValue = getCatchTotalRejectedWeight();
        this.catchTotalRejectedWeight = catchTotalRejectedWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT, oldValue, catchTotalRejectedWeight);
    }

    public Float getCatchTotalUnsortedWeight() {
        return catchTotalUnsortedWeight;
    }

    public void setCatchTotalUnsortedWeight(Float catchTotalUnsortedWeight) {
        Object oldValue = getCatchTotalUnsortedWeight();
        this.catchTotalUnsortedWeight = catchTotalUnsortedWeight;
        firePropertyChange(PROPERTY_CATCH_TOTAL_UNSORTED_WEIGHT, oldValue, catchTotalUnsortedWeight);
    }

    public Float getSpeciesTotalWeight() {
        return speciesTotalWeight;
    }

    public void setSpeciesTotalWeight(Float speciesTotalWeight) {
        Object oldValue = getSpeciesTotalWeight();
        this.speciesTotalWeight = speciesTotalWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_WEIGHT, oldValue, speciesTotalWeight);
    }

    public Float getSpeciesTotalSortedWeight() {
        return speciesTotalSortedWeight;
    }

    public void setSpeciesTotalSortedWeight(Float speciesTotalSortedWeight) {
        Object oldValue = getSpeciesTotalSortedWeight();
        this.speciesTotalSortedWeight = speciesTotalSortedWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT, oldValue, speciesTotalSortedWeight);
    }

    public Float getSpeciesTotalSampleSortedWeight() {
        return speciesTotalSampleSortedWeight;
    }

    public void setSpeciesTotalSampleSortedWeight(Float speciesTotalSampleSortedWeight) {
        Object oldValue = getSpeciesTotalSampleSortedWeight();
        this.speciesTotalSampleSortedWeight = speciesTotalSampleSortedWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT, oldValue, speciesTotalSampleSortedWeight);
    }

    public Float getSpeciesTotalUnsortedWeight() {
        return speciesTotalUnsortedWeight;
    }

    public void setSpeciesTotalUnsortedWeight(Float speciesTotalUnsortedWeight) {
        Object oldValue = getSpeciesTotalUnsortedWeight();
        this.speciesTotalUnsortedWeight = speciesTotalUnsortedWeight;
        firePropertyChange(PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT, oldValue, speciesTotalUnsortedWeight);
    }

    public Float getBenthosTotalWeight() {
        return benthosTotalWeight;
    }

    public void setBenthosTotalWeight(Float benthosTotalWeight) {
        Object oldValue = getBenthosTotalWeight();
        this.benthosTotalWeight = benthosTotalWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_WEIGHT, oldValue, benthosTotalWeight);
    }

    public Float getBenthosTotalSampleSortedWeight() {
        return benthosTotalSampleSortedWeight;
    }

    public void setBenthosTotalSampleSortedWeight(Float benthosTotalSampleSortedWeight) {
        Object oldValue = getBenthosTotalSampleSortedWeight();
        this.benthosTotalSampleSortedWeight = benthosTotalSampleSortedWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT, oldValue, benthosTotalSampleSortedWeight);
    }

    public Float getBenthosTotalSortedWeight() {
        return benthosTotalSortedWeight;
    }

    public void setBenthosTotalSortedWeight(Float benthosTotalSortedWeight) {
        Object oldValue = getBenthosTotalSortedWeight();
        this.benthosTotalSortedWeight = benthosTotalSortedWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT, oldValue, benthosTotalSortedWeight);
    }

    public Float getBenthosTotalUnsortedWeight() {
        return benthosTotalUnsortedWeight;
    }

    public void setBenthosTotalUnsortedWeight(Float benthosTotalUnsortedWeight) {
        Object oldValue = getBenthosTotalUnsortedWeight();
        this.benthosTotalUnsortedWeight = benthosTotalUnsortedWeight;
        firePropertyChange(PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT, oldValue, benthosTotalUnsortedWeight);
    }

    public Float getPlanktonTotalWeight() {
        return planktonTotalWeight;
    }

    public void setPlanktonTotalWeight(Float planktonTotalWeight) {
        Object oldValue = getPlanktonTotalWeight();
        this.planktonTotalWeight = planktonTotalWeight;
        firePropertyChange(PROPERTY_PLANKTON_TOTAL_WEIGHT, oldValue, planktonTotalWeight);
    }

    public Float getPlanktonTotalSampleWeight() {
        return planktonTotalSampleWeight;
    }

    public void setPlanktonTotalSampleWeight(Float planktonTotalSampleWeight) {
        Object oldValue = getPlanktonTotalSampleWeight();
        this.planktonTotalSampleWeight = planktonTotalSampleWeight;
        firePropertyChange(PROPERTY_PLANKTON_TOTAL_SAMPLE_WEIGHT, oldValue, planktonTotalSampleWeight);
    }

    public Float getMacroWasteTotalWeight() {
        return macroWasteTotalWeight;
    }

    public void setMacroWasteTotalWeight(Float macroWasteTotalWeight) {
        Object oldValue = getMacroWasteTotalWeight();
        this.macroWasteTotalWeight = macroWasteTotalWeight;
        firePropertyChange(PROPERTY_MACRO_WASTE_TOTAL_WEIGHT, oldValue, macroWasteTotalWeight);
    }

    @Override
    protected FishingOperation newEntity() {
        return fishingOperation;
    }
}
